/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import java.util.List;
import java.util.stream.Collectors;
import org.projectnessie.error.ReferenceConflicts;
import org.projectnessie.model.Conflict;
import org.projectnessie.model.ContentKey;
import org.projectnessie.versioned.MergeResult;
import org.projectnessie.versioned.ReferenceConflictException;

public class MergeConflictException
extends ReferenceConflictException {
    private final MergeResult<?> mergeResult;

    public MergeConflictException(String message, MergeResult<?> mergeResult) {
        super(ReferenceConflicts.referenceConflicts(MergeConflictException.asReferenceConflicts(mergeResult)), message);
        this.mergeResult = mergeResult;
    }

    private static List<Conflict> asReferenceConflicts(MergeResult<?> mergeResult) {
        return mergeResult.getDetails().entrySet().stream().map(e -> {
            MergeResult.KeyDetails keyDetails = (MergeResult.KeyDetails)e.getValue();
            Conflict conflict = keyDetails.getConflict();
            return conflict != null ? conflict : Conflict.conflict((Conflict.ConflictType)Conflict.ConflictType.KEY_CONFLICT, (ContentKey)((ContentKey)e.getKey()), (String)"UNKNOWN");
        }).collect(Collectors.toList());
    }

    public MergeResult<?> getMergeResult() {
        return this.mergeResult;
    }
}

