/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import org.immutables.value.Value;
import org.projectnessie.model.Conflict;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Hashable;
import org.projectnessie.versioned.ImmutableKeyDetails;
import org.projectnessie.versioned.ImmutableMergeResult;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Result;

@Value.Immutable
public interface MergeResult<COMMIT>
extends Result {
    @Value.Default
    default public boolean wasApplied() {
        return false;
    }

    @Value.Default
    default public boolean wasSuccessful() {
        return false;
    }

    @Nullable
    public Hash getResultantTargetHash();

    @Nullable
    public Hash getCommonAncestor();

    public NamedRef getSourceRef();

    public BranchName getTargetBranch();

    public Hash getEffectiveTargetHash();

    @Nullable
    public Hash getExpectedHash();

    @Deprecated
    public List<COMMIT> getSourceCommits();

    @Nullable
    @Deprecated
    public List<COMMIT> getTargetCommits();

    public List<COMMIT> getCreatedCommits();

    public Map<ContentKey, KeyDetails> getDetails();

    public static <COMMIT extends Hashable> ImmutableMergeResult.Builder<COMMIT> builder() {
        return ImmutableMergeResult.builder();
    }

    @Deprecated
    public static enum ConflictType {
        NONE,
        UNRESOLVABLE;

    }

    @Value.Immutable
    public static interface KeyDetails {
        @Value.Parameter(order=1)
        public MergeBehavior getMergeBehavior();

        @Deprecated
        @Value.Default
        @Value.Parameter(order=2)
        default public ConflictType getConflictType() {
            return ConflictType.NONE;
        }

        @Deprecated
        public List<Hash> getSourceCommits();

        @Deprecated
        public List<Hash> getTargetCommits();

        @Nullable
        @Value.Parameter(order=3)
        public Conflict getConflict();

        public static ImmutableKeyDetails.Builder builder() {
            return ImmutableKeyDetails.builder();
        }

        public static KeyDetails keyDetails(MergeBehavior mergeBehavior, Conflict conflict) {
            return ImmutableKeyDetails.of(mergeBehavior, conflict != null ? ConflictType.UNRESOLVABLE : ConflictType.NONE, conflict);
        }
    }
}

