/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.versioned.KeyEntry;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="KeyEntry", generator="Immutables")
@Immutable
public final class ImmutableKeyEntry
implements KeyEntry {
    private final IdentifiedContentKey key;
    @jakarta.annotation.Nullable
    private final Content content;

    private ImmutableKeyEntry(IdentifiedContentKey key, @jakarta.annotation.Nullable Content content) {
        this.key = Objects.requireNonNull(key, "key");
        this.content = content;
    }

    private ImmutableKeyEntry(ImmutableKeyEntry original, IdentifiedContentKey key, @jakarta.annotation.Nullable Content content) {
        this.key = key;
        this.content = content;
    }

    @Override
    public IdentifiedContentKey getKey() {
        return this.key;
    }

    @Override
    @jakarta.annotation.Nullable
    public Content getContent() {
        return this.content;
    }

    public final ImmutableKeyEntry withKey(IdentifiedContentKey value) {
        if (this.key == value) {
            return this;
        }
        IdentifiedContentKey newValue = Objects.requireNonNull(value, "key");
        return ImmutableKeyEntry.validate(new ImmutableKeyEntry(this, newValue, this.content));
    }

    public final ImmutableKeyEntry withContent(@jakarta.annotation.Nullable Content value) {
        if (this.content == value) {
            return this;
        }
        return ImmutableKeyEntry.validate(new ImmutableKeyEntry(this, this.key, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyEntry && this.equalTo(0, (ImmutableKeyEntry)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeyEntry another) {
        return this.key.equals((Object)another.key) && Objects.equals(this.content, another.content);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + Objects.hashCode(this.content);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"KeyEntry").omitNullValues().add("key", (Object)this.key).add("content", (Object)this.content).toString();
    }

    public static ImmutableKeyEntry of(IdentifiedContentKey key, @jakarta.annotation.Nullable Content content) {
        return ImmutableKeyEntry.validate(new ImmutableKeyEntry(key, content));
    }

    private static ImmutableKeyEntry validate(ImmutableKeyEntry instance) {
        instance.verify();
        return instance;
    }

    public static ImmutableKeyEntry copyOf(KeyEntry instance) {
        if (instance instanceof ImmutableKeyEntry) {
            return (ImmutableKeyEntry)instance;
        }
        return ImmutableKeyEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="KeyEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private long initBits = 1L;
        @Nullable
        private IdentifiedContentKey key;
        @Nullable
        private Content content;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(KeyEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.getKey());
            Content contentValue = instance.getContent();
            if (contentValue != null) {
                this.content(contentValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(IdentifiedContentKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder content(@jakarta.annotation.Nullable Content content) {
            this.content = content;
            return this;
        }

        public ImmutableKeyEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableKeyEntry.validate(new ImmutableKeyEntry(null, this.key, this.content));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build KeyEntry, some of required attributes are not set " + attributes;
        }
    }
}

