/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Put;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Put", generator="Immutables")
@Immutable
public final class ImmutablePut
extends Put {
    private final boolean shouldMatchHash;
    private final ContentKey key;
    private final Supplier<Content> valueSupplier;
    private volatile transient long lazyInitBitmap;
    private static final long VALUE_LAZY_INIT_BIT = 1L;
    private transient Content value;

    private ImmutablePut(Builder builder) {
        this.key = builder.key;
        this.valueSupplier = builder.valueSupplier;
        this.shouldMatchHash = builder.shouldMatchHashIsSet() ? builder.shouldMatchHash : super.shouldMatchHash();
    }

    private ImmutablePut(boolean shouldMatchHash, ContentKey key, Supplier<Content> valueSupplier) {
        this.shouldMatchHash = shouldMatchHash;
        this.key = key;
        this.valueSupplier = valueSupplier;
    }

    @Override
    public boolean shouldMatchHash() {
        return this.shouldMatchHash;
    }

    @Override
    public ContentKey getKey() {
        return this.key;
    }

    @Override
    protected Supplier<Content> getValueSupplier() {
        return this.valueSupplier;
    }

    public final ImmutablePut withShouldMatchHash(boolean value) {
        if (this.shouldMatchHash == value) {
            return this;
        }
        return new ImmutablePut(value, this.key, this.valueSupplier);
    }

    public final ImmutablePut withKey(ContentKey value) {
        if (this.key == value) {
            return this;
        }
        ContentKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutablePut(this.shouldMatchHash, newValue, this.valueSupplier);
    }

    public final ImmutablePut withValueSupplier(Supplier<Content> value) {
        if (this.valueSupplier == value) {
            return this;
        }
        Supplier<Content> newValue = Objects.requireNonNull(value, "valueSupplier");
        return new ImmutablePut(this.shouldMatchHash, this.key, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Content getValue() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutablePut immutablePut = this;
            synchronized (immutablePut) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.value = Objects.requireNonNull(super.getValue(), "value");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.value;
    }

    public static ImmutablePut copyOf(Put instance) {
        if (instance instanceof ImmutablePut) {
            return (ImmutablePut)instance;
        }
        return ImmutablePut.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Put", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_VALUE_SUPPLIER = 2L;
        private static final long OPT_BIT_SHOULD_MATCH_HASH = 1L;
        private long initBits = 3L;
        private long optBits;
        private boolean shouldMatchHash;
        @Nullable
        private ContentKey key;
        @Nullable
        private Supplier<Content> valueSupplier;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Operation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Put instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Operation instance;
            if (object instanceof Operation) {
                instance = (Operation)object;
                this.shouldMatchHash(instance.shouldMatchHash());
                this.key(instance.getKey());
            }
            if (object instanceof Put) {
                instance = (Put)object;
                this.valueSupplier(((Put)instance).getValueSupplier());
            }
        }

        @CanIgnoreReturnValue
        public final Builder shouldMatchHash(boolean shouldMatchHash) {
            this.shouldMatchHash = shouldMatchHash;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(ContentKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder valueSupplier(Supplier<Content> valueSupplier) {
            this.valueSupplier = Objects.requireNonNull(valueSupplier, "valueSupplier");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePut build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePut(this);
        }

        private boolean shouldMatchHashIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("valueSupplier");
            }
            return "Cannot build Put, some of required attributes are not set " + attributes;
        }
    }
}

