/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.MergeBehavior;
import org.projectnessie.model.MergeKeyBehavior;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.VersionStore;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="VersionStore.TransplantOp", generator="Immutables")
@Immutable
public final class ImmutableTransplantOp
implements VersionStore.TransplantOp {
    private final NamedRef fromRef;
    private final BranchName toBranch;
    private final Optional<Hash> expectedHash;
    private final MetadataRewriter<CommitMeta> updateCommitMetadata;
    private final ImmutableMap<ContentKey, MergeKeyBehavior> mergeKeyBehaviors;
    private final MergeBehavior defaultMergeBehavior;
    private final boolean dryRun;
    private final boolean fetchAdditionalInfo;
    private final VersionStore.CommitValidator validator;
    private final ImmutableList<Hash> sequenceToTransplant;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTransplantOp(Builder builder) {
        this.fromRef = builder.fromRef;
        this.toBranch = builder.toBranch;
        this.mergeKeyBehaviors = builder.mergeKeyBehaviors.build();
        this.sequenceToTransplant = builder.sequenceToTransplant.build();
        if (builder.expectedHash != null) {
            this.initShim.expectedHash(builder.expectedHash);
        }
        if (builder.updateCommitMetadata != null) {
            this.initShim.updateCommitMetadata(builder.updateCommitMetadata);
        }
        if (builder.defaultMergeBehavior != null) {
            this.initShim.defaultMergeBehavior(builder.defaultMergeBehavior);
        }
        if (builder.dryRunIsSet()) {
            this.initShim.dryRun(builder.dryRun);
        }
        if (builder.fetchAdditionalInfoIsSet()) {
            this.initShim.fetchAdditionalInfo(builder.fetchAdditionalInfo);
        }
        if (builder.validator != null) {
            this.initShim.validator(builder.validator);
        }
        this.expectedHash = this.initShim.expectedHash();
        this.updateCommitMetadata = this.initShim.updateCommitMetadata();
        this.defaultMergeBehavior = this.initShim.defaultMergeBehavior();
        this.dryRun = this.initShim.dryRun();
        this.fetchAdditionalInfo = this.initShim.fetchAdditionalInfo();
        this.validator = this.initShim.validator();
        this.initShim = null;
    }

    private ImmutableTransplantOp(NamedRef fromRef, BranchName toBranch, Optional<Hash> expectedHash, MetadataRewriter<CommitMeta> updateCommitMetadata, ImmutableMap<ContentKey, MergeKeyBehavior> mergeKeyBehaviors, MergeBehavior defaultMergeBehavior, boolean dryRun, boolean fetchAdditionalInfo, VersionStore.CommitValidator validator, ImmutableList<Hash> sequenceToTransplant) {
        this.fromRef = fromRef;
        this.toBranch = toBranch;
        this.expectedHash = expectedHash;
        this.updateCommitMetadata = updateCommitMetadata;
        this.mergeKeyBehaviors = mergeKeyBehaviors;
        this.defaultMergeBehavior = defaultMergeBehavior;
        this.dryRun = dryRun;
        this.fetchAdditionalInfo = fetchAdditionalInfo;
        this.validator = validator;
        this.sequenceToTransplant = sequenceToTransplant;
        this.initShim = null;
    }

    private Optional<Hash> expectedHashInitialize() {
        return VersionStore.TransplantOp.super.expectedHash();
    }

    private MetadataRewriter<CommitMeta> updateCommitMetadataInitialize() {
        return VersionStore.TransplantOp.super.updateCommitMetadata();
    }

    private MergeBehavior defaultMergeBehaviorInitialize() {
        return VersionStore.TransplantOp.super.defaultMergeBehavior();
    }

    private boolean dryRunInitialize() {
        return VersionStore.TransplantOp.super.dryRun();
    }

    private boolean fetchAdditionalInfoInitialize() {
        return VersionStore.TransplantOp.super.fetchAdditionalInfo();
    }

    private VersionStore.CommitValidator validatorInitialize() {
        return VersionStore.TransplantOp.super.validator();
    }

    @Override
    public NamedRef fromRef() {
        return this.fromRef;
    }

    @Override
    public BranchName toBranch() {
        return this.toBranch;
    }

    @Override
    public Optional<Hash> expectedHash() {
        InitShim shim = this.initShim;
        return shim != null ? shim.expectedHash() : this.expectedHash;
    }

    @Override
    public MetadataRewriter<CommitMeta> updateCommitMetadata() {
        InitShim shim = this.initShim;
        return shim != null ? shim.updateCommitMetadata() : this.updateCommitMetadata;
    }

    public ImmutableMap<ContentKey, MergeKeyBehavior> mergeKeyBehaviors() {
        return this.mergeKeyBehaviors;
    }

    @Override
    public MergeBehavior defaultMergeBehavior() {
        InitShim shim = this.initShim;
        return shim != null ? shim.defaultMergeBehavior() : this.defaultMergeBehavior;
    }

    @Override
    public boolean dryRun() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dryRun() : this.dryRun;
    }

    @Override
    public boolean fetchAdditionalInfo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fetchAdditionalInfo() : this.fetchAdditionalInfo;
    }

    @Override
    public VersionStore.CommitValidator validator() {
        InitShim shim = this.initShim;
        return shim != null ? shim.validator() : this.validator;
    }

    public ImmutableList<Hash> sequenceToTransplant() {
        return this.sequenceToTransplant;
    }

    public final ImmutableTransplantOp withFromRef(NamedRef value) {
        if (this.fromRef == value) {
            return this;
        }
        NamedRef newValue = Objects.requireNonNull(value, "fromRef");
        return new ImmutableTransplantOp(newValue, this.toBranch, this.expectedHash, this.updateCommitMetadata, this.mergeKeyBehaviors, this.defaultMergeBehavior, this.dryRun, this.fetchAdditionalInfo, this.validator, this.sequenceToTransplant);
    }

    public final ImmutableTransplantOp withToBranch(BranchName value) {
        if (this.toBranch == value) {
            return this;
        }
        BranchName newValue = Objects.requireNonNull(value, "toBranch");
        return new ImmutableTransplantOp(this.fromRef, newValue, this.expectedHash, this.updateCommitMetadata, this.mergeKeyBehaviors, this.defaultMergeBehavior, this.dryRun, this.fetchAdditionalInfo, this.validator, this.sequenceToTransplant);
    }

    public final ImmutableTransplantOp withExpectedHash(Optional<Hash> value) {
        Optional<Hash> newValue = Objects.requireNonNull(value, "expectedHash");
        if (this.expectedHash.equals(newValue)) {
            return this;
        }
        return new ImmutableTransplantOp(this.fromRef, this.toBranch, newValue, this.updateCommitMetadata, this.mergeKeyBehaviors, this.defaultMergeBehavior, this.dryRun, this.fetchAdditionalInfo, this.validator, this.sequenceToTransplant);
    }

    public final ImmutableTransplantOp withUpdateCommitMetadata(MetadataRewriter<CommitMeta> value) {
        if (this.updateCommitMetadata == value) {
            return this;
        }
        MetadataRewriter<CommitMeta> newValue = Objects.requireNonNull(value, "updateCommitMetadata");
        return new ImmutableTransplantOp(this.fromRef, this.toBranch, this.expectedHash, newValue, this.mergeKeyBehaviors, this.defaultMergeBehavior, this.dryRun, this.fetchAdditionalInfo, this.validator, this.sequenceToTransplant);
    }

    public final ImmutableTransplantOp withMergeKeyBehaviors(Map<? extends ContentKey, ? extends MergeKeyBehavior> entries) {
        if (this.mergeKeyBehaviors == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableTransplantOp(this.fromRef, this.toBranch, this.expectedHash, this.updateCommitMetadata, (ImmutableMap<ContentKey, MergeKeyBehavior>)newValue, this.defaultMergeBehavior, this.dryRun, this.fetchAdditionalInfo, this.validator, this.sequenceToTransplant);
    }

    public final ImmutableTransplantOp withDefaultMergeBehavior(MergeBehavior value) {
        MergeBehavior newValue = Objects.requireNonNull(value, "defaultMergeBehavior");
        if (this.defaultMergeBehavior == newValue) {
            return this;
        }
        return new ImmutableTransplantOp(this.fromRef, this.toBranch, this.expectedHash, this.updateCommitMetadata, this.mergeKeyBehaviors, newValue, this.dryRun, this.fetchAdditionalInfo, this.validator, this.sequenceToTransplant);
    }

    public final ImmutableTransplantOp withDryRun(boolean value) {
        if (this.dryRun == value) {
            return this;
        }
        return new ImmutableTransplantOp(this.fromRef, this.toBranch, this.expectedHash, this.updateCommitMetadata, this.mergeKeyBehaviors, this.defaultMergeBehavior, value, this.fetchAdditionalInfo, this.validator, this.sequenceToTransplant);
    }

    public final ImmutableTransplantOp withFetchAdditionalInfo(boolean value) {
        if (this.fetchAdditionalInfo == value) {
            return this;
        }
        return new ImmutableTransplantOp(this.fromRef, this.toBranch, this.expectedHash, this.updateCommitMetadata, this.mergeKeyBehaviors, this.defaultMergeBehavior, this.dryRun, value, this.validator, this.sequenceToTransplant);
    }

    public final ImmutableTransplantOp withValidator(VersionStore.CommitValidator value) {
        if (this.validator == value) {
            return this;
        }
        VersionStore.CommitValidator newValue = Objects.requireNonNull(value, "validator");
        return new ImmutableTransplantOp(this.fromRef, this.toBranch, this.expectedHash, this.updateCommitMetadata, this.mergeKeyBehaviors, this.defaultMergeBehavior, this.dryRun, this.fetchAdditionalInfo, newValue, this.sequenceToTransplant);
    }

    public final ImmutableTransplantOp withSequenceToTransplant(Hash ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTransplantOp(this.fromRef, this.toBranch, this.expectedHash, this.updateCommitMetadata, this.mergeKeyBehaviors, this.defaultMergeBehavior, this.dryRun, this.fetchAdditionalInfo, this.validator, (ImmutableList<Hash>)newValue);
    }

    public final ImmutableTransplantOp withSequenceToTransplant(Iterable<? extends Hash> elements) {
        if (this.sequenceToTransplant == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTransplantOp(this.fromRef, this.toBranch, this.expectedHash, this.updateCommitMetadata, this.mergeKeyBehaviors, this.defaultMergeBehavior, this.dryRun, this.fetchAdditionalInfo, this.validator, (ImmutableList<Hash>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransplantOp && this.equalTo(0, (ImmutableTransplantOp)another);
    }

    private boolean equalTo(int synthetic, ImmutableTransplantOp another) {
        return this.fromRef.equals(another.fromRef) && this.toBranch.equals(another.toBranch) && this.expectedHash.equals(another.expectedHash) && this.updateCommitMetadata.equals(another.updateCommitMetadata) && this.mergeKeyBehaviors.equals(another.mergeKeyBehaviors) && this.defaultMergeBehavior.equals((Object)another.defaultMergeBehavior) && this.dryRun == another.dryRun && this.fetchAdditionalInfo == another.fetchAdditionalInfo && this.validator.equals(another.validator) && this.sequenceToTransplant.equals(another.sequenceToTransplant);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.fromRef.hashCode();
        h += (h << 5) + this.toBranch.hashCode();
        h += (h << 5) + this.expectedHash.hashCode();
        h += (h << 5) + this.updateCommitMetadata.hashCode();
        h += (h << 5) + this.mergeKeyBehaviors.hashCode();
        h += (h << 5) + this.defaultMergeBehavior.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.dryRun);
        h += (h << 5) + Booleans.hashCode((boolean)this.fetchAdditionalInfo);
        h += (h << 5) + this.validator.hashCode();
        h += (h << 5) + this.sequenceToTransplant.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TransplantOp").omitNullValues().add("fromRef", (Object)this.fromRef).add("toBranch", (Object)this.toBranch).add("expectedHash", this.expectedHash).add("updateCommitMetadata", this.updateCommitMetadata).add("mergeKeyBehaviors", this.mergeKeyBehaviors).add("defaultMergeBehavior", (Object)this.defaultMergeBehavior).add("dryRun", this.dryRun).add("fetchAdditionalInfo", this.fetchAdditionalInfo).add("validator", (Object)this.validator).add("sequenceToTransplant", this.sequenceToTransplant).toString();
    }

    public static ImmutableTransplantOp copyOf(VersionStore.TransplantOp instance) {
        if (instance instanceof ImmutableTransplantOp) {
            return (ImmutableTransplantOp)instance;
        }
        return ImmutableTransplantOp.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="VersionStore.TransplantOp", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FROM_REF = 1L;
        private static final long INIT_BIT_TO_BRANCH = 2L;
        private static final long OPT_BIT_DRY_RUN = 1L;
        private static final long OPT_BIT_FETCH_ADDITIONAL_INFO = 2L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private NamedRef fromRef;
        @Nullable
        private BranchName toBranch;
        @Nullable
        private Optional<Hash> expectedHash;
        @Nullable
        private MetadataRewriter<CommitMeta> updateCommitMetadata;
        private ImmutableMap.Builder<ContentKey, MergeKeyBehavior> mergeKeyBehaviors = ImmutableMap.builder();
        @Nullable
        private MergeBehavior defaultMergeBehavior;
        private boolean dryRun;
        private boolean fetchAdditionalInfo;
        @Nullable
        private VersionStore.CommitValidator validator;
        private ImmutableList.Builder<Hash> sequenceToTransplant = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(VersionStore.MergeTransplantOpBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(VersionStore.TransplantOp instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            VersionStore.MergeTransplantOpBase instance;
            long bits = 0L;
            if (object instanceof VersionStore.MergeTransplantOpBase) {
                instance = (VersionStore.MergeTransplantOpBase)object;
                if ((bits & 1L) == 0L) {
                    this.updateCommitMetadata(instance.updateCommitMetadata());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.putAllMergeKeyBehaviors(instance.mergeKeyBehaviors());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.dryRun(instance.dryRun());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.fetchAdditionalInfo(instance.fetchAdditionalInfo());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.validator(instance.validator());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.expectedHash(instance.expectedHash());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.fromRef(instance.fromRef());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.toBranch(instance.toBranch());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.defaultMergeBehavior(instance.defaultMergeBehavior());
                    bits |= 0x100L;
                }
            }
            if (object instanceof VersionStore.TransplantOp) {
                instance = (VersionStore.TransplantOp)object;
                if ((bits & 1L) == 0L) {
                    this.updateCommitMetadata(instance.updateCommitMetadata());
                    bits |= 1L;
                }
                this.addAllSequenceToTransplant(instance.sequenceToTransplant());
                if ((bits & 2L) == 0L) {
                    this.putAllMergeKeyBehaviors(instance.mergeKeyBehaviors());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.dryRun(instance.dryRun());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.fetchAdditionalInfo(instance.fetchAdditionalInfo());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.validator(instance.validator());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.expectedHash(instance.expectedHash());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.fromRef(instance.fromRef());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.toBranch(instance.toBranch());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.defaultMergeBehavior(instance.defaultMergeBehavior());
                    bits |= 0x100L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder fromRef(NamedRef fromRef) {
            this.fromRef = Objects.requireNonNull(fromRef, "fromRef");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toBranch(BranchName toBranch) {
            this.toBranch = Objects.requireNonNull(toBranch, "toBranch");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expectedHash(Optional<Hash> expectedHash) {
            this.expectedHash = Objects.requireNonNull(expectedHash, "expectedHash");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder updateCommitMetadata(MetadataRewriter<CommitMeta> updateCommitMetadata) {
            this.updateCommitMetadata = Objects.requireNonNull(updateCommitMetadata, "updateCommitMetadata");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMergeKeyBehaviors(ContentKey key, MergeKeyBehavior value) {
            this.mergeKeyBehaviors.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMergeKeyBehaviors(Map.Entry<? extends ContentKey, ? extends MergeKeyBehavior> entry) {
            this.mergeKeyBehaviors.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mergeKeyBehaviors(Map<? extends ContentKey, ? extends MergeKeyBehavior> entries) {
            this.mergeKeyBehaviors = ImmutableMap.builder();
            return this.putAllMergeKeyBehaviors(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMergeKeyBehaviors(Map<? extends ContentKey, ? extends MergeKeyBehavior> entries) {
            this.mergeKeyBehaviors.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultMergeBehavior(MergeBehavior defaultMergeBehavior) {
            this.defaultMergeBehavior = Objects.requireNonNull(defaultMergeBehavior, "defaultMergeBehavior");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fetchAdditionalInfo(boolean fetchAdditionalInfo) {
            this.fetchAdditionalInfo = fetchAdditionalInfo;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validator(VersionStore.CommitValidator validator) {
            this.validator = Objects.requireNonNull(validator, "validator");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSequenceToTransplant(Hash element) {
            this.sequenceToTransplant.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSequenceToTransplant(Hash ... elements) {
            this.sequenceToTransplant.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sequenceToTransplant(Iterable<? extends Hash> elements) {
            this.sequenceToTransplant = ImmutableList.builder();
            return this.addAllSequenceToTransplant(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSequenceToTransplant(Iterable<? extends Hash> elements) {
            this.sequenceToTransplant.addAll(elements);
            return this;
        }

        public ImmutableTransplantOp build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransplantOp(this);
        }

        private boolean dryRunIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean fetchAdditionalInfoIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("fromRef");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("toBranch");
            }
            return "Cannot build TransplantOp, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="VersionStore.TransplantOp", generator="Immutables")
    private final class InitShim {
        private byte expectedHashBuildStage = 0;
        private Optional<Hash> expectedHash;
        private byte updateCommitMetadataBuildStage = 0;
        private MetadataRewriter<CommitMeta> updateCommitMetadata;
        private byte defaultMergeBehaviorBuildStage = 0;
        private MergeBehavior defaultMergeBehavior;
        private byte dryRunBuildStage = 0;
        private boolean dryRun;
        private byte fetchAdditionalInfoBuildStage = 0;
        private boolean fetchAdditionalInfo;
        private byte validatorBuildStage = 0;
        private VersionStore.CommitValidator validator;

        private InitShim() {
        }

        Optional<Hash> expectedHash() {
            if (this.expectedHashBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.expectedHashBuildStage == 0) {
                this.expectedHashBuildStage = (byte)-1;
                this.expectedHash = Objects.requireNonNull(ImmutableTransplantOp.this.expectedHashInitialize(), "expectedHash");
                this.expectedHashBuildStage = 1;
            }
            return this.expectedHash;
        }

        void expectedHash(Optional<Hash> expectedHash) {
            this.expectedHash = expectedHash;
            this.expectedHashBuildStage = 1;
        }

        MetadataRewriter<CommitMeta> updateCommitMetadata() {
            if (this.updateCommitMetadataBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.updateCommitMetadataBuildStage == 0) {
                this.updateCommitMetadataBuildStage = (byte)-1;
                this.updateCommitMetadata = Objects.requireNonNull(ImmutableTransplantOp.this.updateCommitMetadataInitialize(), "updateCommitMetadata");
                this.updateCommitMetadataBuildStage = 1;
            }
            return this.updateCommitMetadata;
        }

        void updateCommitMetadata(MetadataRewriter<CommitMeta> updateCommitMetadata) {
            this.updateCommitMetadata = updateCommitMetadata;
            this.updateCommitMetadataBuildStage = 1;
        }

        MergeBehavior defaultMergeBehavior() {
            if (this.defaultMergeBehaviorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultMergeBehaviorBuildStage == 0) {
                this.defaultMergeBehaviorBuildStage = (byte)-1;
                this.defaultMergeBehavior = Objects.requireNonNull(ImmutableTransplantOp.this.defaultMergeBehaviorInitialize(), "defaultMergeBehavior");
                this.defaultMergeBehaviorBuildStage = 1;
            }
            return this.defaultMergeBehavior;
        }

        void defaultMergeBehavior(MergeBehavior defaultMergeBehavior) {
            this.defaultMergeBehavior = defaultMergeBehavior;
            this.defaultMergeBehaviorBuildStage = 1;
        }

        boolean dryRun() {
            if (this.dryRunBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dryRunBuildStage == 0) {
                this.dryRunBuildStage = (byte)-1;
                this.dryRun = ImmutableTransplantOp.this.dryRunInitialize();
                this.dryRunBuildStage = 1;
            }
            return this.dryRun;
        }

        void dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            this.dryRunBuildStage = 1;
        }

        boolean fetchAdditionalInfo() {
            if (this.fetchAdditionalInfoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fetchAdditionalInfoBuildStage == 0) {
                this.fetchAdditionalInfoBuildStage = (byte)-1;
                this.fetchAdditionalInfo = ImmutableTransplantOp.this.fetchAdditionalInfoInitialize();
                this.fetchAdditionalInfoBuildStage = 1;
            }
            return this.fetchAdditionalInfo;
        }

        void fetchAdditionalInfo(boolean fetchAdditionalInfo) {
            this.fetchAdditionalInfo = fetchAdditionalInfo;
            this.fetchAdditionalInfoBuildStage = 1;
        }

        VersionStore.CommitValidator validator() {
            if (this.validatorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.validatorBuildStage == 0) {
                this.validatorBuildStage = (byte)-1;
                this.validator = Objects.requireNonNull(ImmutableTransplantOp.this.validatorInitialize(), "validator");
                this.validatorBuildStage = 1;
            }
            return this.validator;
        }

        void validator(VersionStore.CommitValidator validator) {
            this.validator = validator;
            this.validatorBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.expectedHashBuildStage == -1) {
                attributes.add("expectedHash");
            }
            if (this.updateCommitMetadataBuildStage == -1) {
                attributes.add("updateCommitMetadata");
            }
            if (this.defaultMergeBehaviorBuildStage == -1) {
                attributes.add("defaultMergeBehavior");
            }
            if (this.dryRunBuildStage == -1) {
                attributes.add("dryRun");
            }
            if (this.fetchAdditionalInfoBuildStage == -1) {
                attributes.add("fetchAdditionalInfo");
            }
            if (this.validatorBuildStage == -1) {
                attributes.add("validator");
            }
            return "Cannot build TransplantOp, attribute initializers form cycle " + attributes;
        }
    }
}

