/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.Documentation;
import org.projectnessie.model.IdentifiedContentKey;
import org.projectnessie.versioned.ContentResult;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ContentResult", generator="Immutables")
@Immutable
public final class ImmutableContentResult
implements ContentResult {
    private final IdentifiedContentKey identifiedKey;
    @jakarta.annotation.Nullable
    private final Content content;
    @jakarta.annotation.Nullable
    private final Documentation documentation;

    private ImmutableContentResult(IdentifiedContentKey identifiedKey, @jakarta.annotation.Nullable Content content, @jakarta.annotation.Nullable Documentation documentation) {
        this.identifiedKey = Objects.requireNonNull(identifiedKey, "identifiedKey");
        this.content = content;
        this.documentation = documentation;
    }

    private ImmutableContentResult(ImmutableContentResult original, IdentifiedContentKey identifiedKey, @jakarta.annotation.Nullable Content content, @jakarta.annotation.Nullable Documentation documentation) {
        this.identifiedKey = identifiedKey;
        this.content = content;
        this.documentation = documentation;
    }

    @Override
    public IdentifiedContentKey identifiedKey() {
        return this.identifiedKey;
    }

    @Override
    @jakarta.annotation.Nullable
    public Content content() {
        return this.content;
    }

    @Override
    @jakarta.annotation.Nullable
    public Documentation documentation() {
        return this.documentation;
    }

    public final ImmutableContentResult withIdentifiedKey(IdentifiedContentKey value) {
        if (this.identifiedKey == value) {
            return this;
        }
        IdentifiedContentKey newValue = Objects.requireNonNull(value, "identifiedKey");
        return new ImmutableContentResult(this, newValue, this.content, this.documentation);
    }

    public final ImmutableContentResult withContent(@jakarta.annotation.Nullable Content value) {
        if (this.content == value) {
            return this;
        }
        return new ImmutableContentResult(this, this.identifiedKey, value, this.documentation);
    }

    public final ImmutableContentResult withDocumentation(@jakarta.annotation.Nullable Documentation value) {
        if (this.documentation == value) {
            return this;
        }
        return new ImmutableContentResult(this, this.identifiedKey, this.content, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContentResult && this.equalTo(0, (ImmutableContentResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableContentResult another) {
        return this.identifiedKey.equals((Object)another.identifiedKey) && Objects.equals(this.content, another.content) && Objects.equals(this.documentation, another.documentation);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifiedKey.hashCode();
        h += (h << 5) + Objects.hashCode(this.content);
        h += (h << 5) + Objects.hashCode(this.documentation);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ContentResult").omitNullValues().add("identifiedKey", (Object)this.identifiedKey).add("content", (Object)this.content).add("documentation", (Object)this.documentation).toString();
    }

    public static ImmutableContentResult of(IdentifiedContentKey identifiedKey, @jakarta.annotation.Nullable Content content, @jakarta.annotation.Nullable Documentation documentation) {
        return new ImmutableContentResult(identifiedKey, content, documentation);
    }

    public static ImmutableContentResult copyOf(ContentResult instance) {
        if (instance instanceof ImmutableContentResult) {
            return (ImmutableContentResult)instance;
        }
        return ImmutableContentResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ContentResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IDENTIFIED_KEY = 1L;
        private long initBits = 1L;
        @Nullable
        private IdentifiedContentKey identifiedKey;
        @Nullable
        private Content content;
        @Nullable
        private Documentation documentation;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ContentResult instance) {
            Documentation documentationValue;
            Objects.requireNonNull(instance, "instance");
            this.identifiedKey(instance.identifiedKey());
            Content contentValue = instance.content();
            if (contentValue != null) {
                this.content(contentValue);
            }
            if ((documentationValue = instance.documentation()) != null) {
                this.documentation(documentationValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder identifiedKey(IdentifiedContentKey identifiedKey) {
            this.identifiedKey = Objects.requireNonNull(identifiedKey, "identifiedKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder content(@jakarta.annotation.Nullable Content content) {
            this.content = content;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder documentation(@jakarta.annotation.Nullable Documentation documentation) {
            this.documentation = documentation;
            return this;
        }

        public ImmutableContentResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContentResult(null, this.identifiedKey, this.content, this.documentation);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("identifiedKey");
            }
            return "Cannot build ContentResult, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

