/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.batching;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.batching.WriteBatching;
import org.projectnessie.versioned.storage.common.persist.Persist;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="WriteBatching", generator="Immutables")
@Immutable
public final class ImmutableWriteBatching
implements WriteBatching {
    private final Persist persist;
    private final int batchSize;
    private final boolean optimistic;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableWriteBatching(Builder builder) {
        this.persist = builder.persist;
        if (builder.batchSizeIsSet()) {
            this.initShim.batchSize(builder.batchSize);
        }
        if (builder.optimisticIsSet()) {
            this.initShim.optimistic(builder.optimistic);
        }
        this.batchSize = this.initShim.batchSize();
        this.optimistic = this.initShim.optimistic();
        this.initShim = null;
    }

    private ImmutableWriteBatching(Persist persist, int batchSize, boolean optimistic) {
        this.persist = persist;
        this.batchSize = batchSize;
        this.optimistic = optimistic;
        this.initShim = null;
    }

    private int batchSizeInitialize() {
        return WriteBatching.super.batchSize();
    }

    private boolean optimisticInitialize() {
        return WriteBatching.super.optimistic();
    }

    @Override
    public Persist persist() {
        return this.persist;
    }

    @Override
    public int batchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.batchSize() : this.batchSize;
    }

    @Override
    public boolean optimistic() {
        InitShim shim = this.initShim;
        return shim != null ? shim.optimistic() : this.optimistic;
    }

    public final ImmutableWriteBatching withPersist(Persist value) {
        if (this.persist == value) {
            return this;
        }
        Persist newValue = Objects.requireNonNull(value, "persist");
        return new ImmutableWriteBatching(newValue, this.batchSize, this.optimistic);
    }

    public final ImmutableWriteBatching withBatchSize(int value) {
        if (this.batchSize == value) {
            return this;
        }
        return new ImmutableWriteBatching(this.persist, value, this.optimistic);
    }

    public final ImmutableWriteBatching withOptimistic(boolean value) {
        if (this.optimistic == value) {
            return this;
        }
        return new ImmutableWriteBatching(this.persist, this.batchSize, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWriteBatching && this.equalTo(0, (ImmutableWriteBatching)another);
    }

    private boolean equalTo(int synthetic, ImmutableWriteBatching another) {
        return this.persist.equals((Object)another.persist) && this.batchSize == another.batchSize && this.optimistic == another.optimistic;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.persist.hashCode();
        h += (h << 5) + this.batchSize;
        h += (h << 5) + Booleans.hashCode((boolean)this.optimistic);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WriteBatching").omitNullValues().add("persist", (Object)this.persist).add("batchSize", this.batchSize).add("optimistic", this.optimistic).toString();
    }

    public static ImmutableWriteBatching copyOf(WriteBatching instance) {
        if (instance instanceof ImmutableWriteBatching) {
            return (ImmutableWriteBatching)instance;
        }
        return ImmutableWriteBatching.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WriteBatching", generator="Immutables")
    private final class InitShim {
        private byte batchSizeBuildStage = 0;
        private int batchSize;
        private byte optimisticBuildStage = 0;
        private boolean optimistic;

        private InitShim() {
        }

        int batchSize() {
            if (this.batchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.batchSizeBuildStage == 0) {
                this.batchSizeBuildStage = (byte)-1;
                this.batchSize = ImmutableWriteBatching.this.batchSizeInitialize();
                this.batchSizeBuildStage = 1;
            }
            return this.batchSize;
        }

        void batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.batchSizeBuildStage = 1;
        }

        boolean optimistic() {
            if (this.optimisticBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.optimisticBuildStage == 0) {
                this.optimisticBuildStage = (byte)-1;
                this.optimistic = ImmutableWriteBatching.this.optimisticInitialize();
                this.optimisticBuildStage = 1;
            }
            return this.optimistic;
        }

        void optimistic(boolean optimistic) {
            this.optimistic = optimistic;
            this.optimisticBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.batchSizeBuildStage == -1) {
                attributes.add("batchSize");
            }
            if (this.optimisticBuildStage == -1) {
                attributes.add("optimistic");
            }
            return "Cannot build WriteBatching, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="WriteBatching", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PERSIST = 1L;
        private static final long OPT_BIT_BATCH_SIZE = 1L;
        private static final long OPT_BIT_OPTIMISTIC = 2L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private Persist persist;
        private int batchSize;
        private boolean optimistic;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(WriteBatching instance) {
            Objects.requireNonNull(instance, "instance");
            this.persist(instance.persist());
            this.batchSize(instance.batchSize());
            this.optimistic(instance.optimistic());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder persist(Persist persist) {
            this.persist = Objects.requireNonNull(persist, "persist");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder optimistic(boolean optimistic) {
            this.optimistic = optimistic;
            this.optBits |= 2L;
            return this;
        }

        public ImmutableWriteBatching build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWriteBatching(this);
        }

        private boolean batchSizeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean optimisticIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("persist");
            }
            return "Cannot build WriteBatching, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

