/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.batching;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.projectnessie.versioned.storage.batching.BatchingPersist;
import org.projectnessie.versioned.storage.batching.WriteBatching;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RefConditionFailedException;
import org.projectnessie.versioned.storage.common.exceptions.RefNotFoundException;
import org.projectnessie.versioned.storage.common.objtypes.UpdateableObj;
import org.projectnessie.versioned.storage.common.persist.CloseableIterator;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.projectnessie.versioned.storage.common.persist.ValidatingPersist;

final class BatchingPersistImpl
implements BatchingPersist,
ValidatingPersist {
    private final WriteBatching batching;
    private final Map<ObjId, Obj> pendingUpserts = new HashMap<ObjId, Obj>();
    private final Map<ObjId, Obj> pendingStores = new HashMap<ObjId, Obj>();
    private final ReentrantReadWriteLock lock;

    BatchingPersistImpl(WriteBatching batching) {
        Preconditions.checkArgument((boolean)batching.optimistic(), (Object)"Non-optimistic mode is not supported");
        this.batching = batching;
        this.lock = new ReentrantReadWriteLock();
    }

    @VisibleForTesting
    Map<ObjId, Obj> pendingUpserts() {
        return this.pendingUpserts;
    }

    @VisibleForTesting
    Map<ObjId, Obj> pendingStores() {
        return this.pendingStores;
    }

    @Override
    public void flush() {
        if (this.batching.batchSize() > 0) {
            this.writeLock();
            try {
                if (!this.pendingStores.isEmpty()) {
                    this.delegate().storeObjs(this.pendingStores.values().toArray(new Obj[0]));
                    this.pendingStores.clear();
                }
                if (!this.pendingUpserts.isEmpty()) {
                    this.delegate().upsertObjs(this.pendingUpserts.values().toArray(new Obj[0]));
                    this.pendingUpserts.clear();
                }
            }
            catch (ObjTooLargeException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    private Persist delegate() {
        return this.batching.persist();
    }

    private void readLock() {
        this.lock.readLock().lock();
    }

    private void readUnlock() {
        this.lock.readLock().unlock();
    }

    private void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    private void writeLock() {
        this.lock.writeLock().lock();
    }

    private void maybeFlush() {
        if (this.batching.batchSize() > 0 && (this.pendingStores.size() > this.batching.batchSize() || this.pendingUpserts.size() > this.batching.batchSize())) {
            this.flush();
        }
    }

    public boolean storeObj(@Nonnull @javax.annotation.Nonnull Obj obj, boolean ignoreSoftSizeRestrictions) throws ObjTooLargeException {
        if (!ignoreSoftSizeRestrictions) {
            this.verifySoftRestrictions(obj);
        }
        this.writeLock();
        try {
            this.pendingStores.putIfAbsent(obj.id(), obj);
            this.maybeFlush();
        }
        finally {
            this.writeUnlock();
        }
        return true;
    }

    public void upsertObj(@Nonnull @javax.annotation.Nonnull Obj obj) throws ObjTooLargeException {
        this.verifySoftRestrictions(obj);
        this.writeLock();
        try {
            this.pendingUpserts.put(obj.id(), obj);
            this.maybeFlush();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @javax.annotation.Nonnull
    public boolean[] storeObjs(@Nonnull @javax.annotation.Nonnull Obj[] objs) throws ObjTooLargeException {
        this.writeLock();
        try {
            for (Obj obj : objs) {
                if (obj == null) continue;
                this.storeObj(obj);
            }
        }
        finally {
            this.writeUnlock();
        }
        boolean[] r = new boolean[objs.length];
        Arrays.fill(r, true);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upsertObjs(@Nonnull @javax.annotation.Nonnull Obj[] objs) throws ObjTooLargeException {
        this.writeLock();
        try {
            for (Obj obj : objs) {
                if (obj == null) continue;
                this.upsertObj(obj);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private Obj pendingObj(ObjId id) {
        Obj r = this.pendingUpserts.get(id);
        if (r == null) {
            r = this.pendingStores.get(id);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @javax.annotation.Nonnull
    public <T extends Obj> T fetchTypedObj(@Nonnull @javax.annotation.Nonnull ObjId id, ObjType type, @Nonnull Class<T> typeClass) throws ObjNotFoundException {
        this.readLock();
        try {
            Obj r = this.pendingObj(id);
            if (r != null) {
                Obj o;
                if (type != null && !r.type().equals((Object)type)) {
                    throw new ObjNotFoundException(id);
                }
                Obj obj = o = r;
                return (T)obj;
            }
        }
        finally {
            this.readUnlock();
        }
        return (T)this.delegate().fetchTypedObj(id, type, typeClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @javax.annotation.Nonnull
    public ObjType fetchObjType(@Nonnull @javax.annotation.Nonnull ObjId id) throws ObjNotFoundException {
        this.readLock();
        try {
            Obj r = this.pendingObj(id);
            if (r != null) {
                ObjType objType = r.type();
                return objType;
            }
        }
        finally {
            this.readUnlock();
        }
        return this.delegate().fetchObjType(id);
    }

    @Nonnull
    @javax.annotation.Nonnull
    public <T extends Obj> T[] fetchTypedObjs(@Nonnull ObjId[] ids, ObjType type, @Nonnull Class<T> typeClass) throws ObjNotFoundException {
        ObjId[] backendIds = null;
        Obj[] r = (Obj[])Array.newInstance(typeClass, ids.length);
        backendIds = this.fetchObjsPre(ids, r, backendIds);
        if (backendIds == null) {
            return r;
        }
        Obj[] backendResult = this.delegate().fetchTypedObjs(backendIds, type, typeClass);
        return BatchingPersistImpl.fetchObjsPost((Obj[])backendResult, (Obj[])r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Obj> ObjId[] fetchObjsPre(ObjId[] ids, T[] r, ObjId[] backendIds) {
        this.readLock();
        try {
            for (int i = 0; i < ids.length; ++i) {
                ObjId id = ids[i];
                if (id == null) continue;
                Obj o = this.pendingObj(id);
                if (o != null) {
                    Obj typed = o;
                    r[i] = typed;
                    continue;
                }
                if (backendIds == null) {
                    backendIds = new ObjId[ids.length];
                }
                backendIds[i] = id;
            }
        }
        finally {
            this.readUnlock();
        }
        return backendIds;
    }

    private static <T extends Obj> T[] fetchObjsPost(T[] backendResult, T[] r) {
        for (int i = 0; i < backendResult.length; ++i) {
            T o = backendResult[i];
            if (o == null) continue;
            r[i] = o;
        }
        return r;
    }

    @Nonnull
    @javax.annotation.Nonnull
    public <T extends Obj> T[] fetchTypedObjsIfExist(@Nonnull ObjId[] ids, ObjType type, @Nonnull Class<T> typeClass) {
        ObjId[] backendIds = null;
        Obj[] r = (Obj[])Array.newInstance(typeClass, ids.length);
        backendIds = this.fetchObjsPre(ids, r, backendIds);
        if (backendIds == null) {
            return r;
        }
        Obj[] backendResult = this.delegate().fetchTypedObjsIfExist(backendIds, type, typeClass);
        return BatchingPersistImpl.fetchObjsPost((Obj[])backendResult, (Obj[])r);
    }

    public void deleteObj(@Nonnull @javax.annotation.Nonnull ObjId id) {
        this.writeLock();
        try {
            this.delegate().deleteObj(id);
            this.pendingStores.remove(id);
            this.pendingUpserts.remove(id);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObjs(@Nonnull @javax.annotation.Nonnull ObjId[] ids) {
        this.writeLock();
        try {
            for (ObjId id : ids) {
                if (id == null) continue;
                this.deleteObj(id);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public boolean deleteConditional(@Nonnull UpdateableObj obj) {
        throw new UnsupportedOperationException();
    }

    public boolean updateConditional(@Nonnull UpdateableObj expected, @Nonnull UpdateableObj newValue) {
        throw new UnsupportedOperationException();
    }

    public void erase() {
        this.writeLock();
        try {
            this.pendingStores.clear();
            this.pendingUpserts.clear();
            this.delegate().erase();
        }
        finally {
            this.writeUnlock();
        }
    }

    public int hardObjectSizeLimit() {
        return this.delegate().hardObjectSizeLimit();
    }

    public int effectiveIndexSegmentSizeLimit() {
        return this.delegate().effectiveIndexSegmentSizeLimit();
    }

    public int effectiveIncrementalIndexSizeLimit() {
        return this.delegate().effectiveIncrementalIndexSizeLimit();
    }

    @Nonnull
    @javax.annotation.Nonnull
    public String name() {
        return this.delegate().name();
    }

    @Nonnull
    @javax.annotation.Nonnull
    public StoreConfig config() {
        return this.delegate().config();
    }

    @Nonnull
    @javax.annotation.Nonnull
    public Reference addReference(@Nonnull @javax.annotation.Nonnull Reference reference) throws RefAlreadyExistsException {
        return this.delegate().addReference(reference);
    }

    @Nonnull
    @javax.annotation.Nonnull
    public Reference markReferenceAsDeleted(@Nonnull @javax.annotation.Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        return this.delegate().markReferenceAsDeleted(reference);
    }

    public void purgeReference(@Nonnull @javax.annotation.Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        this.delegate().purgeReference(reference);
    }

    @Nonnull
    @javax.annotation.Nonnull
    public Reference updateReferencePointer(@Nonnull @javax.annotation.Nonnull Reference reference, @Nonnull @javax.annotation.Nonnull ObjId newPointer) throws RefNotFoundException, RefConditionFailedException {
        return this.delegate().updateReferencePointer(reference, newPointer);
    }

    @Nullable
    @javax.annotation.Nullable
    public Reference fetchReference(@Nonnull @javax.annotation.Nonnull String name) {
        return this.delegate().fetchReference(name);
    }

    @Nullable
    @javax.annotation.Nullable
    public Reference fetchReferenceForUpdate(@Nonnull @javax.annotation.Nonnull String name) {
        return this.delegate().fetchReferenceForUpdate(name);
    }

    @Nonnull
    @javax.annotation.Nonnull
    public Reference[] fetchReferences(@Nonnull @javax.annotation.Nonnull String[] names) {
        return this.delegate().fetchReferences(names);
    }

    @Nonnull
    @javax.annotation.Nonnull
    public Reference[] fetchReferencesForUpdate(@Nonnull @javax.annotation.Nonnull String[] names) {
        return this.delegate().fetchReferencesForUpdate(names);
    }

    @Nonnull
    @javax.annotation.Nonnull
    public CloseableIterator<Obj> scanAllObjects(@Nonnull @javax.annotation.Nonnull Set<ObjType> returnedObjTypes) {
        throw new UnsupportedOperationException();
    }

    public boolean isCaching() {
        return this.delegate().isCaching();
    }
}

