/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.cache;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.LongSupplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.cache.CacheConfig;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CacheConfig", generator="Immutables")
@Immutable
public final class ImmutableCacheConfig
implements CacheConfig {
    private final long capacityMb;
    @Nullable
    private final MeterRegistry meterRegistry;
    @Nullable
    private final Duration referenceTtl;
    @Nullable
    private final Duration referenceNegativeTtl;
    @Nullable
    private final Boolean enableSoftReferences;
    private final LongSupplier clockNanos;

    private ImmutableCacheConfig(Builder builder) {
        this.capacityMb = builder.capacityMb;
        this.meterRegistry = builder.meterRegistry;
        this.referenceTtl = builder.referenceTtl;
        this.referenceNegativeTtl = builder.referenceNegativeTtl;
        this.enableSoftReferences = builder.enableSoftReferences;
        this.clockNanos = builder.clockNanos != null ? builder.clockNanos : Objects.requireNonNull(CacheConfig.super.clockNanos(), "clockNanos");
    }

    private ImmutableCacheConfig(long capacityMb, @Nullable MeterRegistry meterRegistry, @Nullable Duration referenceTtl, @Nullable Duration referenceNegativeTtl, @Nullable Boolean enableSoftReferences, LongSupplier clockNanos) {
        this.capacityMb = capacityMb;
        this.meterRegistry = meterRegistry;
        this.referenceTtl = referenceTtl;
        this.referenceNegativeTtl = referenceNegativeTtl;
        this.enableSoftReferences = enableSoftReferences;
        this.clockNanos = clockNanos;
    }

    @Override
    public long capacityMb() {
        return this.capacityMb;
    }

    @Override
    public Optional<MeterRegistry> meterRegistry() {
        return Optional.ofNullable(this.meterRegistry);
    }

    @Override
    public Optional<Duration> referenceTtl() {
        return Optional.ofNullable(this.referenceTtl);
    }

    @Override
    public Optional<Duration> referenceNegativeTtl() {
        return Optional.ofNullable(this.referenceNegativeTtl);
    }

    @Override
    public Optional<Boolean> enableSoftReferences() {
        return Optional.ofNullable(this.enableSoftReferences);
    }

    @Override
    public LongSupplier clockNanos() {
        return this.clockNanos;
    }

    public final ImmutableCacheConfig withCapacityMb(long value) {
        if (this.capacityMb == value) {
            return this;
        }
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(value, this.meterRegistry, this.referenceTtl, this.referenceNegativeTtl, this.enableSoftReferences, this.clockNanos));
    }

    public final ImmutableCacheConfig withMeterRegistry(MeterRegistry value) {
        MeterRegistry newValue = Objects.requireNonNull(value, "meterRegistry");
        if (this.meterRegistry == newValue) {
            return this;
        }
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this.capacityMb, newValue, this.referenceTtl, this.referenceNegativeTtl, this.enableSoftReferences, this.clockNanos));
    }

    public final ImmutableCacheConfig withMeterRegistry(Optional<? extends MeterRegistry> optional) {
        MeterRegistry value = optional.orElse(null);
        if (this.meterRegistry == value) {
            return this;
        }
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this.capacityMb, value, this.referenceTtl, this.referenceNegativeTtl, this.enableSoftReferences, this.clockNanos));
    }

    public final ImmutableCacheConfig withReferenceTtl(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "referenceTtl");
        if (this.referenceTtl == newValue) {
            return this;
        }
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this.capacityMb, this.meterRegistry, newValue, this.referenceNegativeTtl, this.enableSoftReferences, this.clockNanos));
    }

    public final ImmutableCacheConfig withReferenceTtl(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.referenceTtl == value) {
            return this;
        }
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this.capacityMb, this.meterRegistry, value, this.referenceNegativeTtl, this.enableSoftReferences, this.clockNanos));
    }

    public final ImmutableCacheConfig withReferenceNegativeTtl(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "referenceNegativeTtl");
        if (this.referenceNegativeTtl == newValue) {
            return this;
        }
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this.capacityMb, this.meterRegistry, this.referenceTtl, newValue, this.enableSoftReferences, this.clockNanos));
    }

    public final ImmutableCacheConfig withReferenceNegativeTtl(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.referenceNegativeTtl == value) {
            return this;
        }
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this.capacityMb, this.meterRegistry, this.referenceTtl, value, this.enableSoftReferences, this.clockNanos));
    }

    public final ImmutableCacheConfig withEnableSoftReferences(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.enableSoftReferences, newValue)) {
            return this;
        }
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this.capacityMb, this.meterRegistry, this.referenceTtl, this.referenceNegativeTtl, newValue, this.clockNanos));
    }

    public final ImmutableCacheConfig withEnableSoftReferences(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.enableSoftReferences, value)) {
            return this;
        }
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this.capacityMb, this.meterRegistry, this.referenceTtl, this.referenceNegativeTtl, value, this.clockNanos));
    }

    public final ImmutableCacheConfig withClockNanos(LongSupplier value) {
        if (this.clockNanos == value) {
            return this;
        }
        LongSupplier newValue = Objects.requireNonNull(value, "clockNanos");
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this.capacityMb, this.meterRegistry, this.referenceTtl, this.referenceNegativeTtl, this.enableSoftReferences, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCacheConfig && this.equalTo(0, (ImmutableCacheConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableCacheConfig another) {
        return this.capacityMb == another.capacityMb && Objects.equals(this.meterRegistry, another.meterRegistry) && Objects.equals(this.referenceTtl, another.referenceTtl) && Objects.equals(this.referenceNegativeTtl, another.referenceNegativeTtl) && Objects.equals(this.enableSoftReferences, another.enableSoftReferences) && this.clockNanos.equals(another.clockNanos);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.capacityMb);
        h += (h << 5) + Objects.hashCode(this.meterRegistry);
        h += (h << 5) + Objects.hashCode(this.referenceTtl);
        h += (h << 5) + Objects.hashCode(this.referenceNegativeTtl);
        h += (h << 5) + Objects.hashCode(this.enableSoftReferences);
        h += (h << 5) + this.clockNanos.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CacheConfig").omitNullValues().add("capacityMb", this.capacityMb).add("meterRegistry", (Object)this.meterRegistry).add("referenceTtl", (Object)this.referenceTtl).add("referenceNegativeTtl", (Object)this.referenceNegativeTtl).add("enableSoftReferences", (Object)this.enableSoftReferences).add("clockNanos", (Object)this.clockNanos).toString();
    }

    private static ImmutableCacheConfig validate(ImmutableCacheConfig instance) {
        instance.check();
        return instance;
    }

    public static ImmutableCacheConfig copyOf(CacheConfig instance) {
        if (instance instanceof ImmutableCacheConfig) {
            return (ImmutableCacheConfig)instance;
        }
        return ImmutableCacheConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CacheConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements CacheConfig.Builder {
        private static final long INIT_BIT_CAPACITY_MB = 1L;
        private long initBits = 1L;
        private long capacityMb;
        @Nullable
        private MeterRegistry meterRegistry;
        @Nullable
        private Duration referenceTtl;
        @Nullable
        private Duration referenceNegativeTtl;
        @Nullable
        private Boolean enableSoftReferences;
        @Nullable
        private LongSupplier clockNanos;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CacheConfig instance) {
            Optional<Boolean> enableSoftReferencesOptional;
            Optional<Duration> referenceNegativeTtlOptional;
            Optional<Duration> referenceTtlOptional;
            Objects.requireNonNull(instance, "instance");
            this.capacityMb(instance.capacityMb());
            Optional<MeterRegistry> meterRegistryOptional = instance.meterRegistry();
            if (meterRegistryOptional.isPresent()) {
                this.meterRegistry(meterRegistryOptional);
            }
            if ((referenceTtlOptional = instance.referenceTtl()).isPresent()) {
                this.referenceTtl(referenceTtlOptional);
            }
            if ((referenceNegativeTtlOptional = instance.referenceNegativeTtl()).isPresent()) {
                this.referenceNegativeTtl(referenceNegativeTtlOptional);
            }
            if ((enableSoftReferencesOptional = instance.enableSoftReferences()).isPresent()) {
                this.enableSoftReferences(enableSoftReferencesOptional);
            }
            this.clockNanos(instance.clockNanos());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder capacityMb(long capacityMb) {
            this.capacityMb = capacityMb;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder meterRegistry(MeterRegistry meterRegistry) {
            this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder meterRegistry(Optional<? extends MeterRegistry> meterRegistry) {
            this.meterRegistry = meterRegistry.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder referenceTtl(Duration referenceTtl) {
            this.referenceTtl = Objects.requireNonNull(referenceTtl, "referenceTtl");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder referenceTtl(Optional<? extends Duration> referenceTtl) {
            this.referenceTtl = referenceTtl.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder referenceNegativeTtl(Duration referenceNegativeTtl) {
            this.referenceNegativeTtl = Objects.requireNonNull(referenceNegativeTtl, "referenceNegativeTtl");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder referenceNegativeTtl(Optional<? extends Duration> referenceNegativeTtl) {
            this.referenceNegativeTtl = referenceNegativeTtl.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder enableSoftReferences(boolean enableSoftReferences) {
            this.enableSoftReferences = enableSoftReferences;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enableSoftReferences(Optional<Boolean> enableSoftReferences) {
            this.enableSoftReferences = enableSoftReferences.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder clockNanos(LongSupplier clockNanos) {
            this.clockNanos = Objects.requireNonNull(clockNanos, "clockNanos");
            return this;
        }

        @Override
        public ImmutableCacheConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("capacityMb");
            }
            return "Cannot build CacheConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

