/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.cache;

import jakarta.annotation.Nonnull;
import org.projectnessie.versioned.storage.cache.CacheBackend;
import org.projectnessie.versioned.storage.cache.ObjCache;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Reference;

final class ObjCacheImpl
implements ObjCache {
    private final CacheBackend backend;
    private final String repositoryId;

    ObjCacheImpl(CacheBackend backend, StoreConfig config) {
        this.backend = backend;
        this.repositoryId = config.repositoryId();
    }

    @Override
    public Obj get(@Nonnull ObjId id) {
        return this.backend.get(this.repositoryId, id);
    }

    @Override
    public void put(@Nonnull Obj obj) {
        this.backend.put(this.repositoryId, obj);
    }

    @Override
    public void putLocal(@Nonnull Obj obj) {
        this.backend.putLocal(this.repositoryId, obj);
    }

    @Override
    public void putReferenceNegative(ObjId id, ObjType type) {
        if (type != null) {
            this.backend.putNegative(this.repositoryId, id, type);
        } else {
            this.backend.remove(this.repositoryId, id);
        }
    }

    @Override
    public void remove(@Nonnull ObjId id) {
        this.backend.remove(this.repositoryId, id);
    }

    @Override
    public void clear() {
        this.backend.clear(this.repositoryId);
    }

    @Override
    public void removeReference(@Nonnull String name) {
        this.backend.removeReference(this.repositoryId, name);
    }

    @Override
    public void putReference(@Nonnull Reference r) {
        this.backend.putReference(this.repositoryId, r);
    }

    @Override
    public void putReferenceLocal(@Nonnull Reference r) {
        this.backend.putReferenceLocal(this.repositoryId, r);
    }

    @Override
    public Reference getReference(@Nonnull String name) {
        return this.backend.getReference(this.repositoryId, name);
    }

    @Override
    public void putReferenceNegative(@Nonnull String name) {
        this.backend.putReferenceNegative(this.repositoryId, name);
    }
}

