/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.cache.CaffeineStatsCounter;
import jakarta.annotation.Nonnull;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.projectnessie.versioned.storage.cache.CacheBackend;
import org.projectnessie.versioned.storage.cache.CacheConfig;
import org.projectnessie.versioned.storage.cache.CachingPersistImpl;
import org.projectnessie.versioned.storage.cache.ObjCacheImpl;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.serialize.ProtoSerialization;

class CaffeineCacheBackend
implements CacheBackend {
    public static final String CACHE_NAME = "nessie-objects";
    private static final CacheKeyValue NON_EXISTING_SENTINEL = new CacheKeyValue("x", ObjId.EMPTY_OBJ_ID, 0L, new byte[0], null, false);
    private final CacheConfig config;
    final Cache<CacheKeyValue, CacheKeyValue> cache;
    private final long refCacheTtlNanos;
    private final long refCacheNegativeTtlNanos;
    private final boolean enableSoftReferences;
    static final int OBJ_SIZE = 40;
    static final int ARRAY_OVERHEAD = 16;
    static final int SOFT_REFERENCE_OVERHEAD = 32;
    static final int STRING_OBJ_OVERHEAD = 40;
    static final int CAFFEINE_OBJ_OVERHEAD = 64;

    CaffeineCacheBackend(CacheConfig config) {
        this.config = config;
        this.refCacheTtlNanos = config.referenceTtl().orElse(Duration.ZERO).toNanos();
        this.refCacheNegativeTtlNanos = config.referenceNegativeTtl().orElse(Duration.ZERO).toNanos();
        this.enableSoftReferences = config.enableSoftReferences().orElse(false);
        Caffeine cacheBuilder = Caffeine.newBuilder().maximumWeight(config.capacityMb() * 1024L * 1024L).weigher(this::weigher).expireAfter((Expiry)new Expiry<CacheKeyValue, CacheKeyValue>(){

            public long expireAfterCreate(CacheKeyValue key, CacheKeyValue value, long currentTimeNanos) {
                long expire = key.expiresAtNanosEpoch;
                if (expire == -1L) {
                    return Long.MAX_VALUE;
                }
                if (expire == 0L) {
                    return 0L;
                }
                long remaining = expire - currentTimeNanos;
                return Math.max(0L, remaining);
            }

            public long expireAfterUpdate(CacheKeyValue key, CacheKeyValue value, long currentTimeNanos, long currentDurationNanos) {
                return this.expireAfterCreate(key, value, currentTimeNanos);
            }

            public long expireAfterRead(CacheKeyValue key, CacheKeyValue value, long currentTimeNanos, long currentDurationNanos) {
                return currentDurationNanos;
            }
        }).ticker(config.clockNanos()::getAsLong);
        config.meterRegistry().ifPresent(meterRegistry -> {
            cacheBuilder.recordStats(() -> new CaffeineStatsCounter(meterRegistry, CACHE_NAME));
            meterRegistry.gauge("cache_capacity_mb", Collections.singletonList(Tag.of((String)"cache", (String)CACHE_NAME)), (Object)"", x -> config.capacityMb());
        });
        this.cache = cacheBuilder.build();
    }

    @Override
    public Persist wrap(@Nonnull Persist persist) {
        ObjCacheImpl cache = new ObjCacheImpl(this, persist.config());
        return new CachingPersistImpl(persist, cache);
    }

    private int weigher(CacheKeyValue key, CacheKeyValue value) {
        int size = key.heapSize();
        return size += 64;
    }

    @Override
    public Obj get(@Nonnull String repositoryId, @Nonnull ObjId id) {
        CacheKeyValue key = CaffeineCacheBackend.cacheKeyForRead(repositoryId, id);
        CacheKeyValue value = (CacheKeyValue)this.cache.getIfPresent((Object)key);
        if (value == null) {
            return null;
        }
        if (value == NON_EXISTING_SENTINEL) {
            return NOT_FOUND_OBJ_SENTINEL;
        }
        return value.getObj();
    }

    @Override
    public void put(@Nonnull String repositoryId, @Nonnull Obj obj) {
        this.putLocal(repositoryId, obj);
    }

    @Override
    public void putLocal(@Nonnull String repositoryId, @Nonnull Obj obj) {
        long expiresAt = obj.type().cachedObjectExpiresAtMicros(obj, () -> TimeUnit.NANOSECONDS.toMicros(this.config.clockNanos().getAsLong()));
        if (expiresAt == 0L) {
            return;
        }
        try {
            byte[] serialized = ProtoSerialization.serializeObj((Obj)obj, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (boolean)true);
            long expiresAtNanos = expiresAt == -1L ? -1L : TimeUnit.MICROSECONDS.toNanos(expiresAt);
            CacheKeyValue keyValue = CaffeineCacheBackend.cacheKeyValue(repositoryId, obj.id(), expiresAtNanos, serialized, obj, this.enableSoftReferences);
            this.cache.put((Object)keyValue, (Object)keyValue);
        }
        catch (ObjTooLargeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void putNegative(@Nonnull String repositoryId, @Nonnull ObjId id, @Nonnull ObjType type) {
        long expiresAt = type.negativeCacheExpiresAtMicros(() -> TimeUnit.NANOSECONDS.toMicros(this.config.clockNanos().getAsLong()));
        if (expiresAt == 0L) {
            this.remove(repositoryId, id);
            return;
        }
        long expiresAtNanos = expiresAt == -1L ? -1L : TimeUnit.MICROSECONDS.toNanos(expiresAt);
        CacheKeyValue keyValue = CaffeineCacheBackend.cacheKeyValue(repositoryId, id, expiresAtNanos, this.enableSoftReferences);
        this.cache.put((Object)keyValue, (Object)NON_EXISTING_SENTINEL);
    }

    @Override
    public void remove(@Nonnull String repositoryId, @Nonnull ObjId id) {
        CacheKeyValue key = CaffeineCacheBackend.cacheKeyForRead(repositoryId, id);
        this.cache.invalidate((Object)key);
    }

    @Override
    public void clear(@Nonnull String repositoryId) {
        this.cache.asMap().keySet().removeIf(k -> k.repositoryId.equals(repositoryId));
    }

    private ObjId refObjId(String name) {
        return ObjId.objIdFromByteArray((byte[])("r:" + name).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void removeReference(@Nonnull String repositoryId, @Nonnull String name) {
        if (this.refCacheTtlNanos <= 0L) {
            return;
        }
        ObjId id = this.refObjId(name);
        CacheKeyValue key = CaffeineCacheBackend.cacheKeyForRead(repositoryId, id);
        this.cache.invalidate((Object)key);
    }

    @Override
    public void putReference(@Nonnull String repositoryId, @Nonnull org.projectnessie.versioned.storage.common.persist.Reference r) {
        this.putReferenceLocal(repositoryId, r);
    }

    @Override
    public void putReferenceLocal(@Nonnull String repositoryId, @Nonnull org.projectnessie.versioned.storage.common.persist.Reference r) {
        if (this.refCacheTtlNanos <= 0L) {
            return;
        }
        ObjId id = this.refObjId(r.name());
        CacheKeyValue keyValue = CaffeineCacheBackend.cacheKeyValue(repositoryId, id, this.config.clockNanos().getAsLong() + this.refCacheTtlNanos, ProtoSerialization.serializeReference((org.projectnessie.versioned.storage.common.persist.Reference)r), r, this.enableSoftReferences);
        this.cache.put((Object)keyValue, (Object)keyValue);
    }

    @Override
    public void putReferenceNegative(@Nonnull String repositoryId, @Nonnull String name) {
        if (this.refCacheNegativeTtlNanos <= 0L) {
            return;
        }
        ObjId id = this.refObjId(name);
        CacheKeyValue key = CaffeineCacheBackend.cacheKeyValue(repositoryId, id, this.config.clockNanos().getAsLong() + this.refCacheNegativeTtlNanos, this.enableSoftReferences);
        this.cache.put((Object)key, (Object)NON_EXISTING_SENTINEL);
    }

    @Override
    public org.projectnessie.versioned.storage.common.persist.Reference getReference(@Nonnull String repositoryId, @Nonnull String name) {
        if (this.refCacheTtlNanos <= 0L) {
            return null;
        }
        ObjId id = this.refObjId(name);
        CacheKeyValue value = (CacheKeyValue)this.cache.getIfPresent((Object)CaffeineCacheBackend.cacheKeyForRead(repositoryId, id));
        if (value == null) {
            return null;
        }
        if (value == NON_EXISTING_SENTINEL) {
            return NON_EXISTENT_REFERENCE_SENTINEL;
        }
        return value.getReference();
    }

    static CacheKeyValue cacheKeyForRead(String repositoryId, ObjId id) {
        return new CacheKeyValue(repositoryId, id, false);
    }

    private static CacheKeyValue cacheKeyValue(String repositoryId, ObjId id, long expiresAtNanosEpoch, boolean enableSoftReferences) {
        return new CacheKeyValue(repositoryId, id, expiresAtNanosEpoch, enableSoftReferences);
    }

    private static CacheKeyValue cacheKeyValue(String repositoryId, ObjId id, long expiresAtNanosEpoch, byte[] serialized, Object object, boolean enableSoftReferences) {
        return new CacheKeyValue(repositoryId, id, expiresAtNanosEpoch, serialized, object, enableSoftReferences);
    }

    static final class CacheKeyValue {
        final String repositoryId;
        final ObjId id;
        final long expiresAtNanosEpoch;
        final byte[] serialized;
        Reference<Object> object;

        CacheKeyValue(String repositoryId, ObjId id, boolean enableSoftReferences) {
            this(repositoryId, id, 0L, enableSoftReferences);
        }

        CacheKeyValue(String repositoryId, ObjId id, long expiresAtNanosEpoch, boolean enableSoftReferences) {
            this(repositoryId, id, expiresAtNanosEpoch, null, null, enableSoftReferences);
        }

        CacheKeyValue(String repositoryId, ObjId id, long expiresAtNanosEpoch, byte[] serialized, Object object, boolean enableSoftReferences) {
            this.repositoryId = repositoryId;
            this.id = id;
            this.expiresAtNanosEpoch = expiresAtNanosEpoch;
            this.serialized = serialized;
            this.object = enableSoftReferences ? new SoftReference<Object>(object, null) : null;
        }

        int heapSize() {
            int size = 40;
            size += 40 + this.repositoryId.length();
            size += this.id.heapSize();
            byte[] s = this.serialized;
            if (s != null) {
                size += 16 + s.length;
            }
            return size += 32;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKeyValue)) {
                return false;
            }
            CacheKeyValue cacheKey = (CacheKeyValue)o;
            return this.repositoryId.equals(cacheKey.repositoryId) && this.id.equals(cacheKey.id);
        }

        public int hashCode() {
            return this.repositoryId.hashCode() * 31 + this.id.hashCode();
        }

        public String toString() {
            return "{" + this.repositoryId + ", " + String.valueOf(this.id) + "}";
        }

        Obj getObj() {
            Reference<Object> softRef = this.object;
            if (softRef == null) {
                return ProtoSerialization.deserializeObj((ObjId)this.id, (long)0L, (byte[])this.serialized, null);
            }
            Obj obj = (Obj)this.object.get();
            if (obj == null) {
                obj = ProtoSerialization.deserializeObj((ObjId)this.id, (long)0L, (byte[])this.serialized, null);
                this.object = new SoftReference<Obj>(obj);
            }
            return obj;
        }

        org.projectnessie.versioned.storage.common.persist.Reference getReference() {
            Reference<Object> softRef = this.object;
            if (softRef == null) {
                return ProtoSerialization.deserializeReference((byte[])this.serialized);
            }
            org.projectnessie.versioned.storage.common.persist.Reference ref = (org.projectnessie.versioned.storage.common.persist.Reference)softRef.get();
            if (ref == null) {
                ref = ProtoSerialization.deserializeReference((byte[])this.serialized);
                this.object = new SoftReference<org.projectnessie.versioned.storage.common.persist.Reference>(ref);
            }
            return ref;
        }
    }
}

