/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.cache;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.LongSupplier;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.cache.CacheConfig;

@Generated(from="CacheConfig", generator="Immutables")
public final class ImmutableCacheConfig
implements CacheConfig {
    private final long capacityMb;
    private final MeterRegistry meterRegistry;
    private final Duration referenceTtl;
    private final Duration referenceNegativeTtl;
    private final Boolean enableSoftReferences;
    private final double cacheCapacityOvershoot;
    private final LongSupplier clockNanos;
    private final Executor executor;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCacheConfig(Builder builder) {
        this.capacityMb = builder.capacityMb;
        this.meterRegistry = builder.meterRegistry;
        this.referenceTtl = builder.referenceTtl;
        this.referenceNegativeTtl = builder.referenceNegativeTtl;
        this.enableSoftReferences = builder.enableSoftReferences;
        this.cacheCapacityOvershoot = builder.cacheCapacityOvershoot;
        if (builder.clockNanos != null) {
            this.initShim.clockNanos(builder.clockNanos);
        }
        if (builder.executor != null) {
            this.initShim.executor(builder.executor);
        }
        this.clockNanos = this.initShim.clockNanos();
        this.executor = this.initShim.executor();
        this.initShim = null;
    }

    private ImmutableCacheConfig(long capacityMb, MeterRegistry meterRegistry, Duration referenceTtl, Duration referenceNegativeTtl, Boolean enableSoftReferences, double cacheCapacityOvershoot, LongSupplier clockNanos, Executor executor) {
        this.capacityMb = capacityMb;
        this.meterRegistry = meterRegistry;
        this.referenceTtl = referenceTtl;
        this.referenceNegativeTtl = referenceNegativeTtl;
        this.enableSoftReferences = enableSoftReferences;
        this.cacheCapacityOvershoot = cacheCapacityOvershoot;
        this.clockNanos = clockNanos;
        this.executor = executor;
        this.initShim = null;
    }

    private LongSupplier clockNanosInitialize() {
        return CacheConfig.super.clockNanos();
    }

    private Executor executorInitialize() {
        return CacheConfig.super.executor();
    }

    @Override
    public long capacityMb() {
        return this.capacityMb;
    }

    @Override
    public Optional<MeterRegistry> meterRegistry() {
        return Optional.ofNullable(this.meterRegistry);
    }

    @Override
    public Optional<Duration> referenceTtl() {
        return Optional.ofNullable(this.referenceTtl);
    }

    @Override
    public Optional<Duration> referenceNegativeTtl() {
        return Optional.ofNullable(this.referenceNegativeTtl);
    }

    @Override
    public Optional<Boolean> enableSoftReferences() {
        return Optional.ofNullable(this.enableSoftReferences);
    }

    @Override
    public double cacheCapacityOvershoot() {
        return this.cacheCapacityOvershoot;
    }

    @Override
    public LongSupplier clockNanos() {
        InitShim shim = this.initShim;
        return shim != null ? shim.clockNanos() : this.clockNanos;
    }

    @Override
    public Executor executor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.executor() : this.executor;
    }

    public final ImmutableCacheConfig withCapacityMb(long value) {
        if (this.capacityMb == value) {
            return this;
        }
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(value, this.meterRegistry, this.referenceTtl, this.referenceNegativeTtl, this.enableSoftReferences, this.cacheCapacityOvershoot, this.clockNanos, this.executor));
    }

    public final ImmutableCacheConfig withMeterRegistry(MeterRegistry value) {
        MeterRegistry newValue = Objects.requireNonNull(value, "meterRegistry");
        if (this.meterRegistry == newValue) {
            return this;
        }
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this.capacityMb, newValue, this.referenceTtl, this.referenceNegativeTtl, this.enableSoftReferences, this.cacheCapacityOvershoot, this.clockNanos, this.executor));
    }

    public final ImmutableCacheConfig withMeterRegistry(Optional<? extends MeterRegistry> optional) {
        MeterRegistry value = optional.orElse(null);
        if (this.meterRegistry == value) {
            return this;
        }
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this.capacityMb, value, this.referenceTtl, this.referenceNegativeTtl, this.enableSoftReferences, this.cacheCapacityOvershoot, this.clockNanos, this.executor));
    }

    public final ImmutableCacheConfig withReferenceTtl(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "referenceTtl");
        if (this.referenceTtl == newValue) {
            return this;
        }
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this.capacityMb, this.meterRegistry, newValue, this.referenceNegativeTtl, this.enableSoftReferences, this.cacheCapacityOvershoot, this.clockNanos, this.executor));
    }

    public final ImmutableCacheConfig withReferenceTtl(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.referenceTtl == value) {
            return this;
        }
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this.capacityMb, this.meterRegistry, value, this.referenceNegativeTtl, this.enableSoftReferences, this.cacheCapacityOvershoot, this.clockNanos, this.executor));
    }

    public final ImmutableCacheConfig withReferenceNegativeTtl(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "referenceNegativeTtl");
        if (this.referenceNegativeTtl == newValue) {
            return this;
        }
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this.capacityMb, this.meterRegistry, this.referenceTtl, newValue, this.enableSoftReferences, this.cacheCapacityOvershoot, this.clockNanos, this.executor));
    }

    public final ImmutableCacheConfig withReferenceNegativeTtl(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.referenceNegativeTtl == value) {
            return this;
        }
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this.capacityMb, this.meterRegistry, this.referenceTtl, value, this.enableSoftReferences, this.cacheCapacityOvershoot, this.clockNanos, this.executor));
    }

    public final ImmutableCacheConfig withEnableSoftReferences(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.enableSoftReferences, newValue)) {
            return this;
        }
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this.capacityMb, this.meterRegistry, this.referenceTtl, this.referenceNegativeTtl, newValue, this.cacheCapacityOvershoot, this.clockNanos, this.executor));
    }

    public final ImmutableCacheConfig withEnableSoftReferences(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.enableSoftReferences, value)) {
            return this;
        }
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this.capacityMb, this.meterRegistry, this.referenceTtl, this.referenceNegativeTtl, value, this.cacheCapacityOvershoot, this.clockNanos, this.executor));
    }

    public final ImmutableCacheConfig withCacheCapacityOvershoot(double value) {
        if (Double.doubleToLongBits(this.cacheCapacityOvershoot) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this.capacityMb, this.meterRegistry, this.referenceTtl, this.referenceNegativeTtl, this.enableSoftReferences, value, this.clockNanos, this.executor));
    }

    public final ImmutableCacheConfig withClockNanos(LongSupplier value) {
        if (this.clockNanos == value) {
            return this;
        }
        LongSupplier newValue = Objects.requireNonNull(value, "clockNanos");
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this.capacityMb, this.meterRegistry, this.referenceTtl, this.referenceNegativeTtl, this.enableSoftReferences, this.cacheCapacityOvershoot, newValue, this.executor));
    }

    public final ImmutableCacheConfig withExecutor(Executor value) {
        if (this.executor == value) {
            return this;
        }
        Executor newValue = Objects.requireNonNull(value, "executor");
        return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this.capacityMb, this.meterRegistry, this.referenceTtl, this.referenceNegativeTtl, this.enableSoftReferences, this.cacheCapacityOvershoot, this.clockNanos, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCacheConfig && this.equalsByValue((ImmutableCacheConfig)another);
    }

    private boolean equalsByValue(ImmutableCacheConfig another) {
        return this.capacityMb == another.capacityMb && Objects.equals(this.meterRegistry, another.meterRegistry) && Objects.equals(this.referenceTtl, another.referenceTtl) && Objects.equals(this.referenceNegativeTtl, another.referenceNegativeTtl) && Objects.equals(this.enableSoftReferences, another.enableSoftReferences) && Double.doubleToLongBits(this.cacheCapacityOvershoot) == Double.doubleToLongBits(another.cacheCapacityOvershoot) && this.clockNanos.equals(another.clockNanos) && this.executor.equals(another.executor);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.capacityMb);
        h += (h << 5) + Objects.hashCode(this.meterRegistry);
        h += (h << 5) + Objects.hashCode(this.referenceTtl);
        h += (h << 5) + Objects.hashCode(this.referenceNegativeTtl);
        h += (h << 5) + Objects.hashCode(this.enableSoftReferences);
        h += (h << 5) + Doubles.hashCode((double)this.cacheCapacityOvershoot);
        h += (h << 5) + this.clockNanos.hashCode();
        h += (h << 5) + this.executor.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CacheConfig").omitNullValues().add("capacityMb", this.capacityMb).add("meterRegistry", (Object)this.meterRegistry).add("referenceTtl", (Object)this.referenceTtl).add("referenceNegativeTtl", (Object)this.referenceNegativeTtl).add("enableSoftReferences", (Object)this.enableSoftReferences).add("cacheCapacityOvershoot", this.cacheCapacityOvershoot).add("clockNanos", (Object)this.clockNanos).add("executor", (Object)this.executor).toString();
    }

    private static ImmutableCacheConfig validate(ImmutableCacheConfig instance) {
        instance.check();
        return instance;
    }

    public static ImmutableCacheConfig copyOf(CacheConfig instance) {
        if (instance instanceof ImmutableCacheConfig) {
            return (ImmutableCacheConfig)instance;
        }
        return ImmutableCacheConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CacheConfig", generator="Immutables")
    private final class InitShim {
        private byte clockNanosBuildStage = 0;
        private LongSupplier clockNanos;
        private byte executorBuildStage = 0;
        private Executor executor;

        private InitShim() {
        }

        LongSupplier clockNanos() {
            if (this.clockNanosBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clockNanosBuildStage == 0) {
                this.clockNanosBuildStage = (byte)-1;
                LongSupplier computedValue = ImmutableCacheConfig.this.clockNanosInitialize();
                this.clockNanos = Objects.requireNonNull(computedValue, "clockNanos");
                this.clockNanosBuildStage = 1;
            }
            return this.clockNanos;
        }

        void clockNanos(LongSupplier clockNanos) {
            this.clockNanos = clockNanos;
            this.clockNanosBuildStage = 1;
        }

        Executor executor() {
            if (this.executorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.executorBuildStage == 0) {
                this.executorBuildStage = (byte)-1;
                Executor computedValue = ImmutableCacheConfig.this.executorInitialize();
                this.executor = Objects.requireNonNull(computedValue, "executor");
                this.executorBuildStage = 1;
            }
            return this.executor;
        }

        void executor(Executor executor) {
            this.executor = executor;
            this.executorBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.clockNanosBuildStage == -1) {
                attributes.add("clockNanos");
            }
            if (this.executorBuildStage == -1) {
                attributes.add("executor");
            }
            return "Cannot build CacheConfig, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="CacheConfig", generator="Immutables")
    public static final class Builder
    implements CacheConfig.Builder {
        private static final long INIT_BIT_CAPACITY_MB = 1L;
        private static final long INIT_BIT_CACHE_CAPACITY_OVERSHOOT = 2L;
        private long initBits = 3L;
        private long capacityMb;
        private MeterRegistry meterRegistry;
        private Duration referenceTtl;
        private Duration referenceNegativeTtl;
        private Boolean enableSoftReferences;
        private double cacheCapacityOvershoot;
        private LongSupplier clockNanos;
        private Executor executor;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CacheConfig instance) {
            Optional<Boolean> enableSoftReferencesOptional;
            Optional<Duration> referenceNegativeTtlOptional;
            Optional<Duration> referenceTtlOptional;
            Objects.requireNonNull(instance, "instance");
            this.capacityMb(instance.capacityMb());
            Optional<MeterRegistry> meterRegistryOptional = instance.meterRegistry();
            if (meterRegistryOptional.isPresent()) {
                this.meterRegistry(meterRegistryOptional);
            }
            if ((referenceTtlOptional = instance.referenceTtl()).isPresent()) {
                this.referenceTtl(referenceTtlOptional);
            }
            if ((referenceNegativeTtlOptional = instance.referenceNegativeTtl()).isPresent()) {
                this.referenceNegativeTtl(referenceNegativeTtlOptional);
            }
            if ((enableSoftReferencesOptional = instance.enableSoftReferences()).isPresent()) {
                this.enableSoftReferences(enableSoftReferencesOptional);
            }
            this.cacheCapacityOvershoot(instance.cacheCapacityOvershoot());
            this.clockNanos(instance.clockNanos());
            this.executor(instance.executor());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder capacityMb(long capacityMb) {
            this.capacityMb = capacityMb;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder meterRegistry(MeterRegistry meterRegistry) {
            this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder meterRegistry(Optional<? extends MeterRegistry> meterRegistry) {
            this.meterRegistry = meterRegistry.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder referenceTtl(Duration referenceTtl) {
            this.referenceTtl = Objects.requireNonNull(referenceTtl, "referenceTtl");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder referenceTtl(Optional<? extends Duration> referenceTtl) {
            this.referenceTtl = referenceTtl.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder referenceNegativeTtl(Duration referenceNegativeTtl) {
            this.referenceNegativeTtl = Objects.requireNonNull(referenceNegativeTtl, "referenceNegativeTtl");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder referenceNegativeTtl(Optional<? extends Duration> referenceNegativeTtl) {
            this.referenceNegativeTtl = referenceNegativeTtl.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder enableSoftReferences(boolean enableSoftReferences) {
            this.enableSoftReferences = enableSoftReferences;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enableSoftReferences(Optional<Boolean> enableSoftReferences) {
            this.enableSoftReferences = enableSoftReferences.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder cacheCapacityOvershoot(double cacheCapacityOvershoot) {
            this.cacheCapacityOvershoot = cacheCapacityOvershoot;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder clockNanos(LongSupplier clockNanos) {
            this.clockNanos = Objects.requireNonNull(clockNanos, "clockNanos");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder executor(Executor executor) {
            this.executor = Objects.requireNonNull(executor, "executor");
            return this;
        }

        @Override
        public ImmutableCacheConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableCacheConfig.validate(new ImmutableCacheConfig(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("capacityMb");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("cacheCapacityOvershoot");
            }
            return "Cannot build CacheConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

