/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.cache;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.cache.CacheBackend;
import org.projectnessie.versioned.storage.cache.DistributedCacheInvalidation;
import org.projectnessie.versioned.storage.cache.DistributedCacheInvalidationConsumer;
import org.projectnessie.versioned.storage.cache.DistributedCacheInvalidations;

@Generated(from="DistributedCacheInvalidations", generator="Immutables")
public final class ImmutableDistributedCacheInvalidations
implements DistributedCacheInvalidations {
    private final CacheBackend localBackend;
    private final DistributedCacheInvalidation invalidationSender;
    private final DistributedCacheInvalidationConsumer invalidationListenerReceiver;

    private ImmutableDistributedCacheInvalidations(CacheBackend localBackend, DistributedCacheInvalidation invalidationSender, DistributedCacheInvalidationConsumer invalidationListenerReceiver) {
        this.localBackend = localBackend;
        this.invalidationSender = invalidationSender;
        this.invalidationListenerReceiver = invalidationListenerReceiver;
    }

    @Override
    public CacheBackend localBackend() {
        return this.localBackend;
    }

    @Override
    public DistributedCacheInvalidation invalidationSender() {
        return this.invalidationSender;
    }

    @Override
    public DistributedCacheInvalidationConsumer invalidationListenerReceiver() {
        return this.invalidationListenerReceiver;
    }

    public final ImmutableDistributedCacheInvalidations withLocalBackend(CacheBackend value) {
        if (this.localBackend == value) {
            return this;
        }
        CacheBackend newValue = Objects.requireNonNull(value, "localBackend");
        return new ImmutableDistributedCacheInvalidations(newValue, this.invalidationSender, this.invalidationListenerReceiver);
    }

    public final ImmutableDistributedCacheInvalidations withInvalidationSender(DistributedCacheInvalidation value) {
        if (this.invalidationSender == value) {
            return this;
        }
        DistributedCacheInvalidation newValue = Objects.requireNonNull(value, "invalidationSender");
        return new ImmutableDistributedCacheInvalidations(this.localBackend, newValue, this.invalidationListenerReceiver);
    }

    public final ImmutableDistributedCacheInvalidations withInvalidationListenerReceiver(DistributedCacheInvalidationConsumer value) {
        if (this.invalidationListenerReceiver == value) {
            return this;
        }
        DistributedCacheInvalidationConsumer newValue = Objects.requireNonNull(value, "invalidationListenerReceiver");
        return new ImmutableDistributedCacheInvalidations(this.localBackend, this.invalidationSender, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDistributedCacheInvalidations && this.equalsByValue((ImmutableDistributedCacheInvalidations)another);
    }

    private boolean equalsByValue(ImmutableDistributedCacheInvalidations another) {
        return this.localBackend.equals(another.localBackend) && this.invalidationSender.equals(another.invalidationSender) && this.invalidationListenerReceiver.equals(another.invalidationListenerReceiver);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.localBackend.hashCode();
        h += (h << 5) + this.invalidationSender.hashCode();
        h += (h << 5) + this.invalidationListenerReceiver.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DistributedCacheInvalidations").omitNullValues().add("localBackend", (Object)this.localBackend).add("invalidationSender", (Object)this.invalidationSender).add("invalidationListenerReceiver", (Object)this.invalidationListenerReceiver).toString();
    }

    public static ImmutableDistributedCacheInvalidations copyOf(DistributedCacheInvalidations instance) {
        if (instance instanceof ImmutableDistributedCacheInvalidations) {
            return (ImmutableDistributedCacheInvalidations)instance;
        }
        return ImmutableDistributedCacheInvalidations.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DistributedCacheInvalidations", generator="Immutables")
    public static final class Builder
    implements DistributedCacheInvalidations.Builder {
        private static final long INIT_BIT_LOCAL_BACKEND = 1L;
        private static final long INIT_BIT_INVALIDATION_SENDER = 2L;
        private static final long INIT_BIT_INVALIDATION_LISTENER_RECEIVER = 4L;
        private long initBits = 7L;
        private CacheBackend localBackend;
        private DistributedCacheInvalidation invalidationSender;
        private DistributedCacheInvalidationConsumer invalidationListenerReceiver;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DistributedCacheInvalidations instance) {
            Objects.requireNonNull(instance, "instance");
            this.localBackend(instance.localBackend());
            this.invalidationSender(instance.invalidationSender());
            this.invalidationListenerReceiver(instance.invalidationListenerReceiver());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder localBackend(CacheBackend localBackend) {
            this.localBackend = Objects.requireNonNull(localBackend, "localBackend");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder invalidationSender(DistributedCacheInvalidation invalidationSender) {
            this.invalidationSender = Objects.requireNonNull(invalidationSender, "invalidationSender");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder invalidationListenerReceiver(DistributedCacheInvalidationConsumer invalidationListenerReceiver) {
            this.invalidationListenerReceiver = Objects.requireNonNull(invalidationListenerReceiver, "invalidationListenerReceiver");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        public ImmutableDistributedCacheInvalidations build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDistributedCacheInvalidations(this.localBackend, this.invalidationSender, this.invalidationListenerReceiver);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("localBackend");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("invalidationSender");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("invalidationListenerReceiver");
            }
            return "Cannot build DistributedCacheInvalidations, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

