/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import jakarta.annotation.Nonnull;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.cache.CacheBackend;
import org.projectnessie.versioned.storage.cache.CachingPersistImpl;
import org.projectnessie.versioned.storage.cache.ImmutableCaffeineCacheBackend;
import org.projectnessie.versioned.storage.cache.ObjCacheImpl;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.serialize.ProtoSerialization;

@Value.Immutable
abstract class CaffeineCacheBackend
implements CacheBackend {
    public static final int JAVA_OBJ_HEADER = 32;

    CaffeineCacheBackend() {
    }

    static ImmutableCaffeineCacheBackend.Builder builder() {
        return ImmutableCaffeineCacheBackend.builder();
    }

    abstract long capacity();

    @Value.Derived
    Cache<CacheKey, byte[]> cache() {
        return Caffeine.newBuilder().maximumWeight(this.capacity()).recordStats().weigher(this::weigher).build();
    }

    @Override
    public Persist wrap(@javax.annotation.Nonnull @Nonnull Persist persist) {
        ObjCacheImpl cache = new ObjCacheImpl(this, persist.config().repositoryId());
        return new CachingPersistImpl(persist, cache);
    }

    private int weigher(CacheKey key, byte[] data) {
        return key.heapSize() + 32 + data.length;
    }

    @Override
    public Obj get(@javax.annotation.Nonnull @Nonnull String repositoryId, @javax.annotation.Nonnull @Nonnull ObjId id) {
        CacheKey key = this.cacheKey(repositoryId, id);
        byte[] bytes = (byte[])this.cache().getIfPresent((Object)key);
        return bytes != null ? ProtoSerialization.deserializeObj((ObjId)id, (byte[])bytes) : null;
    }

    @Override
    public void put(@javax.annotation.Nonnull @Nonnull String repositoryId, @javax.annotation.Nonnull @Nonnull Obj obj) {
        CacheKey key = this.cacheKey(repositoryId, obj.id());
        try {
            this.cache().put((Object)key, (Object)ProtoSerialization.serializeObj((Obj)obj, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE));
        }
        catch (ObjTooLargeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove(@javax.annotation.Nonnull @Nonnull String repositoryId, @javax.annotation.Nonnull @Nonnull ObjId id) {
        CacheKey key = this.cacheKey(repositoryId, id);
        this.cache().invalidate((Object)key);
    }

    @Override
    public void clear(@javax.annotation.Nonnull @Nonnull String repositoryId) {
        this.cache().asMap().keySet().removeIf(k -> k.repositoryId.equals(repositoryId));
    }

    private CacheKey cacheKey(String repositoryId, ObjId id) {
        return new CacheKey(repositoryId, id);
    }

    static final class CacheKey {
        static final int HEAP_OVERHEAD = 96;
        final String repositoryId;
        final ObjId id;

        CacheKey(String repositoryId, ObjId id) {
            this.repositoryId = repositoryId;
            this.id = id;
        }

        int heapSize() {
            return 96 + this.id.size() + this.repositoryId.length();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.repositoryId.equals(cacheKey.repositoryId) && this.id.equals(cacheKey.id);
        }

        public int hashCode() {
            return this.repositoryId.hashCode() * 31 + this.id.hashCode();
        }

        public String toString() {
            return "CacheKey{" + this.repositoryId + ", " + this.id + '}';
        }
    }
}

