/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.cache;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.cache.ImmutableCacheSizing;

@Value.Immutable
public interface CacheSizing {
    public static final int DEFAULT_HEAP_SIZE_KEEP_FREE = 256;
    public static final int DEFAULT_MIN_SIZE_MB = 64;
    public static final double DEFAULT_HEAP_FRACTION = 0.7;

    public OptionalInt fixedSizeInMB();

    public OptionalDouble fractionOfMaxHeapSize();

    public OptionalInt fractionMinSizeMb();

    public OptionalInt heapSizeAdjustmentMB();

    default public int calculateEffectiveSizeInMB() {
        return this.calculateEffectiveSizeInMB(Runtime.getRuntime().maxMemory());
    }

    default public int calculateEffectiveSizeInMB(long maxHeapInBytes) {
        long fractionMin;
        if (this.fixedSizeInMB().isPresent()) {
            return this.fixedSizeInMB().getAsInt();
        }
        long fractionAsBytes = (long)(this.fractionOfMaxHeapSize().orElse(0.7) * (double)maxHeapInBytes);
        long freeHeap = maxHeapInBytes - fractionAsBytes;
        long minFree = (long)this.heapSizeAdjustmentMB().orElse(256) * 1024L * 1024L;
        long capacityInBytes = minFree > freeHeap ? maxHeapInBytes - minFree : fractionAsBytes;
        if (capacityInBytes < (fractionMin = (long)this.fractionMinSizeMb().orElse(64) * 1024L * 1024L)) {
            capacityInBytes = fractionMin;
        }
        return (int)(capacityInBytes / 1024L / 1024L);
    }

    public static Builder builder() {
        return ImmutableCacheSizing.builder();
    }

    @Value.Check
    default public void check() {
        Preconditions.checkState((!this.fixedSizeInMB().isPresent() || !this.fractionOfMaxHeapSize().isPresent() ? 1 : 0) != 0, (Object)"Cache sizing: must not specify both fractionOfMaxHeapSize and sizeInBytes, use either.");
        if (this.fractionOfMaxHeapSize().isPresent()) {
            Preconditions.checkState((this.fractionOfMaxHeapSize().getAsDouble() > 0.0 && this.fractionOfMaxHeapSize().getAsDouble() < 1.0 ? 1 : 0) != 0, (String)"Cache sizing: fractionOfMaxHeapSize must be > 0 and < 1, but is %s", (Object)this.fractionOfMaxHeapSize());
        }
        if (this.fixedSizeInMB().isPresent()) {
            int fixed = this.fixedSizeInMB().getAsInt();
            Preconditions.checkState((fixed == 0 || fixed > 64 ? 1 : 0) != 0, (String)"Cache sizing: sizeInBytes must be greater than 64 MB, but is %s", (Object)this.fixedSizeInMB());
        }
        Preconditions.checkState((this.heapSizeAdjustmentMB().orElse(256) > 64 ? 1 : 0) != 0, (String)"Cache sizing: heapSizeAdjustment must be greater than 64 MB, but is %s", (Object)this.heapSizeAdjustmentMB());
    }

    public static interface Builder {
        @CanIgnoreReturnValue
        public Builder fixedSizeInMB(int var1);

        @CanIgnoreReturnValue
        public Builder fixedSizeInMB(OptionalInt var1);

        @CanIgnoreReturnValue
        public Builder fractionOfMaxHeapSize(double var1);

        @CanIgnoreReturnValue
        public Builder fractionOfMaxHeapSize(OptionalDouble var1);

        @CanIgnoreReturnValue
        public Builder fractionMinSizeMb(int var1);

        @CanIgnoreReturnValue
        public Builder fractionMinSizeMb(OptionalInt var1);

        @CanIgnoreReturnValue
        public Builder heapSizeAdjustmentMB(int var1);

        @CanIgnoreReturnValue
        public Builder heapSizeAdjustmentMB(OptionalInt var1);

        public CacheSizing build();
    }
}

