/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.cache.CaffeineCacheBackend;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CaffeineCacheBackend", generator="Immutables")
@Immutable
final class ImmutableCaffeineCacheBackend
extends CaffeineCacheBackend {
    private final long capacity;
    private final transient Cache<CaffeineCacheBackend.CacheKey, byte[]> cache;

    private ImmutableCaffeineCacheBackend(long capacity) {
        this.capacity = capacity;
        this.cache = Objects.requireNonNull(super.cache(), "cache");
    }

    @Override
    long capacity() {
        return this.capacity;
    }

    @Override
    Cache<CaffeineCacheBackend.CacheKey, byte[]> cache() {
        return this.cache;
    }

    public final ImmutableCaffeineCacheBackend withCapacity(long value) {
        if (this.capacity == value) {
            return this;
        }
        return new ImmutableCaffeineCacheBackend(value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCaffeineCacheBackend && this.equalTo(0, (ImmutableCaffeineCacheBackend)another);
    }

    private boolean equalTo(int synthetic, ImmutableCaffeineCacheBackend another) {
        return this.capacity == another.capacity && this.cache.equals(another.cache);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.capacity);
        h += (h << 5) + this.cache.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CaffeineCacheBackend").omitNullValues().add("capacity", this.capacity).add("cache", this.cache).toString();
    }

    public static ImmutableCaffeineCacheBackend copyOf(CaffeineCacheBackend instance) {
        if (instance instanceof ImmutableCaffeineCacheBackend) {
            return (ImmutableCaffeineCacheBackend)instance;
        }
        return ImmutableCaffeineCacheBackend.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CaffeineCacheBackend", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CAPACITY = 1L;
        private long initBits = 1L;
        private long capacity;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CaffeineCacheBackend instance) {
            Objects.requireNonNull(instance, "instance");
            this.capacity(instance.capacity());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder capacity(long capacity) {
            this.capacity = capacity;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableCaffeineCacheBackend build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCaffeineCacheBackend(this.capacity);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("capacity");
            }
            return "Cannot build CaffeineCacheBackend, some of required attributes are not set " + attributes;
        }
    }
}

