/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.cache;

import jakarta.annotation.Nonnull;
import org.projectnessie.versioned.storage.cache.CacheBackend;
import org.projectnessie.versioned.storage.cache.ObjCache;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;

final class ObjCacheImpl
implements ObjCache {
    private final CacheBackend backend;
    private final String repositoryId;

    ObjCacheImpl(CacheBackend backend, String repositoryId) {
        this.backend = backend;
        this.repositoryId = repositoryId;
    }

    @Override
    public Obj get(@Nonnull ObjId id) {
        return this.backend.get(this.repositoryId, id);
    }

    @Override
    public void put(@Nonnull Obj obj) {
        this.backend.put(this.repositoryId, obj);
    }

    @Override
    public void remove(@Nonnull ObjId id) {
        this.backend.remove(this.repositoryId, id);
    }

    @Override
    public void clear() {
        this.backend.clear(this.repositoryId);
    }
}

