/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.cache.CaffeineStatsCounter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import org.checkerframework.checker.index.qual.NonNegative;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.cache.CacheBackend;
import org.projectnessie.versioned.storage.cache.CachingPersistImpl;
import org.projectnessie.versioned.storage.cache.ImmutableCaffeineCacheBackend;
import org.projectnessie.versioned.storage.cache.ObjCacheImpl;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.serialize.ProtoSerialization;

@Value.Immutable
abstract class CaffeineCacheBackend
implements CacheBackend {
    public static final String CACHE_NAME = "nessie-objects";
    static final int OBJ_SIZE = 32;
    static final int ARRAY_OVERHEAD = 16;
    static final int STRING_OBJ_OVERHEAD = 40;
    static final int CAFFEINE_OBJ_OVERHEAD = 64;

    CaffeineCacheBackend() {
    }

    static ImmutableCaffeineCacheBackend.Builder builder() {
        return ImmutableCaffeineCacheBackend.builder();
    }

    abstract long capacity();

    @Nullable
    abstract MeterRegistry meterRegistry();

    abstract LongSupplier clockNanos();

    @Value.Derived
    Cache<CacheKeyValue, byte[]> cache() {
        Caffeine cacheBuilder = Caffeine.newBuilder().maximumWeight(this.capacity() * 1024L * 1024L).weigher(this::weigher).expireAfter((Expiry)new Expiry<CacheKeyValue, byte[]>(){

            public long expireAfterCreate(CacheKeyValue key, byte[] value, long currentTimeNanos) {
                long expire = key.expiresAtNanosEpoch;
                if (expire == -1L) {
                    return Long.MAX_VALUE;
                }
                if (expire == 0L) {
                    return 0L;
                }
                long remaining = expire - currentTimeNanos;
                return Math.max(0L, remaining);
            }

            public long expireAfterUpdate(CacheKeyValue key, byte[] value, long currentTimeNanos, @NonNegative long currentDurationNanos) {
                return this.expireAfterCreate(key, value, currentTimeNanos);
            }

            public long expireAfterRead(CacheKeyValue key, byte[] value, long currentTimeNanos, @NonNegative long currentDurationNanos) {
                return currentDurationNanos;
            }
        }).ticker(this.clockNanos()::getAsLong);
        MeterRegistry meterRegistry = this.meterRegistry();
        if (meterRegistry != null) {
            cacheBuilder.recordStats(() -> new CaffeineStatsCounter(meterRegistry, CACHE_NAME));
            meterRegistry.gauge("cache_capacity_mb", Collections.singletonList(Tag.of((String)"cache", (String)CACHE_NAME)), (Object)"", x -> this.capacity());
        }
        return cacheBuilder.build();
    }

    @Override
    public Persist wrap(@Nonnull Persist persist) {
        ObjCacheImpl cache = new ObjCacheImpl(this, persist.config());
        return new CachingPersistImpl(persist, cache);
    }

    private int weigher(CacheKeyValue key, byte[] value) {
        int size = key.heapSize();
        if (value != null) {
            size += 16 + value.length;
        }
        return size += 64;
    }

    @Override
    public Obj get(@Nonnull String repositoryId, @Nonnull ObjId id) {
        CacheKeyValue key = CaffeineCacheBackend.cacheKey(repositoryId, id);
        byte[] value = (byte[])this.cache().getIfPresent((Object)key);
        return value != null ? ProtoSerialization.deserializeObj((ObjId)id, (byte[])value, null) : null;
    }

    @Override
    public void put(@Nonnull String repositoryId, @Nonnull Obj obj) {
        long expiresAt = obj.type().cachedObjectExpiresAtMicros(obj, () -> TimeUnit.NANOSECONDS.toMicros(this.clockNanos().getAsLong()));
        if (expiresAt == 0L) {
            return;
        }
        try {
            byte[] serialized = ProtoSerialization.serializeObj((Obj)obj, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (boolean)true);
            long expiresAtNanos = expiresAt == -1L ? -1L : TimeUnit.MICROSECONDS.toNanos(expiresAt);
            CacheKeyValue keyValue = CaffeineCacheBackend.cacheKeyValue(repositoryId, obj.id(), expiresAtNanos);
            this.cache().put((Object)keyValue, (Object)serialized);
        }
        catch (ObjTooLargeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove(@Nonnull String repositoryId, @Nonnull ObjId id) {
        CacheKeyValue key = CaffeineCacheBackend.cacheKey(repositoryId, id);
        this.cache().invalidate((Object)key);
    }

    @Override
    public void clear(@Nonnull String repositoryId) {
        this.cache().asMap().keySet().removeIf(k -> k.repositoryId.equals(repositoryId));
    }

    static CacheKeyValue cacheKey(String repositoryId, ObjId id) {
        return new CacheKeyValue(repositoryId, id);
    }

    private static CacheKeyValue cacheKeyValue(String repositoryId, ObjId id, long expiresAtNanosEpoch) {
        return new CacheKeyValue(repositoryId, id, expiresAtNanosEpoch);
    }

    static final class CacheKeyValue {
        final String repositoryId;
        final ObjId id;
        final long expiresAtNanosEpoch;

        CacheKeyValue(String repositoryId, ObjId id) {
            this(repositoryId, id, 0L);
        }

        CacheKeyValue(String repositoryId, ObjId id, long expiresAtNanosEpoch) {
            this.repositoryId = repositoryId;
            this.id = id;
            this.expiresAtNanosEpoch = expiresAtNanosEpoch;
        }

        int heapSize() {
            int size = 32;
            size += 40 + this.repositoryId.length();
            return size += this.id.heapSize();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKeyValue)) {
                return false;
            }
            CacheKeyValue cacheKey = (CacheKeyValue)o;
            return this.repositoryId.equals(cacheKey.repositoryId) && this.id.equals(cacheKey.id);
        }

        public int hashCode() {
            return this.repositoryId.hashCode() * 31 + this.id.hashCode();
        }

        public String toString() {
            return "{" + this.repositoryId + ", " + this.id + "}";
        }
    }
}

