/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.cache;

import jakarta.annotation.Nonnull;
import java.util.Set;
import org.projectnessie.versioned.storage.cache.ObjCache;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RefConditionFailedException;
import org.projectnessie.versioned.storage.common.exceptions.RefNotFoundException;
import org.projectnessie.versioned.storage.common.persist.CloseableIterator;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.projectnessie.versioned.storage.common.persist.UpdateableObj;

class CachingPersistImpl
implements Persist {
    final Persist persist;
    final ObjCache cache;

    CachingPersistImpl(Persist persist, ObjCache cache) {
        this.persist = persist;
        this.cache = cache;
    }

    @Nonnull
    public Obj fetchObj(@Nonnull ObjId id) throws ObjNotFoundException {
        Obj o = this.cache.get(id);
        if (o != null) {
            return o;
        }
        try {
            o = this.persist.fetchObj(id);
            this.cache.put(o);
            return o;
        }
        catch (ObjNotFoundException e) {
            this.cache.remove(id);
            throw e;
        }
    }

    public Obj getImmediate(@Nonnull ObjId id) {
        return this.cache.get(id);
    }

    @Nonnull
    public <T extends Obj> T fetchTypedObj(@Nonnull ObjId id, ObjType type, Class<T> typeClass) throws ObjNotFoundException {
        Obj o = this.cache.get(id);
        if (o != null) {
            if (!o.type().equals(type)) {
                throw new ObjNotFoundException(id);
            }
        } else {
            o = this.persist.fetchTypedObj(id, type, typeClass);
            this.cache.put(o);
        }
        Obj r = o;
        return (T)r;
    }

    @Nonnull
    public ObjType fetchObjType(@Nonnull ObjId id) throws ObjNotFoundException {
        Obj o = this.cache.get(id);
        if (o != null) {
            return o.type();
        }
        return this.persist.fetchObjType(id);
    }

    @Nonnull
    public Obj[] fetchObjs(@Nonnull ObjId[] ids) throws ObjNotFoundException {
        Obj o;
        ObjId[] backendIds = null;
        Obj[] r = new Obj[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            ObjId id = ids[i];
            if (id == null) continue;
            o = this.cache.get(id);
            if (o != null) {
                r[i] = o;
                continue;
            }
            if (backendIds == null) {
                backendIds = new ObjId[ids.length];
            }
            backendIds[i] = id;
        }
        if (backendIds == null) {
            return r;
        }
        Obj[] backendResult = this.persist.fetchObjs(backendIds);
        for (int i = 0; i < backendResult.length; ++i) {
            o = backendResult[i];
            if (o == null) continue;
            r[i] = o;
            this.cache.put(o);
        }
        return r;
    }

    public boolean storeObj(@Nonnull Obj obj, boolean ignoreSoftSizeRestrictions) throws ObjTooLargeException {
        if (this.persist.storeObj(obj, ignoreSoftSizeRestrictions)) {
            this.cache.put(obj);
            return true;
        }
        return false;
    }

    @Nonnull
    public boolean[] storeObjs(@Nonnull Obj[] objs) throws ObjTooLargeException {
        boolean[] stored = this.persist.storeObjs(objs);
        for (int i = 0; i < stored.length; ++i) {
            if (!stored[i]) continue;
            this.cache.put(objs[i]);
        }
        return stored;
    }

    public void upsertObj(@Nonnull Obj obj) throws ObjTooLargeException {
        try {
            this.persist.upsertObj(obj);
        }
        finally {
            this.cache.remove(obj.id());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upsertObjs(@Nonnull Obj[] objs) throws ObjTooLargeException {
        try {
            this.persist.upsertObjs(objs);
        }
        finally {
            for (Obj obj : objs) {
                if (obj == null) continue;
                this.cache.remove(obj.id());
            }
        }
    }

    public void deleteObj(@Nonnull ObjId id) {
        try {
            this.persist.deleteObj(id);
        }
        finally {
            this.cache.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObjs(@Nonnull ObjId[] ids) {
        try {
            this.persist.deleteObjs(ids);
        }
        finally {
            for (ObjId id : ids) {
                if (id == null) continue;
                this.cache.remove(id);
            }
        }
    }

    public boolean deleteConditional(@Nonnull UpdateableObj obj) {
        try {
            boolean bl = this.persist.deleteConditional(obj);
            return bl;
        }
        finally {
            this.cache.remove(obj.id());
        }
    }

    public boolean updateConditional(@Nonnull UpdateableObj expected, @Nonnull UpdateableObj newValue) throws ObjTooLargeException {
        if (this.persist.updateConditional(expected, newValue)) {
            this.cache.put((Obj)newValue);
            return true;
        }
        this.cache.remove(expected.id());
        return false;
    }

    public void erase() {
        try {
            this.persist.erase();
        }
        finally {
            this.cache.clear();
        }
    }

    @Nonnull
    public CloseableIterator<Obj> scanAllObjects(@Nonnull Set<ObjType> returnedObjTypes) {
        return this.persist.scanAllObjects(returnedObjTypes);
    }

    public int hardObjectSizeLimit() {
        return this.persist.hardObjectSizeLimit();
    }

    public int effectiveIndexSegmentSizeLimit() {
        return this.persist.effectiveIndexSegmentSizeLimit();
    }

    public int effectiveIncrementalIndexSizeLimit() {
        return this.persist.effectiveIncrementalIndexSizeLimit();
    }

    @Nonnull
    public StoreConfig config() {
        return this.persist.config();
    }

    @Nonnull
    public String name() {
        return this.persist.name();
    }

    @Nonnull
    public Reference addReference(@Nonnull Reference reference) throws RefAlreadyExistsException {
        return this.persist.addReference(reference);
    }

    @Nonnull
    public Reference markReferenceAsDeleted(@Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        return this.persist.markReferenceAsDeleted(reference);
    }

    public void purgeReference(@Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        this.persist.purgeReference(reference);
    }

    @Nonnull
    public Reference updateReferencePointer(@Nonnull Reference reference, @Nonnull ObjId newPointer) throws RefNotFoundException, RefConditionFailedException {
        return this.persist.updateReferencePointer(reference, newPointer);
    }

    public Reference fetchReference(@Nonnull String name) {
        return this.persist.fetchReference(name);
    }

    @Nonnull
    public Reference[] fetchReferences(@Nonnull String[] names) {
        return this.persist.fetchReferences(names);
    }
}

