/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.cache;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.LongSupplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.cache.CacheConfig;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CacheConfig", generator="Immutables")
@Immutable
public final class ImmutableCacheConfig
implements CacheConfig {
    private final long capacityMb;
    @Nullable
    private final MeterRegistry meterRegistry;
    private final LongSupplier clockNanos;

    private ImmutableCacheConfig(Builder builder) {
        this.capacityMb = builder.capacityMb;
        this.meterRegistry = builder.meterRegistry;
        this.clockNanos = builder.clockNanos != null ? builder.clockNanos : Objects.requireNonNull(CacheConfig.super.clockNanos(), "clockNanos");
    }

    private ImmutableCacheConfig(long capacityMb, @Nullable MeterRegistry meterRegistry, LongSupplier clockNanos) {
        this.capacityMb = capacityMb;
        this.meterRegistry = meterRegistry;
        this.clockNanos = clockNanos;
    }

    @Override
    public long capacityMb() {
        return this.capacityMb;
    }

    @Override
    public Optional<MeterRegistry> meterRegistry() {
        return Optional.ofNullable(this.meterRegistry);
    }

    @Override
    public LongSupplier clockNanos() {
        return this.clockNanos;
    }

    public final ImmutableCacheConfig withCapacityMb(long value) {
        if (this.capacityMb == value) {
            return this;
        }
        return new ImmutableCacheConfig(value, this.meterRegistry, this.clockNanos);
    }

    public final ImmutableCacheConfig withMeterRegistry(MeterRegistry value) {
        MeterRegistry newValue = Objects.requireNonNull(value, "meterRegistry");
        if (this.meterRegistry == newValue) {
            return this;
        }
        return new ImmutableCacheConfig(this.capacityMb, newValue, this.clockNanos);
    }

    public final ImmutableCacheConfig withMeterRegistry(Optional<? extends MeterRegistry> optional) {
        MeterRegistry value = optional.orElse(null);
        if (this.meterRegistry == value) {
            return this;
        }
        return new ImmutableCacheConfig(this.capacityMb, value, this.clockNanos);
    }

    public final ImmutableCacheConfig withClockNanos(LongSupplier value) {
        if (this.clockNanos == value) {
            return this;
        }
        LongSupplier newValue = Objects.requireNonNull(value, "clockNanos");
        return new ImmutableCacheConfig(this.capacityMb, this.meterRegistry, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCacheConfig && this.equalTo(0, (ImmutableCacheConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableCacheConfig another) {
        return this.capacityMb == another.capacityMb && Objects.equals(this.meterRegistry, another.meterRegistry) && this.clockNanos.equals(another.clockNanos);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.capacityMb);
        h += (h << 5) + Objects.hashCode(this.meterRegistry);
        h += (h << 5) + this.clockNanos.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CacheConfig").omitNullValues().add("capacityMb", this.capacityMb).add("meterRegistry", (Object)this.meterRegistry).add("clockNanos", (Object)this.clockNanos).toString();
    }

    public static ImmutableCacheConfig copyOf(CacheConfig instance) {
        if (instance instanceof ImmutableCacheConfig) {
            return (ImmutableCacheConfig)instance;
        }
        return ImmutableCacheConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CacheConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements CacheConfig.Builder {
        private static final long INIT_BIT_CAPACITY_MB = 1L;
        private long initBits = 1L;
        private long capacityMb;
        @Nullable
        private MeterRegistry meterRegistry;
        @Nullable
        private LongSupplier clockNanos;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CacheConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.capacityMb(instance.capacityMb());
            Optional<MeterRegistry> meterRegistryOptional = instance.meterRegistry();
            if (meterRegistryOptional.isPresent()) {
                this.meterRegistry(meterRegistryOptional);
            }
            this.clockNanos(instance.clockNanos());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder capacityMb(long capacityMb) {
            this.capacityMb = capacityMb;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder meterRegistry(MeterRegistry meterRegistry) {
            this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder meterRegistry(Optional<? extends MeterRegistry> meterRegistry) {
            this.meterRegistry = meterRegistry.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder clockNanos(LongSupplier clockNanos) {
            this.clockNanos = Objects.requireNonNull(clockNanos, "clockNanos");
            return this;
        }

        @Override
        public ImmutableCacheConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCacheConfig(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("capacityMb");
            }
            return "Cannot build CacheConfig, some of required attributes are not set " + attributes;
        }
    }
}

