/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.cache;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.cache.CacheSizing;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CacheSizing", generator="Immutables")
@Immutable
public final class ImmutableCacheSizing
implements CacheSizing {
    @Nullable
    private final Integer fixedSizeInMB;
    @Nullable
    private final Double fractionOfMaxHeapSize;
    @Nullable
    private final Integer fractionMinSizeMb;
    @Nullable
    private final Integer heapSizeAdjustmentMB;
    private final transient int effectiveSizeInMB;

    private ImmutableCacheSizing(@Nullable Integer fixedSizeInMB, @Nullable Double fractionOfMaxHeapSize, @Nullable Integer fractionMinSizeMb, @Nullable Integer heapSizeAdjustmentMB) {
        this.fixedSizeInMB = fixedSizeInMB;
        this.fractionOfMaxHeapSize = fractionOfMaxHeapSize;
        this.fractionMinSizeMb = fractionMinSizeMb;
        this.heapSizeAdjustmentMB = heapSizeAdjustmentMB;
        this.effectiveSizeInMB = CacheSizing.super.effectiveSizeInMB();
    }

    @Override
    public OptionalInt fixedSizeInMB() {
        return this.fixedSizeInMB != null ? OptionalInt.of(this.fixedSizeInMB) : OptionalInt.empty();
    }

    @Override
    public OptionalDouble fractionOfMaxHeapSize() {
        return this.fractionOfMaxHeapSize != null ? OptionalDouble.of(this.fractionOfMaxHeapSize) : OptionalDouble.empty();
    }

    @Override
    public OptionalInt fractionMinSizeMb() {
        return this.fractionMinSizeMb != null ? OptionalInt.of(this.fractionMinSizeMb) : OptionalInt.empty();
    }

    @Override
    public OptionalInt heapSizeAdjustmentMB() {
        return this.heapSizeAdjustmentMB != null ? OptionalInt.of(this.heapSizeAdjustmentMB) : OptionalInt.empty();
    }

    @Override
    public int effectiveSizeInMB() {
        return this.effectiveSizeInMB;
    }

    public final ImmutableCacheSizing withFixedSizeInMB(int value) {
        Integer newValue = value;
        if (Objects.equals(this.fixedSizeInMB, newValue)) {
            return this;
        }
        return ImmutableCacheSizing.validate(new ImmutableCacheSizing(newValue, this.fractionOfMaxHeapSize, this.fractionMinSizeMb, this.heapSizeAdjustmentMB));
    }

    public final ImmutableCacheSizing withFixedSizeInMB(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.fixedSizeInMB, value)) {
            return this;
        }
        return ImmutableCacheSizing.validate(new ImmutableCacheSizing(value, this.fractionOfMaxHeapSize, this.fractionMinSizeMb, this.heapSizeAdjustmentMB));
    }

    public final ImmutableCacheSizing withFractionOfMaxHeapSize(double value) {
        Double newValue = value;
        if (Objects.equals(this.fractionOfMaxHeapSize, newValue)) {
            return this;
        }
        return ImmutableCacheSizing.validate(new ImmutableCacheSizing(this.fixedSizeInMB, newValue, this.fractionMinSizeMb, this.heapSizeAdjustmentMB));
    }

    public final ImmutableCacheSizing withFractionOfMaxHeapSize(OptionalDouble optional) {
        Double value;
        Double d = value = optional.isPresent() ? Double.valueOf(optional.getAsDouble()) : null;
        if (Objects.equals(this.fractionOfMaxHeapSize, value)) {
            return this;
        }
        return ImmutableCacheSizing.validate(new ImmutableCacheSizing(this.fixedSizeInMB, value, this.fractionMinSizeMb, this.heapSizeAdjustmentMB));
    }

    public final ImmutableCacheSizing withFractionMinSizeMb(int value) {
        Integer newValue = value;
        if (Objects.equals(this.fractionMinSizeMb, newValue)) {
            return this;
        }
        return ImmutableCacheSizing.validate(new ImmutableCacheSizing(this.fixedSizeInMB, this.fractionOfMaxHeapSize, newValue, this.heapSizeAdjustmentMB));
    }

    public final ImmutableCacheSizing withFractionMinSizeMb(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.fractionMinSizeMb, value)) {
            return this;
        }
        return ImmutableCacheSizing.validate(new ImmutableCacheSizing(this.fixedSizeInMB, this.fractionOfMaxHeapSize, value, this.heapSizeAdjustmentMB));
    }

    public final ImmutableCacheSizing withHeapSizeAdjustmentMB(int value) {
        Integer newValue = value;
        if (Objects.equals(this.heapSizeAdjustmentMB, newValue)) {
            return this;
        }
        return ImmutableCacheSizing.validate(new ImmutableCacheSizing(this.fixedSizeInMB, this.fractionOfMaxHeapSize, this.fractionMinSizeMb, newValue));
    }

    public final ImmutableCacheSizing withHeapSizeAdjustmentMB(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.heapSizeAdjustmentMB, value)) {
            return this;
        }
        return ImmutableCacheSizing.validate(new ImmutableCacheSizing(this.fixedSizeInMB, this.fractionOfMaxHeapSize, this.fractionMinSizeMb, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCacheSizing && this.equalTo(0, (ImmutableCacheSizing)another);
    }

    private boolean equalTo(int synthetic, ImmutableCacheSizing another) {
        return Objects.equals(this.fixedSizeInMB, another.fixedSizeInMB) && Objects.equals(this.fractionOfMaxHeapSize, another.fractionOfMaxHeapSize) && Objects.equals(this.fractionMinSizeMb, another.fractionMinSizeMb) && Objects.equals(this.heapSizeAdjustmentMB, another.heapSizeAdjustmentMB) && this.effectiveSizeInMB == another.effectiveSizeInMB;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.fixedSizeInMB);
        h += (h << 5) + Objects.hashCode(this.fractionOfMaxHeapSize);
        h += (h << 5) + Objects.hashCode(this.fractionMinSizeMb);
        h += (h << 5) + Objects.hashCode(this.heapSizeAdjustmentMB);
        h += (h << 5) + this.effectiveSizeInMB;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CacheSizing").omitNullValues().add("fixedSizeInMB", (Object)this.fixedSizeInMB).add("fractionOfMaxHeapSize", (Object)this.fractionOfMaxHeapSize).add("fractionMinSizeMb", (Object)this.fractionMinSizeMb).add("heapSizeAdjustmentMB", (Object)this.heapSizeAdjustmentMB).add("effectiveSizeInMB", this.effectiveSizeInMB).toString();
    }

    private static ImmutableCacheSizing validate(ImmutableCacheSizing instance) {
        instance.check();
        return instance;
    }

    public static ImmutableCacheSizing copyOf(CacheSizing instance) {
        if (instance instanceof ImmutableCacheSizing) {
            return (ImmutableCacheSizing)instance;
        }
        return ImmutableCacheSizing.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CacheSizing", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements CacheSizing.Builder {
        @Nullable
        private Integer fixedSizeInMB;
        @Nullable
        private Double fractionOfMaxHeapSize;
        @Nullable
        private Integer fractionMinSizeMb;
        @Nullable
        private Integer heapSizeAdjustmentMB;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CacheSizing instance) {
            OptionalInt heapSizeAdjustmentMBOptional;
            OptionalInt fractionMinSizeMbOptional;
            OptionalDouble fractionOfMaxHeapSizeOptional;
            Objects.requireNonNull(instance, "instance");
            OptionalInt fixedSizeInMBOptional = instance.fixedSizeInMB();
            if (fixedSizeInMBOptional.isPresent()) {
                this.fixedSizeInMB(fixedSizeInMBOptional);
            }
            if ((fractionOfMaxHeapSizeOptional = instance.fractionOfMaxHeapSize()).isPresent()) {
                this.fractionOfMaxHeapSize(fractionOfMaxHeapSizeOptional);
            }
            if ((fractionMinSizeMbOptional = instance.fractionMinSizeMb()).isPresent()) {
                this.fractionMinSizeMb(fractionMinSizeMbOptional);
            }
            if ((heapSizeAdjustmentMBOptional = instance.heapSizeAdjustmentMB()).isPresent()) {
                this.heapSizeAdjustmentMB(heapSizeAdjustmentMBOptional);
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder fixedSizeInMB(int fixedSizeInMB) {
            this.fixedSizeInMB = fixedSizeInMB;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder fixedSizeInMB(OptionalInt fixedSizeInMB) {
            this.fixedSizeInMB = fixedSizeInMB.isPresent() ? Integer.valueOf(fixedSizeInMB.getAsInt()) : null;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder fractionOfMaxHeapSize(double fractionOfMaxHeapSize) {
            this.fractionOfMaxHeapSize = fractionOfMaxHeapSize;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder fractionOfMaxHeapSize(OptionalDouble fractionOfMaxHeapSize) {
            this.fractionOfMaxHeapSize = fractionOfMaxHeapSize.isPresent() ? Double.valueOf(fractionOfMaxHeapSize.getAsDouble()) : null;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder fractionMinSizeMb(int fractionMinSizeMb) {
            this.fractionMinSizeMb = fractionMinSizeMb;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder fractionMinSizeMb(OptionalInt fractionMinSizeMb) {
            this.fractionMinSizeMb = fractionMinSizeMb.isPresent() ? Integer.valueOf(fractionMinSizeMb.getAsInt()) : null;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder heapSizeAdjustmentMB(int heapSizeAdjustmentMB) {
            this.heapSizeAdjustmentMB = heapSizeAdjustmentMB;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder heapSizeAdjustmentMB(OptionalInt heapSizeAdjustmentMB) {
            this.heapSizeAdjustmentMB = heapSizeAdjustmentMB.isPresent() ? Integer.valueOf(heapSizeAdjustmentMB.getAsInt()) : null;
            return this;
        }

        @Override
        public ImmutableCacheSizing build() {
            return ImmutableCacheSizing.validate(new ImmutableCacheSizing(this.fixedSizeInMB, this.fractionOfMaxHeapSize, this.fractionMinSizeMb, this.heapSizeAdjustmentMB));
        }
    }
}

