/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.cache.CaffeineStatsCounter;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.index.qual.NonNegative;
import org.projectnessie.versioned.storage.cache.CacheBackend;
import org.projectnessie.versioned.storage.cache.CacheConfig;
import org.projectnessie.versioned.storage.cache.CachingPersistImpl;
import org.projectnessie.versioned.storage.cache.ObjCacheImpl;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.projectnessie.versioned.storage.serialize.ProtoSerialization;

class CaffeineCacheBackend
implements CacheBackend {
    public static final String CACHE_NAME = "nessie-objects";
    private static final byte[] NON_EXISTING_SENTINEL = "NON_EXISTING".getBytes(StandardCharsets.UTF_8);
    private final CacheConfig config;
    final Cache<CacheKeyValue, byte[]> cache;
    private final long refCacheTtlNanos;
    private final long refCacheNegativeTtlNanos;
    static final int OBJ_SIZE = 32;
    static final int ARRAY_OVERHEAD = 16;
    static final int STRING_OBJ_OVERHEAD = 40;
    static final int CAFFEINE_OBJ_OVERHEAD = 64;

    CaffeineCacheBackend(CacheConfig config) {
        this.config = config;
        this.refCacheTtlNanos = config.referenceTtl().orElse(Duration.ZERO).toNanos();
        this.refCacheNegativeTtlNanos = config.referenceNegativeTtl().orElse(Duration.ZERO).toNanos();
        Caffeine cacheBuilder = Caffeine.newBuilder().maximumWeight(config.capacityMb() * 1024L * 1024L).weigher(this::weigher).expireAfter((Expiry)new Expiry<CacheKeyValue, byte[]>(){

            public long expireAfterCreate(CacheKeyValue key, byte[] value, long currentTimeNanos) {
                long expire = key.expiresAtNanosEpoch;
                if (expire == -1L) {
                    return Long.MAX_VALUE;
                }
                if (expire == 0L) {
                    return 0L;
                }
                long remaining = expire - currentTimeNanos;
                return Math.max(0L, remaining);
            }

            public long expireAfterUpdate(CacheKeyValue key, byte[] value, long currentTimeNanos, @NonNegative long currentDurationNanos) {
                return this.expireAfterCreate(key, value, currentTimeNanos);
            }

            public long expireAfterRead(CacheKeyValue key, byte[] value, long currentTimeNanos, @NonNegative long currentDurationNanos) {
                return currentDurationNanos;
            }
        }).ticker(config.clockNanos()::getAsLong);
        config.meterRegistry().ifPresent(meterRegistry -> {
            cacheBuilder.recordStats(() -> new CaffeineStatsCounter(meterRegistry, CACHE_NAME));
            meterRegistry.gauge("cache_capacity_mb", Collections.singletonList(Tag.of((String)"cache", (String)CACHE_NAME)), (Object)"", x -> config.capacityMb());
        });
        this.cache = cacheBuilder.build();
    }

    @Override
    public Persist wrap(@Nonnull Persist persist) {
        ObjCacheImpl cache = new ObjCacheImpl(this, persist.config());
        return new CachingPersistImpl(persist, cache);
    }

    private int weigher(CacheKeyValue key, byte[] value) {
        int size = key.heapSize();
        if (value != null) {
            size += 16 + value.length;
        }
        return size += 64;
    }

    @Override
    public Obj get(@Nonnull String repositoryId, @Nonnull ObjId id) {
        CacheKeyValue key = CaffeineCacheBackend.cacheKey(repositoryId, id);
        byte[] value = (byte[])this.cache.getIfPresent((Object)key);
        if (value == null) {
            return null;
        }
        if (value == NON_EXISTING_SENTINEL) {
            return NOT_FOUND_OBJ_SENTINEL;
        }
        return ProtoSerialization.deserializeObj((ObjId)id, (byte[])value, null);
    }

    @Override
    public void put(@Nonnull String repositoryId, @Nonnull Obj obj) {
        this.putLocal(repositoryId, obj);
    }

    @Override
    public void putLocal(@Nonnull String repositoryId, @Nonnull Obj obj) {
        long expiresAt = obj.type().cachedObjectExpiresAtMicros(obj, () -> TimeUnit.NANOSECONDS.toMicros(this.config.clockNanos().getAsLong()));
        if (expiresAt == 0L) {
            return;
        }
        try {
            byte[] serialized = ProtoSerialization.serializeObj((Obj)obj, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (boolean)true);
            long expiresAtNanos = expiresAt == -1L ? -1L : TimeUnit.MICROSECONDS.toNanos(expiresAt);
            CacheKeyValue keyValue = CaffeineCacheBackend.cacheKeyValue(repositoryId, obj.id(), expiresAtNanos);
            this.cache.put((Object)keyValue, (Object)serialized);
        }
        catch (ObjTooLargeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void putNegative(@Nonnull String repositoryId, @Nonnull ObjId id, @Nonnull ObjType type) {
        long expiresAt = type.negativeCacheExpiresAtMicros(() -> TimeUnit.NANOSECONDS.toMicros(this.config.clockNanos().getAsLong()));
        if (expiresAt == 0L) {
            this.remove(repositoryId, id);
            return;
        }
        long expiresAtNanos = expiresAt == -1L ? -1L : TimeUnit.MICROSECONDS.toNanos(expiresAt);
        CacheKeyValue keyValue = CaffeineCacheBackend.cacheKeyValue(repositoryId, id, expiresAtNanos);
        this.cache.put((Object)keyValue, (Object)NON_EXISTING_SENTINEL);
    }

    @Override
    public void remove(@Nonnull String repositoryId, @Nonnull ObjId id) {
        CacheKeyValue key = CaffeineCacheBackend.cacheKey(repositoryId, id);
        this.cache.invalidate((Object)key);
    }

    @Override
    public void clear(@Nonnull String repositoryId) {
        this.cache.asMap().keySet().removeIf(k -> k.repositoryId.equals(repositoryId));
    }

    private ObjId refObjId(String name) {
        return ObjId.objIdFromByteArray((byte[])("r:" + name).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void removeReference(@Nonnull String repositoryId, @Nonnull String name) {
        if (this.refCacheTtlNanos <= 0L) {
            return;
        }
        ObjId id = this.refObjId(name);
        CacheKeyValue key = CaffeineCacheBackend.cacheKey(repositoryId, id);
        this.cache.invalidate((Object)key);
    }

    @Override
    public void putReference(@Nonnull String repositoryId, @Nonnull Reference r) {
        this.putReferenceLocal(repositoryId, r);
    }

    @Override
    public void putReferenceLocal(@Nonnull String repositoryId, @Nonnull Reference r) {
        if (this.refCacheTtlNanos <= 0L) {
            return;
        }
        ObjId id = this.refObjId(r.name());
        CacheKeyValue key = CaffeineCacheBackend.cacheKeyValue(repositoryId, id, this.config.clockNanos().getAsLong() + this.refCacheTtlNanos);
        this.cache.put((Object)key, (Object)ProtoSerialization.serializeReference((Reference)r));
    }

    @Override
    public void putReferenceNegative(@Nonnull String repositoryId, @Nonnull String name) {
        if (this.refCacheNegativeTtlNanos <= 0L) {
            return;
        }
        ObjId id = this.refObjId(name);
        CacheKeyValue key = CaffeineCacheBackend.cacheKeyValue(repositoryId, id, this.config.clockNanos().getAsLong() + this.refCacheNegativeTtlNanos);
        this.cache.put((Object)key, (Object)NON_EXISTING_SENTINEL);
    }

    @Override
    public Reference getReference(@Nonnull String repositoryId, @Nonnull String name) {
        if (this.refCacheTtlNanos <= 0L) {
            return null;
        }
        ObjId id = this.refObjId(name);
        CacheKeyValue keyValue = CaffeineCacheBackend.cacheKey(repositoryId, id);
        byte[] bytes = (byte[])this.cache.getIfPresent((Object)keyValue);
        if (bytes == NON_EXISTING_SENTINEL) {
            return NON_EXISTENT_REFERENCE_SENTINEL;
        }
        return bytes != null ? ProtoSerialization.deserializeReference((byte[])bytes) : null;
    }

    static CacheKeyValue cacheKey(String repositoryId, ObjId id) {
        return new CacheKeyValue(repositoryId, id);
    }

    private static CacheKeyValue cacheKeyValue(String repositoryId, ObjId id, long expiresAtNanosEpoch) {
        return new CacheKeyValue(repositoryId, id, expiresAtNanosEpoch);
    }

    static final class CacheKeyValue {
        final String repositoryId;
        final ObjId id;
        final long expiresAtNanosEpoch;

        CacheKeyValue(String repositoryId, ObjId id) {
            this(repositoryId, id, 0L);
        }

        CacheKeyValue(String repositoryId, ObjId id, long expiresAtNanosEpoch) {
            this.repositoryId = repositoryId;
            this.id = id;
            this.expiresAtNanosEpoch = expiresAtNanosEpoch;
        }

        int heapSize() {
            int size = 32;
            size += 40 + this.repositoryId.length();
            return size += this.id.heapSize();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKeyValue)) {
                return false;
            }
            CacheKeyValue cacheKey = (CacheKeyValue)o;
            return this.repositoryId.equals(cacheKey.repositoryId) && this.id.equals(cacheKey.id);
        }

        public int hashCode() {
            return this.repositoryId.hashCode() * 31 + this.id.hashCode();
        }

        public String toString() {
            return "{" + this.repositoryId + ", " + String.valueOf(this.id) + "}";
        }
    }
}

