/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.cache;

import jakarta.annotation.Nonnull;
import org.projectnessie.versioned.storage.cache.CacheBackend;
import org.projectnessie.versioned.storage.cache.CachingPersistImpl;
import org.projectnessie.versioned.storage.cache.DistributedCacheInvalidation;
import org.projectnessie.versioned.storage.cache.DistributedCacheInvalidations;
import org.projectnessie.versioned.storage.cache.ObjCacheImpl;
import org.projectnessie.versioned.storage.common.objtypes.UpdateableObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.Reference;

final class DistributedInvalidationsCacheBackend
implements CacheBackend {
    private final CacheBackend local;
    private final DistributedCacheInvalidation sender;

    DistributedInvalidationsCacheBackend(DistributedCacheInvalidations distributedCacheInvalidations) {
        this.local = distributedCacheInvalidations.localBackend();
        this.sender = distributedCacheInvalidations.invalidationSender();
        distributedCacheInvalidations.invalidationListenerReceiver().applyDistributedCacheInvalidation(new DistributedCacheInvalidation(){

            @Override
            public void evictObj(String repositoryId, ObjId objId) {
                DistributedInvalidationsCacheBackend.this.local.remove(repositoryId, objId);
            }

            @Override
            public void evictReference(String repositoryId, String refName) {
                DistributedInvalidationsCacheBackend.this.local.removeReference(repositoryId, refName);
            }
        });
    }

    @Override
    public Persist wrap(@Nonnull Persist persist) {
        ObjCacheImpl cache = new ObjCacheImpl(this, persist.config());
        return new CachingPersistImpl(persist, cache);
    }

    @Override
    public Obj get(@Nonnull String repositoryId, @Nonnull ObjId id) {
        return this.local.get(repositoryId, id);
    }

    @Override
    public void put(@Nonnull String repositoryId, @Nonnull Obj obj) {
        this.local.putLocal(repositoryId, obj);
        if (obj instanceof UpdateableObj) {
            this.sender.evictObj(repositoryId, obj.id());
        }
    }

    @Override
    public void putLocal(@Nonnull String repositoryId, @Nonnull Obj obj) {
        this.local.putLocal(repositoryId, obj);
    }

    @Override
    public void putNegative(@Nonnull String repositoryId, @Nonnull ObjId id, @Nonnull ObjType type) {
        this.local.putNegative(repositoryId, id, type);
    }

    @Override
    public void remove(@Nonnull String repositoryId, @Nonnull ObjId id) {
        this.local.remove(repositoryId, id);
        this.sender.evictObj(repositoryId, id);
    }

    @Override
    public void clear(@Nonnull String repositoryId) {
        this.local.clear(repositoryId);
    }

    @Override
    public Reference getReference(@Nonnull String repositoryId, @Nonnull String name) {
        return this.local.getReference(repositoryId, name);
    }

    @Override
    public void removeReference(@Nonnull String repositoryId, @Nonnull String name) {
        this.local.removeReference(repositoryId, name);
        this.sender.evictReference(repositoryId, name);
    }

    @Override
    public void putReferenceLocal(@Nonnull String repositoryId, @Nonnull Reference r) {
        this.local.putReferenceLocal(repositoryId, r);
    }

    @Override
    public void putReference(@Nonnull String repositoryId, @Nonnull Reference r) {
        this.local.putReferenceLocal(repositoryId, r);
        this.sender.evictReference(repositoryId, r.name());
    }

    @Override
    public void putReferenceNegative(@Nonnull String repositoryId, @Nonnull String name) {
        this.local.putReferenceNegative(repositoryId, name);
    }
}

