/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.cache;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Set;
import org.projectnessie.versioned.storage.cache.CacheBackend;
import org.projectnessie.versioned.storage.cache.ObjCache;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RefConditionFailedException;
import org.projectnessie.versioned.storage.common.exceptions.RefNotFoundException;
import org.projectnessie.versioned.storage.common.objtypes.UpdateableObj;
import org.projectnessie.versioned.storage.common.persist.CloseableIterator;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.Reference;

class CachingPersistImpl
implements Persist {
    final Persist persist;
    final ObjCache cache;

    CachingPersistImpl(Persist persist, ObjCache cache) {
        this.persist = persist;
        this.cache = cache;
    }

    @Nonnull
    public Obj fetchObj(@Nonnull ObjId id) throws ObjNotFoundException {
        Obj o = this.cache.get(id);
        if (o != null) {
            if (o != CacheBackend.NOT_FOUND_OBJ_SENTINEL) {
                return o;
            }
            throw new ObjNotFoundException(id);
        }
        try {
            o = this.persist.fetchObj(id);
            this.cache.putLocal(o);
            return o;
        }
        catch (ObjNotFoundException e) {
            this.cache.remove(id);
            throw e;
        }
    }

    public Obj getImmediate(@Nonnull ObjId id) {
        Obj o = this.cache.get(id);
        if (o == CacheBackend.NOT_FOUND_OBJ_SENTINEL) {
            return null;
        }
        return o;
    }

    @Nonnull
    public <T extends Obj> T fetchTypedObj(@Nonnull ObjId id, ObjType type, @Nonnull Class<T> typeClass) throws ObjNotFoundException {
        Obj o = this.cache.get(id);
        if (o == CacheBackend.NOT_FOUND_OBJ_SENTINEL) {
            throw new ObjNotFoundException(id);
        }
        if (o != null) {
            if (type != null && !type.equals((Object)o.type())) {
                throw new ObjNotFoundException(id);
            }
        } else {
            try {
                o = this.persist.fetchTypedObj(id, type, typeClass);
                this.cache.putLocal(o);
            }
            catch (ObjNotFoundException e) {
                this.cache.putReferenceNegative(id, type);
                throw e;
            }
        }
        Obj r = o;
        return (T)r;
    }

    @Nonnull
    public ObjType fetchObjType(@Nonnull ObjId id) throws ObjNotFoundException {
        Obj o = this.cache.get(id);
        if (o == CacheBackend.NOT_FOUND_OBJ_SENTINEL) {
            throw new ObjNotFoundException(id);
        }
        if (o != null) {
            return o.type();
        }
        return this.persist.fetchObjType(id);
    }

    @Nonnull
    public Obj[] fetchObjs(@Nonnull ObjId[] ids) throws ObjNotFoundException {
        Obj[] r = new Obj[ids.length];
        ObjId[] backendIds = this.fetchObjsPre(ids, r, null, Obj.class);
        if (backendIds == null) {
            return r;
        }
        Obj[] backendResult = this.persist.fetchObjs(backendIds);
        return this.fetchObjsPost(backendIds, backendResult, r, null);
    }

    @Nonnull
    public <T extends Obj> T[] fetchTypedObjs(@Nonnull ObjId[] ids, ObjType type, @Nonnull Class<T> typeClass) throws ObjNotFoundException {
        Obj[] r = (Obj[])Array.newInstance(typeClass, ids.length);
        ObjId[] backendIds = this.fetchObjsPre(ids, r, type, typeClass);
        if (backendIds != null) {
            Obj[] backendResult = this.persist.fetchTypedObjsIfExist(backendIds, type, typeClass);
            r = this.fetchObjsPost(backendIds, backendResult, r, type);
        }
        ArrayList<ObjId> notFound = null;
        for (int i = 0; i < ids.length; ++i) {
            ObjId id = ids[i];
            if (r[i] != null || id == null) continue;
            if (notFound == null) {
                notFound = new ArrayList<ObjId>();
            }
            notFound.add(id);
        }
        if (notFound != null) {
            throw new ObjNotFoundException(notFound);
        }
        return r;
    }

    public <T extends Obj> T[] fetchTypedObjsIfExist(@Nonnull ObjId[] ids, ObjType type, @Nonnull Class<T> typeClass) {
        Obj[] r = (Obj[])Array.newInstance(typeClass, ids.length);
        ObjId[] backendIds = this.fetchObjsPre(ids, r, type, typeClass);
        if (backendIds == null) {
            return r;
        }
        Obj[] backendResult = this.persist.fetchTypedObjsIfExist(backendIds, type, typeClass);
        return this.fetchObjsPost(backendIds, backendResult, r, type);
    }

    private <T extends Obj> ObjId[] fetchObjsPre(ObjId[] ids, T[] r, ObjType type, @Nonnull Class<T> typeClass) {
        ObjId[] backendIds = null;
        for (int i = 0; i < ids.length; ++i) {
            ObjId id = ids[i];
            if (id == null) continue;
            Obj o = this.cache.get(id);
            if (o != null) {
                if (o == CacheBackend.NOT_FOUND_OBJ_SENTINEL || type != null && !type.equals((Object)o.type())) continue;
                Obj typed = o;
                r[i] = typed;
                continue;
            }
            if (backendIds == null) {
                backendIds = new ObjId[ids.length];
            }
            backendIds[i] = id;
        }
        return backendIds;
    }

    private <T extends Obj> T[] fetchObjsPost(ObjId[] backendIds, T[] backendResult, T[] r, ObjType type) {
        for (int i = 0; i < backendResult.length; ++i) {
            ObjId id = backendIds[i];
            if (id == null) continue;
            T o = backendResult[i];
            if (o != null) {
                r[i] = o;
                this.cache.putLocal((Obj)o);
                continue;
            }
            this.cache.putReferenceNegative(id, type);
        }
        return r;
    }

    @Nonnull
    public Obj[] fetchObjsIfExist(@Nonnull ObjId[] ids) {
        Obj[] r = new Obj[ids.length];
        ObjId[] backendIds = this.fetchObjsPre(ids, r, null, Obj.class);
        if (backendIds == null) {
            return r;
        }
        Obj[] backendResult = this.persist.fetchObjsIfExist(backendIds);
        return this.fetchObjsPost(backendIds, backendResult, r, null);
    }

    public boolean storeObj(@Nonnull Obj obj, boolean ignoreSoftSizeRestrictions) throws ObjTooLargeException {
        if (this.persist.storeObj(obj, ignoreSoftSizeRestrictions)) {
            this.cache.put(obj);
            return true;
        }
        return false;
    }

    @Nonnull
    public boolean[] storeObjs(@Nonnull Obj[] objs) throws ObjTooLargeException {
        boolean[] stored = this.persist.storeObjs(objs);
        for (int i = 0; i < stored.length; ++i) {
            if (!stored[i]) continue;
            this.cache.put(objs[i]);
        }
        return stored;
    }

    public void upsertObj(@Nonnull Obj obj) throws ObjTooLargeException {
        try {
            this.persist.upsertObj(obj);
        }
        finally {
            this.cache.remove(obj.id());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upsertObjs(@Nonnull Obj[] objs) throws ObjTooLargeException {
        try {
            this.persist.upsertObjs(objs);
        }
        finally {
            for (Obj obj : objs) {
                if (obj == null) continue;
                this.cache.remove(obj.id());
            }
        }
    }

    public void deleteObj(@Nonnull ObjId id) {
        try {
            this.persist.deleteObj(id);
        }
        finally {
            this.cache.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObjs(@Nonnull ObjId[] ids) {
        try {
            this.persist.deleteObjs(ids);
        }
        finally {
            for (ObjId id : ids) {
                if (id == null) continue;
                this.cache.remove(id);
            }
        }
    }

    public boolean deleteConditional(@Nonnull UpdateableObj obj) {
        try {
            boolean bl = this.persist.deleteConditional(obj);
            return bl;
        }
        finally {
            this.cache.remove(obj.id());
        }
    }

    public boolean updateConditional(@Nonnull UpdateableObj expected, @Nonnull UpdateableObj newValue) throws ObjTooLargeException {
        if (this.persist.updateConditional(expected, newValue)) {
            this.cache.put((Obj)newValue);
            return true;
        }
        this.cache.remove(expected.id());
        return false;
    }

    public void erase() {
        try {
            this.persist.erase();
        }
        finally {
            this.cache.clear();
        }
    }

    @Nonnull
    public CloseableIterator<Obj> scanAllObjects(@Nonnull Set<ObjType> returnedObjTypes) {
        return this.persist.scanAllObjects(returnedObjTypes);
    }

    public int hardObjectSizeLimit() {
        return this.persist.hardObjectSizeLimit();
    }

    public int effectiveIndexSegmentSizeLimit() {
        return this.persist.effectiveIndexSegmentSizeLimit();
    }

    public int effectiveIncrementalIndexSizeLimit() {
        return this.persist.effectiveIncrementalIndexSizeLimit();
    }

    @Nonnull
    public StoreConfig config() {
        return this.persist.config();
    }

    @Nonnull
    public String name() {
        return this.persist.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Reference addReference(@Nonnull Reference reference) throws RefAlreadyExistsException {
        Reference r = null;
        try {
            Reference reference2 = r = this.persist.addReference(reference);
            return reference2;
        }
        finally {
            if (r != null) {
                this.cache.putReference(r);
            } else {
                this.cache.removeReference(reference.name());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Reference markReferenceAsDeleted(@Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        Reference r = null;
        try {
            Reference reference2 = r = this.persist.markReferenceAsDeleted(reference);
            return reference2;
        }
        finally {
            if (r != null) {
                this.cache.putReference(r);
            } else {
                this.cache.removeReference(reference.name());
            }
        }
    }

    public void purgeReference(@Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        try {
            this.persist.purgeReference(reference);
        }
        finally {
            this.cache.removeReference(reference.name());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Reference updateReferencePointer(@Nonnull Reference reference, @Nonnull ObjId newPointer) throws RefNotFoundException, RefConditionFailedException {
        Reference r = null;
        try {
            Reference reference2 = r = this.persist.updateReferencePointer(reference, newPointer);
            return reference2;
        }
        finally {
            if (r != null) {
                this.cache.putReference(r);
            } else {
                this.cache.removeReference(reference.name());
            }
        }
    }

    public Reference fetchReference(@Nonnull String name) {
        return this.fetchReferenceInternal(name, false);
    }

    public Reference fetchReferenceForUpdate(@Nonnull String name) {
        return this.fetchReferenceInternal(name, true);
    }

    private Reference fetchReferenceInternal(@Nonnull String name, boolean bypassCache) {
        Reference r = null;
        if (!bypassCache && (r = this.cache.getReference(name)) == CacheBackend.NON_EXISTENT_REFERENCE_SENTINEL) {
            return null;
        }
        if (r == null) {
            r = this.persist.fetchReferenceForUpdate(name);
            if (r == null) {
                this.cache.putReferenceNegative(name);
            } else {
                this.cache.putReferenceLocal(r);
            }
        }
        return r;
    }

    @Nonnull
    public Reference[] fetchReferences(@Nonnull String[] names) {
        return this.fetchReferencesInternal(names, false);
    }

    @Nonnull
    public Reference[] fetchReferencesForUpdate(@Nonnull String[] names) {
        return this.fetchReferencesInternal(names, true);
    }

    private Reference[] fetchReferencesInternal(@Nonnull String[] names, boolean bypassCache) {
        Reference[] r = new Reference[names.length];
        String[] backend = null;
        if (!bypassCache) {
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                if (name == null) continue;
                Reference cr = this.cache.getReference(name);
                if (cr != null) {
                    if (cr == CacheBackend.NON_EXISTENT_REFERENCE_SENTINEL) continue;
                    r[i] = cr;
                    continue;
                }
                if (backend == null) {
                    backend = new String[names.length];
                }
                backend[i] = name;
            }
        } else {
            backend = names;
        }
        if (backend != null) {
            Reference[] br = this.persist.fetchReferencesForUpdate(backend);
            for (int i = 0; i < br.length; ++i) {
                String name = backend[i];
                if (name == null) continue;
                Reference ref = br[i];
                if (ref != null) {
                    r[i] = ref;
                    this.cache.putReferenceLocal(ref);
                    continue;
                }
                this.cache.putReferenceNegative(name);
            }
        }
        return r;
    }

    public boolean isCaching() {
        return true;
    }
}

