/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.serialize;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.dataformat.smile.databind.SmileMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.projectnessie.versioned.storage.common.json.ObjIdHelper;
import org.projectnessie.versioned.storage.common.objtypes.Compression;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.util.Compressions;
import org.projectnessie.versioned.storage.serialize.StorageView;

public final class SmileSerialization {
    private static final ObjectMapper SMILE_MAPPER = new SmileMapper().findAndRegisterModules();
    private static final ObjectWriter SMILE_WRITER = SMILE_MAPPER.writerWithView(StorageView.class);

    private SmileSerialization() {
    }

    public static Obj deserializeObj(ObjId id, String versionToken, byte[] data, Class<? extends Obj> targetClass, String compression) {
        try {
            ObjectReader reader = ObjIdHelper.readerWithObjIdAndVersionToken((ObjectMapper)SMILE_MAPPER, targetClass, (ObjId)id, (String)versionToken);
            data = Compressions.uncompress((Compression)Compression.fromValue((String)compression), (byte[])data);
            return (Obj)reader.readValue(data, targetClass);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Obj deserializeObj(ObjId id, String versionToken, ByteBuffer data, Class<? extends Obj> targetClass, String compression) {
        byte[] bytes = new byte[data.remaining()];
        data.get(bytes);
        return SmileSerialization.deserializeObj(id, versionToken, bytes, targetClass, compression);
    }

    public static byte[] serializeObj(Obj obj, Consumer<Compression> compression) {
        try {
            return Compressions.compressDefault((byte[])SMILE_WRITER.writeValueAsBytes((Object)obj), compression);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }
}

