/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.objtypes.JsonObj;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JsonObj.JsonBean", generator="Immutables")
@Immutable
public final class ImmutableJsonBean
implements JsonObj.JsonBean {
    private final String type;
    @Nullable
    private final Object object;

    private ImmutableJsonBean(String type, @Nullable Object object) {
        this.type = type;
        this.object = object;
    }

    @Override
    @JsonProperty(value="t")
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="o")
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="t")
    @Nullable
    public Object object() {
        return this.object;
    }

    public final ImmutableJsonBean withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableJsonBean(newValue, this.object);
    }

    public final ImmutableJsonBean withObject(@Nullable Object value) {
        if (this.object == value) {
            return this;
        }
        return new ImmutableJsonBean(this.type, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJsonBean && this.equalTo(0, (ImmutableJsonBean)another);
    }

    private boolean equalTo(int synthetic, ImmutableJsonBean another) {
        return this.type.equals(another.type) && Objects.equals(this.object, another.object);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.object);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JsonBean").omitNullValues().add("type", (Object)this.type).add("object", this.object).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJsonBean fromJson(Json json) {
        Builder builder = ImmutableJsonBean.builder();
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.object != null) {
            builder.object(json.object);
        }
        return builder.build();
    }

    public static ImmutableJsonBean copyOf(JsonObj.JsonBean instance) {
        if (instance instanceof ImmutableJsonBean) {
            return (ImmutableJsonBean)instance;
        }
        return ImmutableJsonBean.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="JsonObj.JsonBean", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @javax.annotation.Nullable
        private String type;
        @javax.annotation.Nullable
        private Object object;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JsonObj.JsonBean instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            Object objectValue = instance.object();
            if (objectValue != null) {
                this.object(objectValue);
            }
            return this;
        }

        @JsonProperty(value="t")
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="o")
        @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="t")
        @CanIgnoreReturnValue
        public final Builder object(@Nullable Object object) {
            this.object = object;
            return this;
        }

        public ImmutableJsonBean build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJsonBean(this.type, this.object);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build JsonBean, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="JsonObj.JsonBean", generator="Immutables")
    static final class Json
    implements JsonObj.JsonBean {
        @javax.annotation.Nullable
        String type;
        @javax.annotation.Nullable
        Object object;

        Json() {
        }

        @JsonProperty(value="t")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="o")
        @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="t")
        public void setObject(@Nullable Object object) {
            this.object = object;
        }

        @Override
        public String type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object object() {
            throw new UnsupportedOperationException();
        }
    }
}

