/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.ContentValueObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ContentValueObj", generator="Immutables")
@Immutable
public final class ImmutableContentValueObj
implements ContentValueObj {
    private final ObjId id;
    private final long referenced;
    private final String contentId;
    private final int payload;
    private final ByteString data;

    private ImmutableContentValueObj(ObjId id, long referenced, String contentId, int payload, ByteString data) {
        this.id = Objects.requireNonNull(id, "id");
        this.referenced = referenced;
        this.contentId = Objects.requireNonNull(contentId, "contentId");
        this.payload = payload;
        this.data = Objects.requireNonNull(data, "data");
    }

    private ImmutableContentValueObj(ImmutableContentValueObj original, ObjId id, long referenced, String contentId, int payload, ByteString data) {
        this.id = id;
        this.referenced = referenced;
        this.contentId = contentId;
        this.payload = payload;
        this.data = data;
    }

    @Override
    public ObjId id() {
        return this.id;
    }

    @Override
    public long referenced() {
        return this.referenced;
    }

    @Override
    public String contentId() {
        return this.contentId;
    }

    @Override
    public int payload() {
        return this.payload;
    }

    @Override
    public ByteString data() {
        return this.data;
    }

    public final ImmutableContentValueObj withId(ObjId value) {
        if (this.id == value) {
            return this;
        }
        ObjId newValue = Objects.requireNonNull(value, "id");
        return new ImmutableContentValueObj(this, newValue, this.referenced, this.contentId, this.payload, this.data);
    }

    @Override
    public final ImmutableContentValueObj withReferenced(long value) {
        if (this.referenced == value) {
            return this;
        }
        return new ImmutableContentValueObj(this, this.id, value, this.contentId, this.payload, this.data);
    }

    public final ImmutableContentValueObj withContentId(String value) {
        String newValue = Objects.requireNonNull(value, "contentId");
        if (this.contentId.equals(newValue)) {
            return this;
        }
        return new ImmutableContentValueObj(this, this.id, this.referenced, newValue, this.payload, this.data);
    }

    public final ImmutableContentValueObj withPayload(int value) {
        if (this.payload == value) {
            return this;
        }
        return new ImmutableContentValueObj(this, this.id, this.referenced, this.contentId, value, this.data);
    }

    public final ImmutableContentValueObj withData(ByteString value) {
        if (this.data == value) {
            return this;
        }
        ByteString newValue = Objects.requireNonNull(value, "data");
        return new ImmutableContentValueObj(this, this.id, this.referenced, this.contentId, this.payload, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContentValueObj && this.equalTo(0, (ImmutableContentValueObj)another);
    }

    private boolean equalTo(int synthetic, ImmutableContentValueObj another) {
        return this.id.equals(another.id) && this.contentId.equals(another.contentId) && this.payload == another.payload && this.data.equals((Object)another.data);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.contentId.hashCode();
        h += (h << 5) + this.payload;
        h += (h << 5) + this.data.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ContentValueObj").omitNullValues().add("id", (Object)this.id).add("contentId", (Object)this.contentId).add("payload", this.payload).add("data", (Object)this.data).toString();
    }

    public static ImmutableContentValueObj of(ObjId id, long referenced, String contentId, int payload, ByteString data) {
        return new ImmutableContentValueObj(id, referenced, contentId, payload, data);
    }

    public static ImmutableContentValueObj copyOf(ContentValueObj instance) {
        if (instance instanceof ImmutableContentValueObj) {
            return (ImmutableContentValueObj)instance;
        }
        return ImmutableContentValueObj.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ContentValueObj", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_REFERENCED = 2L;
        private static final long INIT_BIT_CONTENT_ID = 4L;
        private static final long INIT_BIT_PAYLOAD = 8L;
        private static final long INIT_BIT_DATA = 16L;
        private long initBits = 31L;
        @Nullable
        private ObjId id;
        private long referenced;
        @Nullable
        private String contentId;
        private int payload;
        @Nullable
        private ByteString data;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ContentValueObj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Obj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Obj instance;
            long bits = 0L;
            if (object instanceof ContentValueObj) {
                instance = (ContentValueObj)object;
                this.contentId(instance.contentId());
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
                this.data(instance.data());
                if ((bits & 1L) == 0L) {
                    this.referenced(instance.referenced());
                    bits |= 1L;
                }
                this.payload(instance.payload());
            }
            if (object instanceof Obj) {
                instance = (Obj)object;
                if ((bits & 1L) == 0L) {
                    this.referenced(instance.referenced());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder id(ObjId id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder referenced(long referenced) {
            this.referenced = referenced;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentId(String contentId) {
            this.contentId = Objects.requireNonNull(contentId, "contentId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder payload(int payload) {
            this.payload = payload;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder data(ByteString data) {
            this.data = Objects.requireNonNull(data, "data");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableContentValueObj build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContentValueObj(null, this.id, this.referenced, this.contentId, this.payload, this.data);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("referenced");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("contentId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("payload");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("data");
            }
            return "Cannot build ContentValueObj, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

