/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.persist;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.persist.StoredObjResult;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StoredObjResult", generator="Immutables")
@Immutable
public final class ImmutableStoredObjResult<T>
implements StoredObjResult<T> {
    @Nullable
    private final T obj;
    private final boolean stored;

    private ImmutableStoredObjResult(Optional<? extends T> obj, boolean stored) {
        this.obj = obj.orElse(null);
        this.stored = stored;
    }

    private ImmutableStoredObjResult(ImmutableStoredObjResult<T> original, @Nullable T obj, boolean stored) {
        this.obj = obj;
        this.stored = stored;
    }

    @Override
    public Optional<T> obj() {
        return Optional.ofNullable(this.obj);
    }

    @Override
    public boolean stored() {
        return this.stored;
    }

    public final ImmutableStoredObjResult<T> withObj(T value) {
        T newValue = Objects.requireNonNull(value, "obj");
        if (this.obj == newValue) {
            return this;
        }
        return new ImmutableStoredObjResult<T>(this, newValue, this.stored);
    }

    public final ImmutableStoredObjResult<T> withObj(Optional<? extends T> optional) {
        T value = optional.orElse(null);
        if (this.obj == value) {
            return this;
        }
        return new ImmutableStoredObjResult<Object>(this, value, this.stored);
    }

    public final ImmutableStoredObjResult<T> withStored(boolean value) {
        if (this.stored == value) {
            return this;
        }
        return new ImmutableStoredObjResult<T>(this, this.obj, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStoredObjResult && this.equalTo(0, (ImmutableStoredObjResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableStoredObjResult<?> another) {
        return Objects.equals(this.obj, another.obj) && this.stored == another.stored;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.obj);
        h += (h << 5) + Booleans.hashCode((boolean)this.stored);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StoredObjResult").omitNullValues().add("obj", this.obj).add("stored", this.stored).toString();
    }

    public static <T> ImmutableStoredObjResult<T> of(Optional<? extends T> obj, boolean stored) {
        return new ImmutableStoredObjResult<T>(obj, stored);
    }

    public static <T> ImmutableStoredObjResult<T> copyOf(StoredObjResult<T> instance) {
        if (instance instanceof ImmutableStoredObjResult) {
            return (ImmutableStoredObjResult)instance;
        }
        return ImmutableStoredObjResult.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="StoredObjResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T> {
        private static final long INIT_BIT_STORED = 1L;
        private long initBits = 1L;
        @Nullable
        private T obj;
        private boolean stored;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(StoredObjResult<T> instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<T> objOptional = instance.obj();
            if (objOptional.isPresent()) {
                this.obj(objOptional);
            }
            this.stored(instance.stored());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> obj(T obj) {
            this.obj = Objects.requireNonNull(obj, "obj");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> obj(Optional<? extends T> obj) {
            this.obj = obj.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> stored(boolean stored) {
            this.stored = stored;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableStoredObjResult<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStoredObjResult<T>(null, this.obj, this.stored);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("stored");
            }
            return "Cannot build StoredObjResult, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

