/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.persist;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import org.projectnessie.versioned.storage.common.persist.BackendFactory;

public final class PersistLoader {
    private PersistLoader() {
    }

    public static <C> BackendFactory<C> findFactoryByName(String name) {
        return PersistLoader.findFactory(f -> f.name().equals(name));
    }

    public static <C> BackendFactory<C> findAny() {
        return PersistLoader.findFactory(x -> true);
    }

    public static <C> BackendFactory<C> findFactory(Predicate<BackendFactory<?>> filter) {
        ServiceLoader<BackendFactory<C>> loader = PersistLoader.loader();
        ArrayList<BackendFactory<C>> candidates = new ArrayList<BackendFactory<C>>();
        boolean any = false;
        for (BackendFactory<C> backendFactory : loader) {
            any = true;
            if (!filter.test(backendFactory)) continue;
            candidates.add(backendFactory);
        }
        Preconditions.checkState((boolean)any, (Object)"No BackendFactory on class path");
        Preconditions.checkArgument((!candidates.isEmpty() ? 1 : 0) != 0, (Object)"No BackendFactory matched the given filter");
        Preconditions.checkState((candidates.size() == 1 ? 1 : 0) != 0, (Object)"More than one BackendFactory matched the given filter");
        return PersistLoader.cast((BackendFactory)candidates.get(0));
    }

    private static <C> ServiceLoader<BackendFactory<C>> loader() {
        ServiceLoader<BackendFactory<C>> f;
        ServiceLoader<BackendFactory<C>> r = f = ServiceLoader.load(BackendFactory.class);
        return r;
    }

    private static <C> BackendFactory<C> cast(BackendFactory<?> backendFactory) {
        BackendFactory<?> r = backendFactory;
        return r;
    }
}

