/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.CommitType;
import org.projectnessie.versioned.storage.common.objtypes.IndexStripe;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@Generated(from="CommitObj", generator="Immutables")
public final class ImmutableCommitObj
implements CommitObj {
    private final ObjId id;
    private final long referenced;
    private final long created;
    private final long seq;
    private final ImmutableList<ObjId> tail;
    private final ImmutableList<ObjId> secondaryParents;
    private final CommitHeaders headers;
    private final String message;
    private final boolean incompleteIndex;
    @Nullable
    private final ObjId referenceIndex;
    private final ImmutableList<IndexStripe> referenceIndexStripes;
    private final ByteString incrementalIndex;
    private final CommitType commitType;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCommitObj(Builder builder) {
        this.id = builder.id;
        this.created = builder.created;
        this.seq = builder.seq;
        this.tail = builder.tail.build();
        this.secondaryParents = builder.secondaryParents.build();
        this.headers = builder.headers;
        this.message = builder.message;
        this.referenceIndex = builder.referenceIndex;
        this.referenceIndexStripes = builder.referenceIndexStripes.build();
        this.incrementalIndex = builder.incrementalIndex;
        if (builder.referencedIsSet()) {
            this.initShim.referenced(builder.referenced);
        }
        if (builder.incompleteIndexIsSet()) {
            this.initShim.incompleteIndex(builder.incompleteIndex);
        }
        if (builder.commitType != null) {
            this.initShim.commitType(builder.commitType);
        }
        this.referenced = this.initShim.referenced();
        this.incompleteIndex = this.initShim.incompleteIndex();
        this.commitType = this.initShim.commitType();
        this.initShim = null;
    }

    private ImmutableCommitObj(ObjId id, long referenced, long created, long seq, ImmutableList<ObjId> tail, ImmutableList<ObjId> secondaryParents, CommitHeaders headers, String message, boolean incompleteIndex, @Nullable ObjId referenceIndex, ImmutableList<IndexStripe> referenceIndexStripes, ByteString incrementalIndex, CommitType commitType) {
        this.id = id;
        this.referenced = referenced;
        this.created = created;
        this.seq = seq;
        this.tail = tail;
        this.secondaryParents = secondaryParents;
        this.headers = headers;
        this.message = message;
        this.incompleteIndex = incompleteIndex;
        this.referenceIndex = referenceIndex;
        this.referenceIndexStripes = referenceIndexStripes;
        this.incrementalIndex = incrementalIndex;
        this.commitType = commitType;
        this.initShim = null;
    }

    private long referencedInitialize() {
        return CommitObj.super.referenced();
    }

    private boolean incompleteIndexInitialize() {
        return CommitObj.super.incompleteIndex();
    }

    private CommitType commitTypeInitialize() {
        return CommitObj.super.commitType();
    }

    @Override
    public ObjId id() {
        return this.id;
    }

    @Override
    public long referenced() {
        InitShim shim = this.initShim;
        return shim != null ? shim.referenced() : this.referenced;
    }

    @Override
    public long created() {
        return this.created;
    }

    @Override
    public long seq() {
        return this.seq;
    }

    public ImmutableList<ObjId> tail() {
        return this.tail;
    }

    public ImmutableList<ObjId> secondaryParents() {
        return this.secondaryParents;
    }

    @Override
    public CommitHeaders headers() {
        return this.headers;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public boolean incompleteIndex() {
        InitShim shim = this.initShim;
        return shim != null ? shim.incompleteIndex() : this.incompleteIndex;
    }

    @Override
    @Nullable
    public ObjId referenceIndex() {
        return this.referenceIndex;
    }

    public ImmutableList<IndexStripe> referenceIndexStripes() {
        return this.referenceIndexStripes;
    }

    @Override
    public ByteString incrementalIndex() {
        return this.incrementalIndex;
    }

    @Override
    public CommitType commitType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.commitType() : this.commitType;
    }

    public final ImmutableCommitObj withId(ObjId value) {
        if (this.id == value) {
            return this;
        }
        ObjId newValue = Objects.requireNonNull(value, "id");
        return new ImmutableCommitObj(newValue, this.referenced, this.created, this.seq, this.tail, this.secondaryParents, this.headers, this.message, this.incompleteIndex, this.referenceIndex, this.referenceIndexStripes, this.incrementalIndex, this.commitType);
    }

    @Override
    public final ImmutableCommitObj withReferenced(long value) {
        if (this.referenced == value) {
            return this;
        }
        return new ImmutableCommitObj(this.id, value, this.created, this.seq, this.tail, this.secondaryParents, this.headers, this.message, this.incompleteIndex, this.referenceIndex, this.referenceIndexStripes, this.incrementalIndex, this.commitType);
    }

    public final ImmutableCommitObj withCreated(long value) {
        if (this.created == value) {
            return this;
        }
        return new ImmutableCommitObj(this.id, this.referenced, value, this.seq, this.tail, this.secondaryParents, this.headers, this.message, this.incompleteIndex, this.referenceIndex, this.referenceIndexStripes, this.incrementalIndex, this.commitType);
    }

    public final ImmutableCommitObj withSeq(long value) {
        if (this.seq == value) {
            return this;
        }
        return new ImmutableCommitObj(this.id, this.referenced, this.created, value, this.tail, this.secondaryParents, this.headers, this.message, this.incompleteIndex, this.referenceIndex, this.referenceIndexStripes, this.incrementalIndex, this.commitType);
    }

    public final ImmutableCommitObj withTail(ObjId ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitObj(this.id, this.referenced, this.created, this.seq, (ImmutableList<ObjId>)newValue, this.secondaryParents, this.headers, this.message, this.incompleteIndex, this.referenceIndex, this.referenceIndexStripes, this.incrementalIndex, this.commitType);
    }

    public final ImmutableCommitObj withTail(Iterable<? extends ObjId> elements) {
        if (this.tail == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitObj(this.id, this.referenced, this.created, this.seq, (ImmutableList<ObjId>)newValue, this.secondaryParents, this.headers, this.message, this.incompleteIndex, this.referenceIndex, this.referenceIndexStripes, this.incrementalIndex, this.commitType);
    }

    public final ImmutableCommitObj withSecondaryParents(ObjId ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitObj(this.id, this.referenced, this.created, this.seq, this.tail, (ImmutableList<ObjId>)newValue, this.headers, this.message, this.incompleteIndex, this.referenceIndex, this.referenceIndexStripes, this.incrementalIndex, this.commitType);
    }

    public final ImmutableCommitObj withSecondaryParents(Iterable<? extends ObjId> elements) {
        if (this.secondaryParents == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitObj(this.id, this.referenced, this.created, this.seq, this.tail, (ImmutableList<ObjId>)newValue, this.headers, this.message, this.incompleteIndex, this.referenceIndex, this.referenceIndexStripes, this.incrementalIndex, this.commitType);
    }

    public final ImmutableCommitObj withHeaders(CommitHeaders value) {
        if (this.headers == value) {
            return this;
        }
        CommitHeaders newValue = Objects.requireNonNull(value, "headers");
        return new ImmutableCommitObj(this.id, this.referenced, this.created, this.seq, this.tail, this.secondaryParents, newValue, this.message, this.incompleteIndex, this.referenceIndex, this.referenceIndexStripes, this.incrementalIndex, this.commitType);
    }

    public final ImmutableCommitObj withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableCommitObj(this.id, this.referenced, this.created, this.seq, this.tail, this.secondaryParents, this.headers, newValue, this.incompleteIndex, this.referenceIndex, this.referenceIndexStripes, this.incrementalIndex, this.commitType);
    }

    public final ImmutableCommitObj withIncompleteIndex(boolean value) {
        if (this.incompleteIndex == value) {
            return this;
        }
        return new ImmutableCommitObj(this.id, this.referenced, this.created, this.seq, this.tail, this.secondaryParents, this.headers, this.message, value, this.referenceIndex, this.referenceIndexStripes, this.incrementalIndex, this.commitType);
    }

    public final ImmutableCommitObj withReferenceIndex(@Nullable ObjId value) {
        if (this.referenceIndex == value) {
            return this;
        }
        return new ImmutableCommitObj(this.id, this.referenced, this.created, this.seq, this.tail, this.secondaryParents, this.headers, this.message, this.incompleteIndex, value, this.referenceIndexStripes, this.incrementalIndex, this.commitType);
    }

    public final ImmutableCommitObj withReferenceIndexStripes(IndexStripe ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitObj(this.id, this.referenced, this.created, this.seq, this.tail, this.secondaryParents, this.headers, this.message, this.incompleteIndex, this.referenceIndex, (ImmutableList<IndexStripe>)newValue, this.incrementalIndex, this.commitType);
    }

    public final ImmutableCommitObj withReferenceIndexStripes(Iterable<? extends IndexStripe> elements) {
        if (this.referenceIndexStripes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitObj(this.id, this.referenced, this.created, this.seq, this.tail, this.secondaryParents, this.headers, this.message, this.incompleteIndex, this.referenceIndex, (ImmutableList<IndexStripe>)newValue, this.incrementalIndex, this.commitType);
    }

    public final ImmutableCommitObj withIncrementalIndex(ByteString value) {
        if (this.incrementalIndex == value) {
            return this;
        }
        ByteString newValue = Objects.requireNonNull(value, "incrementalIndex");
        return new ImmutableCommitObj(this.id, this.referenced, this.created, this.seq, this.tail, this.secondaryParents, this.headers, this.message, this.incompleteIndex, this.referenceIndex, this.referenceIndexStripes, newValue, this.commitType);
    }

    public final ImmutableCommitObj withCommitType(CommitType value) {
        CommitType newValue = Objects.requireNonNull(value, "commitType");
        if (this.commitType == newValue) {
            return this;
        }
        return new ImmutableCommitObj(this.id, this.referenced, this.created, this.seq, this.tail, this.secondaryParents, this.headers, this.message, this.incompleteIndex, this.referenceIndex, this.referenceIndexStripes, this.incrementalIndex, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitObj && this.equalTo(0, (ImmutableCommitObj)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommitObj another) {
        return this.id.equals(another.id) && this.seq == another.seq && this.tail.equals(another.tail) && this.secondaryParents.equals(another.secondaryParents) && this.headers.equals(another.headers) && this.message.equals(another.message) && this.incompleteIndex == another.incompleteIndex && Objects.equals(this.referenceIndex, another.referenceIndex) && this.referenceIndexStripes.equals(another.referenceIndexStripes) && this.incrementalIndex.equals((Object)another.incrementalIndex) && this.commitType.equals((Object)another.commitType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.seq);
        h += (h << 5) + this.tail.hashCode();
        h += (h << 5) + this.secondaryParents.hashCode();
        h += (h << 5) + this.headers.hashCode();
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.incompleteIndex);
        h += (h << 5) + Objects.hashCode(this.referenceIndex);
        h += (h << 5) + this.referenceIndexStripes.hashCode();
        h += (h << 5) + this.incrementalIndex.hashCode();
        h += (h << 5) + this.commitType.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommitObj").omitNullValues().add("id", (Object)this.id).add("seq", this.seq).add("tail", this.tail).add("secondaryParents", this.secondaryParents).add("headers", (Object)this.headers).add("message", (Object)this.message).add("incompleteIndex", this.incompleteIndex).add("referenceIndex", (Object)this.referenceIndex).add("referenceIndexStripes", this.referenceIndexStripes).add("incrementalIndex", (Object)this.incrementalIndex).add("commitType", (Object)this.commitType).toString();
    }

    public static ImmutableCommitObj copyOf(CommitObj instance) {
        if (instance instanceof ImmutableCommitObj) {
            return (ImmutableCommitObj)instance;
        }
        return ImmutableCommitObj.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitObj", generator="Immutables")
    private final class InitShim {
        private byte referencedBuildStage = 0;
        private long referenced;
        private byte incompleteIndexBuildStage = 0;
        private boolean incompleteIndex;
        private byte commitTypeBuildStage = 0;
        private CommitType commitType;

        private InitShim() {
        }

        long referenced() {
            if (this.referencedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.referencedBuildStage == 0) {
                this.referencedBuildStage = (byte)-1;
                this.referenced = ImmutableCommitObj.this.referencedInitialize();
                this.referencedBuildStage = 1;
            }
            return this.referenced;
        }

        void referenced(long referenced) {
            this.referenced = referenced;
            this.referencedBuildStage = 1;
        }

        boolean incompleteIndex() {
            if (this.incompleteIndexBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.incompleteIndexBuildStage == 0) {
                this.incompleteIndexBuildStage = (byte)-1;
                this.incompleteIndex = ImmutableCommitObj.this.incompleteIndexInitialize();
                this.incompleteIndexBuildStage = 1;
            }
            return this.incompleteIndex;
        }

        void incompleteIndex(boolean incompleteIndex) {
            this.incompleteIndex = incompleteIndex;
            this.incompleteIndexBuildStage = 1;
        }

        CommitType commitType() {
            if (this.commitTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.commitTypeBuildStage == 0) {
                this.commitTypeBuildStage = (byte)-1;
                this.commitType = Objects.requireNonNull(ImmutableCommitObj.this.commitTypeInitialize(), "commitType");
                this.commitTypeBuildStage = 1;
            }
            return this.commitType;
        }

        void commitType(CommitType commitType) {
            this.commitType = commitType;
            this.commitTypeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.referencedBuildStage == -1) {
                attributes.add("referenced");
            }
            if (this.incompleteIndexBuildStage == -1) {
                attributes.add("incompleteIndex");
            }
            if (this.commitTypeBuildStage == -1) {
                attributes.add("commitType");
            }
            return "Cannot build CommitObj, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="CommitObj", generator="Immutables")
    public static final class Builder
    implements CommitObj.Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_CREATED = 2L;
        private static final long INIT_BIT_SEQ = 4L;
        private static final long INIT_BIT_HEADERS = 8L;
        private static final long INIT_BIT_MESSAGE = 16L;
        private static final long INIT_BIT_INCREMENTAL_INDEX = 32L;
        private static final long OPT_BIT_REFERENCED = 1L;
        private static final long OPT_BIT_INCOMPLETE_INDEX = 2L;
        private long initBits = 63L;
        private long optBits;
        private ObjId id;
        private long referenced;
        private long created;
        private long seq;
        private ImmutableList.Builder<ObjId> tail = ImmutableList.builder();
        private ImmutableList.Builder<ObjId> secondaryParents = ImmutableList.builder();
        private CommitHeaders headers;
        private String message;
        private boolean incompleteIndex;
        private ObjId referenceIndex;
        private ImmutableList.Builder<IndexStripe> referenceIndexStripes = ImmutableList.builder();
        private ByteString incrementalIndex;
        private CommitType commitType;

        private Builder() {
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder from(CommitObj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Obj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Obj instance;
            long bits = 0L;
            if (object instanceof CommitObj) {
                instance = (CommitObj)object;
                ObjId referenceIndexValue = instance.referenceIndex();
                if (referenceIndexValue != null) {
                    this.referenceIndex(referenceIndexValue);
                }
                this.commitType(instance.commitType());
                this.headers(instance.headers());
                this.incrementalIndex(instance.incrementalIndex());
                this.created(instance.created());
                this.addAllTail(instance.tail());
                this.message(instance.message());
                this.incompleteIndex(instance.incompleteIndex());
                this.addAllReferenceIndexStripes(instance.referenceIndexStripes());
                this.addAllSecondaryParents(instance.secondaryParents());
                if ((bits & 1L) == 0L) {
                    this.referenced(instance.referenced());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
                this.seq(instance.seq());
            }
            if (object instanceof Obj) {
                instance = (Obj)object;
                if ((bits & 1L) == 0L) {
                    this.referenced(instance.referenced());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder id(ObjId id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder referenced(long referenced) {
            this.referenced = referenced;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder created(long created) {
            this.created = created;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder seq(long seq) {
            this.seq = seq;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addTail(ObjId element) {
            this.tail.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTail(ObjId ... elements) {
            this.tail.add((Object[])elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder tail(Iterable<? extends ObjId> elements) {
            this.tail = ImmutableList.builder();
            return this.addAllTail(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTail(Iterable<? extends ObjId> elements) {
            this.tail.addAll(elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addSecondaryParents(ObjId element) {
            this.secondaryParents.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSecondaryParents(ObjId ... elements) {
            this.secondaryParents.add((Object[])elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder secondaryParents(Iterable<? extends ObjId> elements) {
            this.secondaryParents = ImmutableList.builder();
            return this.addAllSecondaryParents((Iterable)elements);
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addAllSecondaryParents(Iterable<? extends ObjId> elements) {
            this.secondaryParents.addAll(elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder headers(CommitHeaders headers) {
            this.headers = Objects.requireNonNull(headers, "headers");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder incompleteIndex(boolean incompleteIndex) {
            this.incompleteIndex = incompleteIndex;
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder referenceIndex(@Nullable ObjId referenceIndex) {
            this.referenceIndex = referenceIndex;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addReferenceIndexStripes(IndexStripe element) {
            this.referenceIndexStripes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addReferenceIndexStripes(IndexStripe ... elements) {
            this.referenceIndexStripes.add((Object[])elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder referenceIndexStripes(Iterable<? extends IndexStripe> elements) {
            this.referenceIndexStripes = ImmutableList.builder();
            return this.addAllReferenceIndexStripes((Iterable)elements);
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addAllReferenceIndexStripes(Iterable<? extends IndexStripe> elements) {
            this.referenceIndexStripes.addAll(elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder incrementalIndex(ByteString incrementalIndex) {
            this.incrementalIndex = Objects.requireNonNull(incrementalIndex, "incrementalIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder commitType(CommitType commitType) {
            this.commitType = Objects.requireNonNull(commitType, "commitType");
            return this;
        }

        @Override
        public ImmutableCommitObj build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitObj(this);
        }

        private boolean referencedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean incompleteIndexIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("created");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("seq");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("headers");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("message");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("incrementalIndex");
            }
            return "Cannot build CommitObj, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

