/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.objtypes.CommitOp;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@Generated(from="CommitOp", generator="Immutables")
public final class ImmutableCommitOp
implements CommitOp {
    private final CommitOp.Action action;
    private final int payload;
    @Nullable
    private final ObjId value;
    @Nullable
    private final UUID contentId;

    private ImmutableCommitOp(CommitOp.Action action, int payload, @Nullable ObjId value, @Nullable UUID contentId) {
        this.action = Objects.requireNonNull(action, "action");
        this.payload = payload;
        this.value = value;
        this.contentId = contentId;
    }

    private ImmutableCommitOp(ImmutableCommitOp original, CommitOp.Action action, int payload, @Nullable ObjId value, @Nullable UUID contentId) {
        this.action = action;
        this.payload = payload;
        this.value = value;
        this.contentId = contentId;
    }

    @Override
    public CommitOp.Action action() {
        return this.action;
    }

    @Override
    public int payload() {
        return this.payload;
    }

    @Override
    @Nullable
    public ObjId value() {
        return this.value;
    }

    @Override
    @Nullable
    public UUID contentId() {
        return this.contentId;
    }

    public final ImmutableCommitOp withAction(CommitOp.Action value) {
        CommitOp.Action newValue = Objects.requireNonNull(value, "action");
        if (this.action == newValue) {
            return this;
        }
        return new ImmutableCommitOp(this, newValue, this.payload, this.value, this.contentId);
    }

    public final ImmutableCommitOp withPayload(int value) {
        if (this.payload == value) {
            return this;
        }
        return new ImmutableCommitOp(this, this.action, value, this.value, this.contentId);
    }

    public final ImmutableCommitOp withValue(@Nullable ObjId value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableCommitOp(this, this.action, this.payload, value, this.contentId);
    }

    public final ImmutableCommitOp withContentId(@Nullable UUID value) {
        if (this.contentId == value) {
            return this;
        }
        return new ImmutableCommitOp(this, this.action, this.payload, this.value, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitOp && this.equalTo(0, (ImmutableCommitOp)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommitOp another) {
        return this.action.equals((Object)another.action) && this.payload == another.payload && Objects.equals(this.value, another.value) && Objects.equals(this.contentId, another.contentId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.action.hashCode();
        h += (h << 5) + this.payload;
        h += (h << 5) + Objects.hashCode(this.value);
        h += (h << 5) + Objects.hashCode(this.contentId);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommitOp").omitNullValues().add("action", (Object)this.action).add("payload", this.payload).add("value", (Object)this.value).add("contentId", (Object)this.contentId).toString();
    }

    public static ImmutableCommitOp of(CommitOp.Action action, int payload, @Nullable ObjId value, @Nullable UUID contentId) {
        return new ImmutableCommitOp(action, payload, value, contentId);
    }

    public static ImmutableCommitOp copyOf(CommitOp instance) {
        if (instance instanceof ImmutableCommitOp) {
            return (ImmutableCommitOp)instance;
        }
        return ImmutableCommitOp.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitOp", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ACTION = 1L;
        private static final long INIT_BIT_PAYLOAD = 2L;
        private long initBits = 3L;
        private CommitOp.Action action;
        private int payload;
        private ObjId value;
        private UUID contentId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitOp instance) {
            UUID contentIdValue;
            Objects.requireNonNull(instance, "instance");
            this.action(instance.action());
            this.payload(instance.payload());
            ObjId valueValue = instance.value();
            if (valueValue != null) {
                this.value(valueValue);
            }
            if ((contentIdValue = instance.contentId()) != null) {
                this.contentId(contentIdValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder action(CommitOp.Action action) {
            this.action = Objects.requireNonNull(action, "action");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder payload(int payload) {
            this.payload = payload;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(@Nullable ObjId value) {
            this.value = value;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentId(@Nullable UUID contentId) {
            this.contentId = contentId;
            return this;
        }

        public ImmutableCommitOp build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitOp(null, this.action, this.payload, this.value, this.contentId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("action");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("payload");
            }
            return "Cannot build CommitOp, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

