/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.objtypes.GenericObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;

@Generated(from="GenericObj", generator="Immutables")
public final class ImmutableGenericObj
extends GenericObj {
    private final long referenced;
    private final ObjType type;
    private final ObjId id;
    private final Map<String, Object> attributes;

    private ImmutableGenericObj(Builder builder) {
        this.type = builder.type;
        this.id = builder.id;
        this.attributes = ImmutableGenericObj.createUnmodifiableMap(false, false, builder.attributes);
        this.referenced = builder.referencedIsSet() ? builder.referenced : super.referenced();
    }

    private ImmutableGenericObj(long referenced, ObjType type, ObjId id, Map<String, Object> attributes) {
        this.referenced = referenced;
        this.type = type;
        this.id = id;
        this.attributes = attributes;
    }

    @Override
    public long referenced() {
        return this.referenced;
    }

    @Override
    public ObjType type() {
        return this.type;
    }

    @Override
    public ObjId id() {
        return this.id;
    }

    @Override
    public Map<String, Object> attributes() {
        return this.attributes;
    }

    @Override
    public final ImmutableGenericObj withReferenced(long value) {
        if (this.referenced == value) {
            return this;
        }
        return new ImmutableGenericObj(value, this.type, this.id, this.attributes);
    }

    public final ImmutableGenericObj withType(ObjType value) {
        if (this.type == value) {
            return this;
        }
        ObjType newValue = Objects.requireNonNull(value, "type");
        return new ImmutableGenericObj(this.referenced, newValue, this.id, this.attributes);
    }

    public final ImmutableGenericObj withId(ObjId value) {
        if (this.id == value) {
            return this;
        }
        ObjId newValue = Objects.requireNonNull(value, "id");
        return new ImmutableGenericObj(this.referenced, this.type, newValue, this.attributes);
    }

    public final ImmutableGenericObj withAttributes(Map<String, ? extends Object> entries) {
        if (this.attributes == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableGenericObj.createUnmodifiableMap(false, false, entries);
        return new ImmutableGenericObj(this.referenced, this.type, this.id, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGenericObj && this.equalTo(0, (ImmutableGenericObj)another);
    }

    private boolean equalTo(int synthetic, ImmutableGenericObj another) {
        return this.type.equals(another.type) && this.id.equals(another.id) && this.attributes.equals(another.attributes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.attributes.hashCode();
        return h;
    }

    public String toString() {
        return "GenericObj{type=" + String.valueOf(this.type) + ", id=" + String.valueOf(this.id) + ", attributes=" + String.valueOf(this.attributes) + "}";
    }

    public static ImmutableGenericObj copyOf(GenericObj instance) {
        if (instance instanceof ImmutableGenericObj) {
            return (ImmutableGenericObj)instance;
        }
        return ImmutableGenericObj.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="GenericObj", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long OPT_BIT_REFERENCED = 1L;
        private long initBits = 3L;
        private long optBits;
        private long referenced;
        private ObjType type;
        private ObjId id;
        private Map<String, Object> attributes = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GenericObj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Obj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Obj instance;
            if (object instanceof GenericObj) {
                instance = (GenericObj)object;
                this.putAllAttributes(((GenericObj)instance).attributes());
            }
            if (object instanceof Obj) {
                instance = (Obj)object;
                this.type(instance.type());
                this.referenced(instance.referenced());
                this.id(instance.id());
            }
        }

        @CanIgnoreReturnValue
        public final Builder referenced(long referenced) {
            this.referenced = referenced;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(ObjType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(ObjId id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAttributes(String key, Object value) {
            this.attributes.put(key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putAttributes(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.attributes.put(k, v);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder attributes(Map<String, ? extends Object> entries) {
            this.attributes.clear();
            return this.putAllAttributes(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllAttributes(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.attributes.put(k, v);
            }
            return this;
        }

        public ImmutableGenericObj build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGenericObj(this);
        }

        private boolean referencedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build GenericObj, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

