/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.IndexObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@Generated(from="IndexObj", generator="Immutables")
public final class ImmutableIndexObj
implements IndexObj {
    @Nullable
    private final ObjId id;
    private final long referenced;
    private final ByteString index;

    private ImmutableIndexObj(@Nullable ObjId id, long referenced, ByteString index) {
        this.id = id;
        this.referenced = referenced;
        this.index = Objects.requireNonNull(index, "index");
    }

    private ImmutableIndexObj(ImmutableIndexObj original, @Nullable ObjId id, long referenced, ByteString index) {
        this.id = id;
        this.referenced = referenced;
        this.index = index;
    }

    @Override
    @Nullable
    public ObjId id() {
        return this.id;
    }

    @Override
    public long referenced() {
        return this.referenced;
    }

    @Override
    public ByteString index() {
        return this.index;
    }

    public final ImmutableIndexObj withId(@Nullable ObjId value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableIndexObj(this, value, this.referenced, this.index);
    }

    @Override
    public final ImmutableIndexObj withReferenced(long value) {
        if (this.referenced == value) {
            return this;
        }
        return new ImmutableIndexObj(this, this.id, value, this.index);
    }

    public final ImmutableIndexObj withIndex(ByteString value) {
        if (this.index == value) {
            return this;
        }
        ByteString newValue = Objects.requireNonNull(value, "index");
        return new ImmutableIndexObj(this, this.id, this.referenced, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIndexObj && this.equalTo(0, (ImmutableIndexObj)another);
    }

    private boolean equalTo(int synthetic, ImmutableIndexObj another) {
        return Objects.equals(this.id, another.id) && this.index.equals((Object)another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"IndexObj").omitNullValues().add("id", (Object)this.id).add("index", (Object)this.index).toString();
    }

    public static ImmutableIndexObj of(@Nullable ObjId id, long referenced, ByteString index) {
        return new ImmutableIndexObj(id, referenced, index);
    }

    public static ImmutableIndexObj copyOf(IndexObj instance) {
        if (instance instanceof ImmutableIndexObj) {
            return (ImmutableIndexObj)instance;
        }
        return ImmutableIndexObj.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IndexObj", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_REFERENCED = 1L;
        private static final long INIT_BIT_INDEX = 2L;
        private long initBits = 3L;
        private ObjId id;
        private long referenced;
        private ByteString index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Obj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(IndexObj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            ObjId idValue;
            Obj instance;
            long bits = 0L;
            if (object instanceof Obj) {
                instance = (Obj)object;
                if ((bits & 1L) == 0L) {
                    this.referenced(instance.referenced());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof IndexObj) {
                instance = (IndexObj)object;
                if ((bits & 1L) == 0L) {
                    this.referenced(instance.referenced());
                    bits |= 1L;
                }
                this.index(instance.index());
                if ((bits & 2L) == 0L) {
                    idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder id(@Nullable ObjId id) {
            this.id = id;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder referenced(long referenced) {
            this.referenced = referenced;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder index(ByteString index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableIndexObj build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIndexObj(null, this.id, this.referenced, this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("referenced");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build IndexObj, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

