/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.objtypes.IndexSegmentsObj;
import org.projectnessie.versioned.storage.common.objtypes.IndexStripe;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@Generated(from="IndexSegmentsObj", generator="Immutables")
public final class ImmutableIndexSegmentsObj
implements IndexSegmentsObj {
    @Nullable
    private final ObjId id;
    private final long referenced;
    private final ImmutableList<IndexStripe> stripes;

    private ImmutableIndexSegmentsObj(@Nullable ObjId id, long referenced, Iterable<? extends IndexStripe> stripes) {
        this.id = id;
        this.referenced = referenced;
        this.stripes = ImmutableList.copyOf(stripes);
    }

    private ImmutableIndexSegmentsObj(ImmutableIndexSegmentsObj original, @Nullable ObjId id, long referenced, ImmutableList<IndexStripe> stripes) {
        this.id = id;
        this.referenced = referenced;
        this.stripes = stripes;
    }

    @Override
    @Nullable
    public ObjId id() {
        return this.id;
    }

    @Override
    public long referenced() {
        return this.referenced;
    }

    public ImmutableList<IndexStripe> stripes() {
        return this.stripes;
    }

    public final ImmutableIndexSegmentsObj withId(@Nullable ObjId value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableIndexSegmentsObj(this, value, this.referenced, this.stripes);
    }

    @Override
    public final ImmutableIndexSegmentsObj withReferenced(long value) {
        if (this.referenced == value) {
            return this;
        }
        return new ImmutableIndexSegmentsObj(this, this.id, value, this.stripes);
    }

    public final ImmutableIndexSegmentsObj withStripes(IndexStripe ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableIndexSegmentsObj(this, this.id, this.referenced, (ImmutableList<IndexStripe>)newValue);
    }

    public final ImmutableIndexSegmentsObj withStripes(Iterable<? extends IndexStripe> elements) {
        if (this.stripes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableIndexSegmentsObj(this, this.id, this.referenced, (ImmutableList<IndexStripe>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIndexSegmentsObj && this.equalTo(0, (ImmutableIndexSegmentsObj)another);
    }

    private boolean equalTo(int synthetic, ImmutableIndexSegmentsObj another) {
        return Objects.equals(this.id, another.id) && this.stripes.equals(another.stripes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.stripes.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"IndexSegmentsObj").omitNullValues().add("id", (Object)this.id).add("stripes", this.stripes).toString();
    }

    public static ImmutableIndexSegmentsObj of(@Nullable ObjId id, long referenced, List<IndexStripe> stripes) {
        return ImmutableIndexSegmentsObj.of(id, referenced, stripes);
    }

    public static ImmutableIndexSegmentsObj of(@Nullable ObjId id, long referenced, Iterable<? extends IndexStripe> stripes) {
        return new ImmutableIndexSegmentsObj(id, referenced, stripes);
    }

    public static ImmutableIndexSegmentsObj copyOf(IndexSegmentsObj instance) {
        if (instance instanceof ImmutableIndexSegmentsObj) {
            return (ImmutableIndexSegmentsObj)instance;
        }
        return ImmutableIndexSegmentsObj.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IndexSegmentsObj", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_REFERENCED = 1L;
        private long initBits = 1L;
        private ObjId id;
        private long referenced;
        private ImmutableList.Builder<IndexStripe> stripes = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(IndexSegmentsObj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Obj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            ObjId idValue;
            Obj instance;
            long bits = 0L;
            if (object instanceof IndexSegmentsObj) {
                instance = (IndexSegmentsObj)object;
                this.addAllStripes(instance.stripes());
                if ((bits & 1L) == 0L) {
                    this.referenced(instance.referenced());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof Obj) {
                instance = (Obj)object;
                if ((bits & 1L) == 0L) {
                    this.referenced(instance.referenced());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder id(@Nullable ObjId id) {
            this.id = id;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder referenced(long referenced) {
            this.referenced = referenced;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addStripes(IndexStripe element) {
            this.stripes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addStripes(IndexStripe ... elements) {
            this.stripes.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder stripes(Iterable<? extends IndexStripe> elements) {
            this.stripes = ImmutableList.builder();
            return this.addAllStripes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllStripes(Iterable<? extends IndexStripe> elements) {
            this.stripes.addAll(elements);
            return this;
        }

        public ImmutableIndexSegmentsObj build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIndexSegmentsObj(null, this.id, this.referenced, (ImmutableList<IndexStripe>)this.stripes.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("referenced");
            }
            return "Cannot build IndexSegmentsObj, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

