/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.objtypes.IndexStripe;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@Generated(from="IndexStripe", generator="Immutables")
public final class ImmutableIndexStripe
implements IndexStripe {
    private final StoreKey firstKey;
    private final StoreKey lastKey;
    private final ObjId segment;

    private ImmutableIndexStripe(StoreKey firstKey, StoreKey lastKey, ObjId segment) {
        this.firstKey = Objects.requireNonNull(firstKey, "firstKey");
        this.lastKey = Objects.requireNonNull(lastKey, "lastKey");
        this.segment = Objects.requireNonNull(segment, "segment");
    }

    private ImmutableIndexStripe(ImmutableIndexStripe original, StoreKey firstKey, StoreKey lastKey, ObjId segment) {
        this.firstKey = firstKey;
        this.lastKey = lastKey;
        this.segment = segment;
    }

    @Override
    public StoreKey firstKey() {
        return this.firstKey;
    }

    @Override
    public StoreKey lastKey() {
        return this.lastKey;
    }

    @Override
    public ObjId segment() {
        return this.segment;
    }

    public final ImmutableIndexStripe withFirstKey(StoreKey value) {
        if (this.firstKey == value) {
            return this;
        }
        StoreKey newValue = Objects.requireNonNull(value, "firstKey");
        return new ImmutableIndexStripe(this, newValue, this.lastKey, this.segment);
    }

    public final ImmutableIndexStripe withLastKey(StoreKey value) {
        if (this.lastKey == value) {
            return this;
        }
        StoreKey newValue = Objects.requireNonNull(value, "lastKey");
        return new ImmutableIndexStripe(this, this.firstKey, newValue, this.segment);
    }

    public final ImmutableIndexStripe withSegment(ObjId value) {
        if (this.segment == value) {
            return this;
        }
        ObjId newValue = Objects.requireNonNull(value, "segment");
        return new ImmutableIndexStripe(this, this.firstKey, this.lastKey, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIndexStripe && this.equalTo(0, (ImmutableIndexStripe)another);
    }

    private boolean equalTo(int synthetic, ImmutableIndexStripe another) {
        return this.firstKey.equals(another.firstKey) && this.lastKey.equals(another.lastKey) && this.segment.equals(another.segment);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.firstKey.hashCode();
        h += (h << 5) + this.lastKey.hashCode();
        h += (h << 5) + this.segment.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"IndexStripe").omitNullValues().add("firstKey", (Object)this.firstKey).add("lastKey", (Object)this.lastKey).add("segment", (Object)this.segment).toString();
    }

    public static ImmutableIndexStripe of(StoreKey firstKey, StoreKey lastKey, ObjId segment) {
        return new ImmutableIndexStripe(firstKey, lastKey, segment);
    }

    public static ImmutableIndexStripe copyOf(IndexStripe instance) {
        if (instance instanceof ImmutableIndexStripe) {
            return (ImmutableIndexStripe)instance;
        }
        return ImmutableIndexStripe.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IndexStripe", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_FIRST_KEY = 1L;
        private static final long INIT_BIT_LAST_KEY = 2L;
        private static final long INIT_BIT_SEGMENT = 4L;
        private long initBits = 7L;
        private StoreKey firstKey;
        private StoreKey lastKey;
        private ObjId segment;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(IndexStripe instance) {
            Objects.requireNonNull(instance, "instance");
            this.firstKey(instance.firstKey());
            this.lastKey(instance.lastKey());
            this.segment(instance.segment());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder firstKey(StoreKey firstKey) {
            this.firstKey = Objects.requireNonNull(firstKey, "firstKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lastKey(StoreKey lastKey) {
            this.lastKey = Objects.requireNonNull(lastKey, "lastKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder segment(ObjId segment) {
            this.segment = Objects.requireNonNull(segment, "segment");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableIndexStripe build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIndexStripe(null, this.firstKey, this.lastKey, this.segment);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("firstKey");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("lastKey");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("segment");
            }
            return "Cannot build IndexStripe, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

