/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.objtypes.JsonObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@Generated(from="JsonObj", generator="Immutables")
public final class ImmutableJsonObj
implements JsonObj {
    private final ObjId id;
    private final long referenced;
    private final JsonObj.JsonBean bean;

    private ImmutableJsonObj(Builder builder) {
        this.id = builder.id;
        this.bean = builder.bean;
        this.referenced = builder.referencedIsSet() ? builder.referenced : JsonObj.super.referenced();
    }

    private ImmutableJsonObj(ObjId id, long referenced, JsonObj.JsonBean bean) {
        this.id = id;
        this.referenced = referenced;
        this.bean = bean;
    }

    @Override
    @JsonProperty(value="id")
    @JsonIgnore
    @JacksonInject(value="nessie.storage.ObjId")
    public ObjId id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="referenced")
    @JsonIgnore
    @JacksonInject(value="nessie.storage.ObjReferenced")
    public long referenced() {
        return this.referenced;
    }

    @Override
    @JsonProperty(value="bean")
    @JsonUnwrapped
    public JsonObj.JsonBean bean() {
        return this.bean;
    }

    public final ImmutableJsonObj withId(ObjId value) {
        if (this.id == value) {
            return this;
        }
        ObjId newValue = Objects.requireNonNull(value, "id");
        return new ImmutableJsonObj(newValue, this.referenced, this.bean);
    }

    @Override
    public final ImmutableJsonObj withReferenced(long value) {
        if (this.referenced == value) {
            return this;
        }
        return new ImmutableJsonObj(this.id, value, this.bean);
    }

    public final ImmutableJsonObj withBean(JsonObj.JsonBean value) {
        if (this.bean == value) {
            return this;
        }
        JsonObj.JsonBean newValue = Objects.requireNonNull(value, "bean");
        return new ImmutableJsonObj(this.id, this.referenced, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJsonObj && this.equalTo(0, (ImmutableJsonObj)another);
    }

    private boolean equalTo(int synthetic, ImmutableJsonObj another) {
        return this.id.equals(another.id) && this.bean.equals(another.bean);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.bean.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JsonObj").omitNullValues().add("id", (Object)this.id).add("bean", (Object)this.bean).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJsonObj fromJson(Json json) {
        Builder builder = ImmutableJsonObj.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.referencedIsSet) {
            builder.referenced(json.referenced);
        }
        if (json.bean != null) {
            builder.bean(json.bean);
        }
        return builder.build();
    }

    public static ImmutableJsonObj copyOf(JsonObj instance) {
        if (instance instanceof ImmutableJsonObj) {
            return (ImmutableJsonObj)instance;
        }
        return ImmutableJsonObj.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="JsonObj", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_BEAN = 2L;
        private static final long OPT_BIT_REFERENCED = 1L;
        private long initBits = 3L;
        private long optBits;
        private ObjId id;
        private long referenced;
        private JsonObj.JsonBean bean;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JsonObj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Obj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Obj instance;
            long bits = 0L;
            if (object instanceof JsonObj) {
                instance = (JsonObj)object;
                if ((bits & 1L) == 0L) {
                    this.referenced(instance.referenced());
                    bits |= 1L;
                }
                this.bean(instance.bean());
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
            if (object instanceof Obj) {
                instance = (Obj)object;
                if ((bits & 1L) == 0L) {
                    this.referenced(instance.referenced());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.id(instance.id());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="id")
        @JsonIgnore
        @JacksonInject(value="nessie.storage.ObjId")
        @CanIgnoreReturnValue
        public final Builder id(ObjId id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="referenced")
        @JsonIgnore
        @JacksonInject(value="nessie.storage.ObjReferenced")
        @CanIgnoreReturnValue
        public final Builder referenced(long referenced) {
            this.referenced = referenced;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="bean")
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder bean(JsonObj.JsonBean bean) {
            this.bean = Objects.requireNonNull(bean, "bean");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableJsonObj build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJsonObj(this);
        }

        private boolean referencedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("bean");
            }
            return "Cannot build JsonObj, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="JsonObj", generator="Immutables")
    static final class Json
    implements JsonObj {
        ObjId id;
        long referenced;
        boolean referencedIsSet;
        JsonObj.JsonBean bean;

        Json() {
        }

        @JsonProperty(value="id")
        @JsonIgnore
        @JacksonInject(value="nessie.storage.ObjId")
        public void setId(ObjId id) {
            this.id = id;
        }

        @JsonProperty(value="referenced")
        @JsonIgnore
        @JacksonInject(value="nessie.storage.ObjReferenced")
        public void setReferenced(long referenced) {
            this.referenced = referenced;
            this.referencedIsSet = true;
        }

        @JsonProperty(value="bean")
        @JsonUnwrapped
        public void setBean(JsonObj.JsonBean bean) {
            this.bean = bean;
        }

        @Override
        public Obj withReferenced(long referenced) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjId id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long referenced() {
            throw new UnsupportedOperationException();
        }

        @Override
        public JsonObj.JsonBean bean() {
            throw new UnsupportedOperationException();
        }
    }
}

