/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.UniqueIdObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@Generated(from="UniqueIdObj", generator="Immutables")
public final class ImmutableUniqueIdObj
implements UniqueIdObj {
    @Nullable
    private final ObjId id;
    private final long referenced;
    private final String space;
    private final ByteString value;

    private ImmutableUniqueIdObj(@Nullable ObjId id, long referenced, String space, ByteString value) {
        this.id = id;
        this.referenced = referenced;
        this.space = Objects.requireNonNull(space, "space");
        this.value = Objects.requireNonNull(value, "value");
    }

    private ImmutableUniqueIdObj(ImmutableUniqueIdObj original, @Nullable ObjId id, long referenced, String space, ByteString value) {
        this.id = id;
        this.referenced = referenced;
        this.space = space;
        this.value = value;
    }

    @Override
    @Nullable
    public ObjId id() {
        return this.id;
    }

    @Override
    public long referenced() {
        return this.referenced;
    }

    @Override
    public String space() {
        return this.space;
    }

    @Override
    public ByteString value() {
        return this.value;
    }

    public final ImmutableUniqueIdObj withId(@Nullable ObjId value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableUniqueIdObj(this, value, this.referenced, this.space, this.value);
    }

    @Override
    public final ImmutableUniqueIdObj withReferenced(long value) {
        if (this.referenced == value) {
            return this;
        }
        return new ImmutableUniqueIdObj(this, this.id, value, this.space, this.value);
    }

    public final ImmutableUniqueIdObj withSpace(String value) {
        String newValue = Objects.requireNonNull(value, "space");
        if (this.space.equals(newValue)) {
            return this;
        }
        return new ImmutableUniqueIdObj(this, this.id, this.referenced, newValue, this.value);
    }

    public final ImmutableUniqueIdObj withValue(ByteString value) {
        if (this.value == value) {
            return this;
        }
        ByteString newValue = Objects.requireNonNull(value, "value");
        return new ImmutableUniqueIdObj(this, this.id, this.referenced, this.space, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUniqueIdObj && this.equalTo(0, (ImmutableUniqueIdObj)another);
    }

    private boolean equalTo(int synthetic, ImmutableUniqueIdObj another) {
        return Objects.equals(this.id, another.id) && this.space.equals(another.space) && this.value.equals((Object)another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.space.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"UniqueIdObj").omitNullValues().add("id", (Object)this.id).add("space", (Object)this.space).add("value", (Object)this.value).toString();
    }

    public static ImmutableUniqueIdObj of(@Nullable ObjId id, long referenced, String space, ByteString value) {
        return new ImmutableUniqueIdObj(id, referenced, space, value);
    }

    public static ImmutableUniqueIdObj copyOf(UniqueIdObj instance) {
        if (instance instanceof ImmutableUniqueIdObj) {
            return (ImmutableUniqueIdObj)instance;
        }
        return ImmutableUniqueIdObj.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UniqueIdObj", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_REFERENCED = 1L;
        private static final long INIT_BIT_SPACE = 2L;
        private static final long INIT_BIT_VALUE = 4L;
        private long initBits = 7L;
        private ObjId id;
        private long referenced;
        private String space;
        private ByteString value;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Obj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(UniqueIdObj instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            ObjId idValue;
            Obj instance;
            long bits = 0L;
            if (object instanceof Obj) {
                instance = (Obj)object;
                if ((bits & 1L) == 0L) {
                    this.referenced(instance.referenced());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof UniqueIdObj) {
                instance = (UniqueIdObj)object;
                if ((bits & 2L) == 0L) {
                    idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.referenced(instance.referenced());
                    bits |= 1L;
                }
                this.value(instance.value());
                this.space(instance.space());
            }
        }

        @CanIgnoreReturnValue
        public final Builder id(@Nullable ObjId id) {
            this.id = id;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder referenced(long referenced) {
            this.referenced = referenced;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder space(String space) {
            this.space = Objects.requireNonNull(space, "space");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(ByteString value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableUniqueIdObj build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUniqueIdObj(null, this.id, this.referenced, this.space, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("referenced");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("space");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build UniqueIdObj, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

