/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.persist;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.Reference;

@Generated(from="Reference.PreviousPointer", generator="Immutables")
public final class ImmutablePreviousPointer
implements Reference.PreviousPointer {
    private final ObjId pointer;
    private final long timestamp;

    private ImmutablePreviousPointer(ObjId pointer, long timestamp) {
        this.pointer = Objects.requireNonNull(pointer, "pointer");
        this.timestamp = timestamp;
    }

    private ImmutablePreviousPointer(ImmutablePreviousPointer original, ObjId pointer, long timestamp) {
        this.pointer = pointer;
        this.timestamp = timestamp;
    }

    @Override
    public ObjId pointer() {
        return this.pointer;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    public final ImmutablePreviousPointer withPointer(ObjId value) {
        if (this.pointer == value) {
            return this;
        }
        ObjId newValue = Objects.requireNonNull(value, "pointer");
        return new ImmutablePreviousPointer(this, newValue, this.timestamp);
    }

    public final ImmutablePreviousPointer withTimestamp(long value) {
        if (this.timestamp == value) {
            return this;
        }
        return new ImmutablePreviousPointer(this, this.pointer, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePreviousPointer && this.equalTo(0, (ImmutablePreviousPointer)another);
    }

    private boolean equalTo(int synthetic, ImmutablePreviousPointer another) {
        return this.pointer.equals(another.pointer) && this.timestamp == another.timestamp;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.pointer.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.timestamp);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PreviousPointer").omitNullValues().add("pointer", (Object)this.pointer).add("timestamp", this.timestamp).toString();
    }

    public static ImmutablePreviousPointer of(ObjId pointer, long timestamp) {
        return new ImmutablePreviousPointer(pointer, timestamp);
    }

    public static ImmutablePreviousPointer copyOf(Reference.PreviousPointer instance) {
        if (instance instanceof ImmutablePreviousPointer) {
            return (ImmutablePreviousPointer)instance;
        }
        return ImmutablePreviousPointer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Reference.PreviousPointer", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_POINTER = 1L;
        private static final long INIT_BIT_TIMESTAMP = 2L;
        private long initBits = 3L;
        private ObjId pointer;
        private long timestamp;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Reference.PreviousPointer instance) {
            Objects.requireNonNull(instance, "instance");
            this.pointer(instance.pointer());
            this.timestamp(instance.timestamp());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pointer(ObjId pointer) {
            this.pointer = Objects.requireNonNull(pointer, "pointer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePreviousPointer build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePreviousPointer(null, this.pointer, this.timestamp);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pointer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("timestamp");
            }
            return "Cannot build PreviousPointer, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

