/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.CommitConflict;
import org.projectnessie.versioned.storage.common.objtypes.CommitOp;

@Generated(from="CommitConflict", generator="Immutables")
public final class ImmutableCommitConflict
implements CommitConflict {
    private final StoreKey key;
    private final CommitConflict.ConflictType conflictType;
    @Nullable
    private final CommitOp op;
    @Nullable
    private final CommitOp existing;

    private ImmutableCommitConflict(StoreKey key, CommitConflict.ConflictType conflictType, @Nullable CommitOp op, @Nullable CommitOp existing) {
        this.key = Objects.requireNonNull(key, "key");
        this.conflictType = Objects.requireNonNull(conflictType, "conflictType");
        this.op = op;
        this.existing = existing;
    }

    private ImmutableCommitConflict(ImmutableCommitConflict original, StoreKey key, CommitConflict.ConflictType conflictType, @Nullable CommitOp op, @Nullable CommitOp existing) {
        this.key = key;
        this.conflictType = conflictType;
        this.op = op;
        this.existing = existing;
    }

    @Override
    public StoreKey key() {
        return this.key;
    }

    @Override
    public CommitConflict.ConflictType conflictType() {
        return this.conflictType;
    }

    @Override
    @Nullable
    public CommitOp op() {
        return this.op;
    }

    @Override
    @Nullable
    public CommitOp existing() {
        return this.existing;
    }

    public final ImmutableCommitConflict withKey(StoreKey value) {
        if (this.key == value) {
            return this;
        }
        StoreKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutableCommitConflict(this, newValue, this.conflictType, this.op, this.existing);
    }

    public final ImmutableCommitConflict withConflictType(CommitConflict.ConflictType value) {
        CommitConflict.ConflictType newValue = Objects.requireNonNull(value, "conflictType");
        if (this.conflictType == newValue) {
            return this;
        }
        return new ImmutableCommitConflict(this, this.key, newValue, this.op, this.existing);
    }

    public final ImmutableCommitConflict withOp(@Nullable CommitOp value) {
        if (this.op == value) {
            return this;
        }
        return new ImmutableCommitConflict(this, this.key, this.conflictType, value, this.existing);
    }

    public final ImmutableCommitConflict withExisting(@Nullable CommitOp value) {
        if (this.existing == value) {
            return this;
        }
        return new ImmutableCommitConflict(this, this.key, this.conflictType, this.op, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitConflict && this.equalsByValue((ImmutableCommitConflict)another);
    }

    private boolean equalsByValue(ImmutableCommitConflict another) {
        return this.key.equals(another.key) && this.conflictType.equals((Object)another.conflictType) && Objects.equals(this.op, another.op) && Objects.equals(this.existing, another.existing);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.conflictType.hashCode();
        h += (h << 5) + Objects.hashCode(this.op);
        h += (h << 5) + Objects.hashCode(this.existing);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommitConflict").omitNullValues().add("key", (Object)this.key).add("conflictType", (Object)this.conflictType).add("op", (Object)this.op).add("existing", (Object)this.existing).toString();
    }

    public static ImmutableCommitConflict of(StoreKey key, CommitConflict.ConflictType conflictType, @Nullable CommitOp op, @Nullable CommitOp existing) {
        return new ImmutableCommitConflict(key, conflictType, op, existing);
    }

    public static ImmutableCommitConflict copyOf(CommitConflict instance) {
        if (instance instanceof ImmutableCommitConflict) {
            return (ImmutableCommitConflict)instance;
        }
        return ImmutableCommitConflict.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitConflict", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_CONFLICT_TYPE = 2L;
        private long initBits = 3L;
        private StoreKey key;
        private CommitConflict.ConflictType conflictType;
        private CommitOp op;
        private CommitOp existing;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitConflict instance) {
            CommitOp existingValue;
            Objects.requireNonNull(instance, "instance");
            this.key(instance.key());
            this.conflictType(instance.conflictType());
            CommitOp opValue = instance.op();
            if (opValue != null) {
                this.op(opValue);
            }
            if ((existingValue = instance.existing()) != null) {
                this.existing(existingValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(StoreKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder conflictType(CommitConflict.ConflictType conflictType) {
            this.conflictType = Objects.requireNonNull(conflictType, "conflictType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder op(@Nullable CommitOp op) {
            this.op = op;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder existing(@Nullable CommitOp existing) {
            this.existing = existing;
            return this;
        }

        public ImmutableCommitConflict build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitConflict(null, this.key, this.conflictType, this.op, this.existing);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("conflictType");
            }
            return "Cannot build CommitConflict, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

