/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.DiffQuery;
import org.projectnessie.versioned.storage.common.logic.PageableQuery;
import org.projectnessie.versioned.storage.common.logic.PagingToken;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;

@Generated(from="DiffQuery", generator="Immutables")
public final class ImmutableDiffQuery
implements DiffQuery {
    private final PagingToken pagingToken;
    @Nullable
    private final CommitObj fromCommit;
    @Nullable
    private final CommitObj toCommit;
    @Nullable
    private final StoreKey start;
    @Nullable
    private final StoreKey end;
    private final boolean prefetch;
    @Nullable
    private final Predicate<StoreKey> filter;

    private ImmutableDiffQuery(Optional<? extends PagingToken> pagingToken, @Nullable CommitObj fromCommit, @Nullable CommitObj toCommit, @Nullable StoreKey start, @Nullable StoreKey end, boolean prefetch, @Nullable Predicate<StoreKey> filter) {
        this.pagingToken = pagingToken.orElse(null);
        this.fromCommit = fromCommit;
        this.toCommit = toCommit;
        this.start = start;
        this.end = end;
        this.prefetch = prefetch;
        this.filter = filter;
    }

    private ImmutableDiffQuery(ImmutableDiffQuery original, PagingToken pagingToken, @Nullable CommitObj fromCommit, @Nullable CommitObj toCommit, @Nullable StoreKey start, @Nullable StoreKey end, boolean prefetch, @Nullable Predicate<StoreKey> filter) {
        this.pagingToken = pagingToken;
        this.fromCommit = fromCommit;
        this.toCommit = toCommit;
        this.start = start;
        this.end = end;
        this.prefetch = prefetch;
        this.filter = filter;
    }

    @Override
    public Optional<PagingToken> pagingToken() {
        return Optional.ofNullable(this.pagingToken);
    }

    @Override
    @Nullable
    public CommitObj fromCommit() {
        return this.fromCommit;
    }

    @Override
    @Nullable
    public CommitObj toCommit() {
        return this.toCommit;
    }

    @Override
    @Nullable
    public StoreKey start() {
        return this.start;
    }

    @Override
    @Nullable
    public StoreKey end() {
        return this.end;
    }

    @Override
    public boolean prefetch() {
        return this.prefetch;
    }

    @Override
    @Nullable
    public Predicate<StoreKey> filter() {
        return this.filter;
    }

    public final ImmutableDiffQuery withPagingToken(PagingToken value) {
        PagingToken newValue = Objects.requireNonNull(value, "pagingToken");
        if (this.pagingToken == newValue) {
            return this;
        }
        return new ImmutableDiffQuery(this, newValue, this.fromCommit, this.toCommit, this.start, this.end, this.prefetch, this.filter);
    }

    public final ImmutableDiffQuery withPagingToken(Optional<? extends PagingToken> optional) {
        PagingToken value = optional.orElse(null);
        if (this.pagingToken == value) {
            return this;
        }
        return new ImmutableDiffQuery(this, value, this.fromCommit, this.toCommit, this.start, this.end, this.prefetch, this.filter);
    }

    public final ImmutableDiffQuery withFromCommit(@Nullable CommitObj value) {
        if (this.fromCommit == value) {
            return this;
        }
        return new ImmutableDiffQuery(this, this.pagingToken, value, this.toCommit, this.start, this.end, this.prefetch, this.filter);
    }

    public final ImmutableDiffQuery withToCommit(@Nullable CommitObj value) {
        if (this.toCommit == value) {
            return this;
        }
        return new ImmutableDiffQuery(this, this.pagingToken, this.fromCommit, value, this.start, this.end, this.prefetch, this.filter);
    }

    public final ImmutableDiffQuery withStart(@Nullable StoreKey value) {
        if (this.start == value) {
            return this;
        }
        return new ImmutableDiffQuery(this, this.pagingToken, this.fromCommit, this.toCommit, value, this.end, this.prefetch, this.filter);
    }

    public final ImmutableDiffQuery withEnd(@Nullable StoreKey value) {
        if (this.end == value) {
            return this;
        }
        return new ImmutableDiffQuery(this, this.pagingToken, this.fromCommit, this.toCommit, this.start, value, this.prefetch, this.filter);
    }

    public final ImmutableDiffQuery withPrefetch(boolean value) {
        if (this.prefetch == value) {
            return this;
        }
        return new ImmutableDiffQuery(this, this.pagingToken, this.fromCommit, this.toCommit, this.start, this.end, value, this.filter);
    }

    public final ImmutableDiffQuery withFilter(@Nullable Predicate<StoreKey> value) {
        if (this.filter == value) {
            return this;
        }
        return new ImmutableDiffQuery(this, this.pagingToken, this.fromCommit, this.toCommit, this.start, this.end, this.prefetch, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDiffQuery && this.equalsByValue((ImmutableDiffQuery)another);
    }

    private boolean equalsByValue(ImmutableDiffQuery another) {
        return Objects.equals(this.pagingToken, another.pagingToken) && Objects.equals(this.fromCommit, another.fromCommit) && Objects.equals(this.toCommit, another.toCommit) && Objects.equals(this.start, another.start) && Objects.equals(this.end, another.end) && this.prefetch == another.prefetch && Objects.equals(this.filter, another.filter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.pagingToken);
        h += (h << 5) + Objects.hashCode(this.fromCommit);
        h += (h << 5) + Objects.hashCode(this.toCommit);
        h += (h << 5) + Objects.hashCode(this.start);
        h += (h << 5) + Objects.hashCode(this.end);
        h += (h << 5) + Booleans.hashCode((boolean)this.prefetch);
        h += (h << 5) + Objects.hashCode(this.filter);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DiffQuery").omitNullValues().add("pagingToken", (Object)this.pagingToken).add("fromCommit", (Object)this.fromCommit).add("toCommit", (Object)this.toCommit).add("start", (Object)this.start).add("end", (Object)this.end).add("prefetch", this.prefetch).add("filter", this.filter).toString();
    }

    public static ImmutableDiffQuery of(Optional<? extends PagingToken> pagingToken, @Nullable CommitObj fromCommit, @Nullable CommitObj toCommit, @Nullable StoreKey start, @Nullable StoreKey end, boolean prefetch, @Nullable Predicate<StoreKey> filter) {
        return new ImmutableDiffQuery(pagingToken, fromCommit, toCommit, start, end, prefetch, filter);
    }

    public static ImmutableDiffQuery copyOf(DiffQuery instance) {
        if (instance instanceof ImmutableDiffQuery) {
            return (ImmutableDiffQuery)instance;
        }
        return ImmutableDiffQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DiffQuery", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PREFETCH = 1L;
        private long initBits = 1L;
        private PagingToken pagingToken;
        private CommitObj fromCommit;
        private CommitObj toCommit;
        private StoreKey start;
        private StoreKey end;
        private boolean prefetch;
        private Predicate<StoreKey> filter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PageableQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(DiffQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            PageableQuery instance;
            long bits = 0L;
            if (object instanceof PageableQuery) {
                instance = (PageableQuery)object;
                if ((bits & 1L) == 0L) {
                    Optional<PagingToken> pagingTokenOptional = instance.pagingToken();
                    if (pagingTokenOptional.isPresent()) {
                        this.pagingToken(pagingTokenOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof DiffQuery) {
                CommitObj fromCommitValue;
                StoreKey endValue;
                CommitObj toCommitValue;
                instance = (DiffQuery)object;
                Predicate<StoreKey> filterValue = instance.filter();
                if (filterValue != null) {
                    this.filter(filterValue);
                }
                if ((toCommitValue = instance.toCommit()) != null) {
                    this.toCommit(toCommitValue);
                }
                if ((bits & 1L) == 0L) {
                    Optional<PagingToken> pagingTokenOptional = instance.pagingToken();
                    if (pagingTokenOptional.isPresent()) {
                        this.pagingToken(pagingTokenOptional);
                    }
                    bits |= 1L;
                }
                this.prefetch(instance.prefetch());
                StoreKey startValue = instance.start();
                if (startValue != null) {
                    this.start(startValue);
                }
                if ((endValue = instance.end()) != null) {
                    this.end(endValue);
                }
                if ((fromCommitValue = instance.fromCommit()) != null) {
                    this.fromCommit(fromCommitValue);
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder pagingToken(PagingToken pagingToken) {
            this.pagingToken = Objects.requireNonNull(pagingToken, "pagingToken");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pagingToken(Optional<? extends PagingToken> pagingToken) {
            this.pagingToken = pagingToken.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fromCommit(@Nullable CommitObj fromCommit) {
            this.fromCommit = fromCommit;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toCommit(@Nullable CommitObj toCommit) {
            this.toCommit = toCommit;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder start(@Nullable StoreKey start) {
            this.start = start;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder end(@Nullable StoreKey end) {
            this.end = end;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder prefetch(boolean prefetch) {
            this.prefetch = prefetch;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder filter(@Nullable Predicate<StoreKey> filter) {
            this.filter = filter;
            return this;
        }

        public ImmutableDiffQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDiffQuery(null, this.pagingToken, this.fromCommit, this.toCommit, this.start, this.end, this.prefetch, this.filter);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("prefetch");
            }
            return "Cannot build DiffQuery, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

