/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.logic.RepositoryDescription;

@Generated(from="RepositoryDescription", generator="Immutables")
public final class ImmutableRepositoryDescription
implements RepositoryDescription {
    private final Instant repositoryCreatedTime;
    private final Instant oldestPossibleCommitTime;
    private final Map<String, String> properties;
    private final String defaultBranchName;
    @Nullable
    private final Instant repositoryImportedTime;

    private ImmutableRepositoryDescription(Instant repositoryCreatedTime, Instant oldestPossibleCommitTime, Map<String, String> properties, String defaultBranchName, @Nullable Instant repositoryImportedTime) {
        this.repositoryCreatedTime = repositoryCreatedTime;
        this.oldestPossibleCommitTime = oldestPossibleCommitTime;
        this.properties = properties;
        this.defaultBranchName = defaultBranchName;
        this.repositoryImportedTime = repositoryImportedTime;
    }

    @Override
    @JsonProperty(value="repositoryCreatedTime", required=true)
    @JsonSerialize(using=RepositoryDescription.InstantSerializer.class)
    @JsonDeserialize(using=RepositoryDescription.InstantDeserializer.class)
    public Instant repositoryCreatedTime() {
        return this.repositoryCreatedTime;
    }

    @Override
    @JsonProperty(value="oldestPossibleCommitTime", required=true)
    @JsonSerialize(using=RepositoryDescription.InstantSerializer.class)
    @JsonDeserialize(using=RepositoryDescription.InstantDeserializer.class)
    public Instant oldestPossibleCommitTime() {
        return this.oldestPossibleCommitTime;
    }

    @Override
    @JsonProperty(value="properties")
    public Map<String, String> properties() {
        return this.properties;
    }

    @Override
    @JsonProperty(value="defaultBranchName", required=true)
    public String defaultBranchName() {
        return this.defaultBranchName;
    }

    @Override
    @JsonProperty(value="repositoryImportedTime")
    @JsonSerialize(using=RepositoryDescription.InstantSerializer.class)
    @JsonDeserialize(using=RepositoryDescription.InstantDeserializer.class)
    @Nullable
    public Instant repositoryImportedTime() {
        return this.repositoryImportedTime;
    }

    public final ImmutableRepositoryDescription withRepositoryCreatedTime(Instant value) {
        if (this.repositoryCreatedTime == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "repositoryCreatedTime");
        return new ImmutableRepositoryDescription(newValue, this.oldestPossibleCommitTime, this.properties, this.defaultBranchName, this.repositoryImportedTime);
    }

    public final ImmutableRepositoryDescription withOldestPossibleCommitTime(Instant value) {
        if (this.oldestPossibleCommitTime == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "oldestPossibleCommitTime");
        return new ImmutableRepositoryDescription(this.repositoryCreatedTime, newValue, this.properties, this.defaultBranchName, this.repositoryImportedTime);
    }

    public final ImmutableRepositoryDescription withProperties(Map<String, ? extends String> entries) {
        if (this.properties == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableRepositoryDescription.createUnmodifiableMap(true, false, entries);
        return new ImmutableRepositoryDescription(this.repositoryCreatedTime, this.oldestPossibleCommitTime, newValue, this.defaultBranchName, this.repositoryImportedTime);
    }

    public final ImmutableRepositoryDescription withDefaultBranchName(String value) {
        String newValue = Objects.requireNonNull(value, "defaultBranchName");
        if (this.defaultBranchName.equals(newValue)) {
            return this;
        }
        return new ImmutableRepositoryDescription(this.repositoryCreatedTime, this.oldestPossibleCommitTime, this.properties, newValue, this.repositoryImportedTime);
    }

    public final ImmutableRepositoryDescription withRepositoryImportedTime(@Nullable Instant value) {
        if (this.repositoryImportedTime == value) {
            return this;
        }
        return new ImmutableRepositoryDescription(this.repositoryCreatedTime, this.oldestPossibleCommitTime, this.properties, this.defaultBranchName, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRepositoryDescription && this.equalsByValue((ImmutableRepositoryDescription)another);
    }

    private boolean equalsByValue(ImmutableRepositoryDescription another) {
        return this.repositoryCreatedTime.equals(another.repositoryCreatedTime) && this.oldestPossibleCommitTime.equals(another.oldestPossibleCommitTime) && this.properties.equals(another.properties) && this.defaultBranchName.equals(another.defaultBranchName) && Objects.equals(this.repositoryImportedTime, another.repositoryImportedTime);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.repositoryCreatedTime.hashCode();
        h += (h << 5) + this.oldestPossibleCommitTime.hashCode();
        h += (h << 5) + this.properties.hashCode();
        h += (h << 5) + this.defaultBranchName.hashCode();
        h += (h << 5) + Objects.hashCode(this.repositoryImportedTime);
        return h;
    }

    public String toString() {
        return "RepositoryDescription{repositoryCreatedTime=" + String.valueOf(this.repositoryCreatedTime) + ", oldestPossibleCommitTime=" + String.valueOf(this.oldestPossibleCommitTime) + ", properties=" + String.valueOf(this.properties) + ", defaultBranchName=" + this.defaultBranchName + ", repositoryImportedTime=" + String.valueOf(this.repositoryImportedTime) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRepositoryDescription fromJson(Json json) {
        Builder builder = ImmutableRepositoryDescription.builder();
        if (json._repositoryCreatedTime != null) {
            builder.repositoryCreatedTime(json._repositoryCreatedTime);
        }
        if (json._oldestPossibleCommitTime != null) {
            builder.oldestPossibleCommitTime(json._oldestPossibleCommitTime);
        }
        if (json._properties != null) {
            builder.putAllProperties(json._properties);
        }
        if (json._defaultBranchName != null) {
            builder.defaultBranchName(json._defaultBranchName);
        }
        if (json._repositoryImportedTime != null) {
            builder.repositoryImportedTime(json._repositoryImportedTime);
        }
        return builder.build();
    }

    public static ImmutableRepositoryDescription copyOf(RepositoryDescription instance) {
        if (instance instanceof ImmutableRepositoryDescription) {
            return (ImmutableRepositoryDescription)instance;
        }
        return ImmutableRepositoryDescription.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="RepositoryDescription", generator="Immutables")
    public static final class Builder
    implements RepositoryDescription.Builder {
        private static final long INIT_BIT_REPOSITORY_CREATED_TIME = 1L;
        private static final long INIT_BIT_OLDEST_POSSIBLE_COMMIT_TIME = 2L;
        private static final long INIT_BIT_DEFAULT_BRANCH_NAME = 4L;
        private long initBits = 7L;
        private Instant repositoryCreatedTime;
        private Instant oldestPossibleCommitTime;
        private Map<String, String> properties = new LinkedHashMap<String, String>();
        private String defaultBranchName;
        private Instant repositoryImportedTime;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RepositoryDescription instance) {
            Objects.requireNonNull(instance, "instance");
            this.repositoryCreatedTime(instance.repositoryCreatedTime());
            this.oldestPossibleCommitTime(instance.oldestPossibleCommitTime());
            this.putAllProperties(instance.properties());
            this.defaultBranchName(instance.defaultBranchName());
            Instant repositoryImportedTimeValue = instance.repositoryImportedTime();
            if (repositoryImportedTimeValue != null) {
                this.repositoryImportedTime(repositoryImportedTimeValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="repositoryCreatedTime", required=true)
        @JsonSerialize(using=RepositoryDescription.InstantSerializer.class)
        @JsonDeserialize(using=RepositoryDescription.InstantDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder repositoryCreatedTime(Instant repositoryCreatedTime) {
            this.repositoryCreatedTime = Objects.requireNonNull(repositoryCreatedTime, "repositoryCreatedTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="oldestPossibleCommitTime", required=true)
        @JsonSerialize(using=RepositoryDescription.InstantSerializer.class)
        @JsonDeserialize(using=RepositoryDescription.InstantDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder oldestPossibleCommitTime(Instant oldestPossibleCommitTime) {
            this.oldestPossibleCommitTime = Objects.requireNonNull(oldestPossibleCommitTime, "oldestPossibleCommitTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder putProperties(String key, String value) {
            this.properties.put(Objects.requireNonNull(key, "properties key"), Objects.requireNonNull(value, value == null ? "properties value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "properties value for key: " + k : null));
            return this;
        }

        @JsonProperty(value="properties")
        @CanIgnoreReturnValue
        public final Builder properties(Map<String, ? extends String> entries) {
            this.properties.clear();
            return this.putAllProperties((Map)entries);
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder putAllProperties(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "properties value for key: " + k : null));
            }
            return this;
        }

        @Override
        @JsonProperty(value="defaultBranchName", required=true)
        @CanIgnoreReturnValue
        public final Builder defaultBranchName(String defaultBranchName) {
            this.defaultBranchName = Objects.requireNonNull(defaultBranchName, "defaultBranchName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        @JsonProperty(value="repositoryImportedTime")
        @JsonSerialize(using=RepositoryDescription.InstantSerializer.class)
        @JsonDeserialize(using=RepositoryDescription.InstantDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder repositoryImportedTime(@Nullable Instant repositoryImportedTime) {
            this.repositoryImportedTime = repositoryImportedTime;
            return this;
        }

        @Override
        public ImmutableRepositoryDescription build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRepositoryDescription(this.repositoryCreatedTime, this.oldestPossibleCommitTime, ImmutableRepositoryDescription.createUnmodifiableMap(false, false, this.properties), this.defaultBranchName, this.repositoryImportedTime);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("repositoryCreatedTime");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("oldestPossibleCommitTime");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("defaultBranchName");
            }
            return "Cannot build RepositoryDescription, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="RepositoryDescription", generator="Immutables")
    static final class Json
    implements RepositoryDescription {
        @JsonIgnore
        Instant _repositoryCreatedTime;
        @JsonIgnore
        Instant _oldestPossibleCommitTime;
        @JsonIgnore
        Map<String, String> _properties = Collections.emptyMap();
        @JsonIgnore
        String _defaultBranchName;
        @JsonIgnore
        Instant _repositoryImportedTime;

        Json() {
        }

        @JsonProperty(value="repositoryCreatedTime", required=true)
        @JsonSerialize(using=RepositoryDescription.InstantSerializer.class)
        @JsonDeserialize(using=RepositoryDescription.InstantDeserializer.class)
        public void setRepositoryCreatedTime(Instant repositoryCreatedTime) {
            this._repositoryCreatedTime = repositoryCreatedTime;
        }

        @JsonProperty(value="oldestPossibleCommitTime", required=true)
        @JsonSerialize(using=RepositoryDescription.InstantSerializer.class)
        @JsonDeserialize(using=RepositoryDescription.InstantDeserializer.class)
        public void setOldestPossibleCommitTime(Instant oldestPossibleCommitTime) {
            this._oldestPossibleCommitTime = oldestPossibleCommitTime;
        }

        @JsonProperty(value="properties")
        public void setProperties(Map<String, String> properties) {
            this._properties = properties;
        }

        @JsonProperty(value="defaultBranchName", required=true)
        public void setDefaultBranchName(String defaultBranchName) {
            this._defaultBranchName = defaultBranchName;
        }

        @JsonProperty(value="repositoryImportedTime")
        @JsonSerialize(using=RepositoryDescription.InstantSerializer.class)
        @JsonDeserialize(using=RepositoryDescription.InstantDeserializer.class)
        public void setRepositoryImportedTime(@Nullable Instant repositoryImportedTime) {
            this._repositoryImportedTime = repositoryImportedTime;
        }

        @Override
        public Instant repositoryCreatedTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant oldestPossibleCommitTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> properties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String defaultBranchName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant repositoryImportedTime() {
            throw new UnsupportedOperationException();
        }
    }
}

