/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.logic.SuppliedCommitIndex;
import org.projectnessie.versioned.storage.common.objtypes.CommitOp;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@Generated(from="SuppliedCommitIndex", generator="Immutables")
public final class ImmutableSuppliedCommitIndex
implements SuppliedCommitIndex {
    private final ObjId pointer;
    private final StoreIndex<CommitOp> index;

    private ImmutableSuppliedCommitIndex(ObjId pointer, StoreIndex<CommitOp> index) {
        this.pointer = Objects.requireNonNull(pointer, "pointer");
        this.index = Objects.requireNonNull(index, "index");
    }

    private ImmutableSuppliedCommitIndex(ImmutableSuppliedCommitIndex original, ObjId pointer, StoreIndex<CommitOp> index) {
        this.pointer = pointer;
        this.index = index;
    }

    @Override
    public ObjId pointer() {
        return this.pointer;
    }

    @Override
    public StoreIndex<CommitOp> index() {
        return this.index;
    }

    public final ImmutableSuppliedCommitIndex withPointer(ObjId value) {
        if (this.pointer == value) {
            return this;
        }
        ObjId newValue = Objects.requireNonNull(value, "pointer");
        return new ImmutableSuppliedCommitIndex(this, newValue, this.index);
    }

    public final ImmutableSuppliedCommitIndex withIndex(StoreIndex<CommitOp> value) {
        if (this.index == value) {
            return this;
        }
        StoreIndex<CommitOp> newValue = Objects.requireNonNull(value, "index");
        return new ImmutableSuppliedCommitIndex(this, this.pointer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSuppliedCommitIndex && this.equalsByValue((ImmutableSuppliedCommitIndex)another);
    }

    private boolean equalsByValue(ImmutableSuppliedCommitIndex another) {
        return this.pointer.equals(another.pointer) && this.index.equals(another.index);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.pointer.hashCode();
        h += (h << 5) + this.index.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SuppliedCommitIndex").omitNullValues().add("pointer", (Object)this.pointer).add("index", this.index).toString();
    }

    public static ImmutableSuppliedCommitIndex of(ObjId pointer, StoreIndex<CommitOp> index) {
        return new ImmutableSuppliedCommitIndex(pointer, index);
    }

    public static ImmutableSuppliedCommitIndex copyOf(SuppliedCommitIndex instance) {
        if (instance instanceof ImmutableSuppliedCommitIndex) {
            return (ImmutableSuppliedCommitIndex)instance;
        }
        return ImmutableSuppliedCommitIndex.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SuppliedCommitIndex", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_POINTER = 1L;
        private static final long INIT_BIT_INDEX = 2L;
        private long initBits = 3L;
        private ObjId pointer;
        private StoreIndex<CommitOp> index;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SuppliedCommitIndex instance) {
            Objects.requireNonNull(instance, "instance");
            this.pointer(instance.pointer());
            this.index(instance.index());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pointer(ObjId pointer) {
            this.pointer = Objects.requireNonNull(pointer, "pointer");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder index(StoreIndex<CommitOp> index) {
            this.index = Objects.requireNonNull(index, "index");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSuppliedCommitIndex build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSuppliedCommitIndex(null, this.pointer, this.index);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pointer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("index");
            }
            return "Cannot build SuppliedCommitIndex, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

