/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.TagObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@Generated(from="TagObj", generator="Immutables")
public final class ImmutableTagObj
implements TagObj {
    @Nullable
    private final ObjId id;
    private final long referenced;
    @Nullable
    private final String message;
    @Nullable
    private final CommitHeaders headers;
    @Nullable
    private final ByteString signature;

    private ImmutableTagObj(@Nullable ObjId id, long referenced, @Nullable String message, @Nullable CommitHeaders headers, @Nullable ByteString signature) {
        this.id = id;
        this.referenced = referenced;
        this.message = message;
        this.headers = headers;
        this.signature = signature;
    }

    private ImmutableTagObj(ImmutableTagObj original, @Nullable ObjId id, long referenced, @Nullable String message, @Nullable CommitHeaders headers, @Nullable ByteString signature) {
        this.id = id;
        this.referenced = referenced;
        this.message = message;
        this.headers = headers;
        this.signature = signature;
    }

    @Override
    @Nullable
    public ObjId id() {
        return this.id;
    }

    @Override
    public long referenced() {
        return this.referenced;
    }

    @Override
    @Nullable
    public String message() {
        return this.message;
    }

    @Override
    @Nullable
    public CommitHeaders headers() {
        return this.headers;
    }

    @Override
    @Nullable
    public ByteString signature() {
        return this.signature;
    }

    public final ImmutableTagObj withId(@Nullable ObjId value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableTagObj(this, value, this.referenced, this.message, this.headers, this.signature);
    }

    @Override
    public final ImmutableTagObj withReferenced(long value) {
        if (this.referenced == value) {
            return this;
        }
        return new ImmutableTagObj(this, this.id, value, this.message, this.headers, this.signature);
    }

    public final ImmutableTagObj withMessage(@Nullable String value) {
        if (Objects.equals(this.message, value)) {
            return this;
        }
        return new ImmutableTagObj(this, this.id, this.referenced, value, this.headers, this.signature);
    }

    public final ImmutableTagObj withHeaders(@Nullable CommitHeaders value) {
        if (this.headers == value) {
            return this;
        }
        return new ImmutableTagObj(this, this.id, this.referenced, this.message, value, this.signature);
    }

    public final ImmutableTagObj withSignature(@Nullable ByteString value) {
        if (this.signature == value) {
            return this;
        }
        return new ImmutableTagObj(this, this.id, this.referenced, this.message, this.headers, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTagObj && this.equalsByValue((ImmutableTagObj)another);
    }

    private boolean equalsByValue(ImmutableTagObj another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.message, another.message) && Objects.equals(this.headers, another.headers) && Objects.equals(this.signature, another.signature);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.message);
        h += (h << 5) + Objects.hashCode(this.headers);
        h += (h << 5) + Objects.hashCode(this.signature);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TagObj").omitNullValues().add("id", (Object)this.id).add("message", (Object)this.message).add("headers", (Object)this.headers).add("signature", (Object)this.signature).toString();
    }

    public static ImmutableTagObj of(@Nullable ObjId id, long referenced, @Nullable String message, @Nullable CommitHeaders headers, @Nullable ByteString signature) {
        return new ImmutableTagObj(id, referenced, message, headers, signature);
    }

    public static ImmutableTagObj copyOf(TagObj instance) {
        if (instance instanceof ImmutableTagObj) {
            return (ImmutableTagObj)instance;
        }
        return ImmutableTagObj.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TagObj", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_REFERENCED = 1L;
        private long initBits = 1L;
        private ObjId id;
        private long referenced;
        private String message;
        private CommitHeaders headers;
        private ByteString signature;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TagObj instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Obj instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            Obj instance;
            long bits = 0L;
            if (object instanceof TagObj) {
                ByteString signatureValue;
                String messageValue;
                instance = (TagObj)object;
                CommitHeaders headersValue = instance.headers();
                if (headersValue != null) {
                    this.headers(headersValue);
                }
                if ((bits & 2L) == 0L) {
                    ObjId idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 2L;
                }
                if ((messageValue = instance.message()) != null) {
                    this.message(messageValue);
                }
                if ((bits & 1L) == 0L) {
                    this.referenced(instance.referenced());
                    bits |= 1L;
                }
                if ((signatureValue = instance.signature()) != null) {
                    this.signature(signatureValue);
                }
            }
            if (object instanceof Obj) {
                instance = (Obj)object;
                if ((bits & 1L) == 0L) {
                    this.referenced(instance.referenced());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    ObjId idValue = instance.id();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder id(@Nullable ObjId id) {
            this.id = id;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder referenced(long referenced) {
            this.referenced = referenced;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder message(@Nullable String message) {
            this.message = message;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder headers(@Nullable CommitHeaders headers) {
            this.headers = headers;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder signature(@Nullable ByteString signature) {
            this.signature = signature;
            return this;
        }

        public ImmutableTagObj build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTagObj(null, this.id, this.referenced, this.message, this.headers, this.signature);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("referenced");
            }
            return "Cannot build TagObj, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

