/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.indexes;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexElement;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StoreIndexElement", generator="Immutables")
@Immutable
public final class ImmutableStoreIndexElement<V>
implements StoreIndexElement<V> {
    private final StoreKey key;
    private final V content;

    private ImmutableStoreIndexElement(StoreKey key, V content) {
        this.key = Objects.requireNonNull(key, "key");
        this.content = Objects.requireNonNull(content, "content");
    }

    private ImmutableStoreIndexElement(ImmutableStoreIndexElement<V> original, StoreKey key, V content) {
        this.key = key;
        this.content = content;
    }

    @Override
    public StoreKey key() {
        return this.key;
    }

    @Override
    public V content() {
        return this.content;
    }

    public final ImmutableStoreIndexElement<V> withKey(StoreKey value) {
        if (this.key == value) {
            return this;
        }
        StoreKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutableStoreIndexElement<V>(this, newValue, this.content);
    }

    public final ImmutableStoreIndexElement<V> withContent(V value) {
        if (this.content == value) {
            return this;
        }
        V newValue = Objects.requireNonNull(value, "content");
        return new ImmutableStoreIndexElement<V>(this, this.key, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStoreIndexElement && this.equalTo(0, (ImmutableStoreIndexElement)another);
    }

    private boolean equalTo(int synthetic, ImmutableStoreIndexElement<?> another) {
        return this.key.equals(another.key) && this.content.equals(another.content);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.content.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StoreIndexElement").omitNullValues().add("key", (Object)this.key).add("content", this.content).toString();
    }

    public static <V> ImmutableStoreIndexElement<V> of(StoreKey key, V content) {
        return new ImmutableStoreIndexElement<V>(key, content);
    }

    public static <V> ImmutableStoreIndexElement<V> copyOf(StoreIndexElement<V> instance) {
        if (instance instanceof ImmutableStoreIndexElement) {
            return (ImmutableStoreIndexElement)instance;
        }
        return ImmutableStoreIndexElement.builder().from(instance).build();
    }

    public static <V> Builder<V> builder() {
        return new Builder();
    }

    @Generated(from="StoreIndexElement", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<V> {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_CONTENT = 2L;
        private long initBits = 3L;
        @Nullable
        private StoreKey key;
        @Nullable
        private V content;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<V> from(StoreIndexElement<V> instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.key());
            this.content(instance.content());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<V> key(StoreKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<V> content(V content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableStoreIndexElement<V> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStoreIndexElement(null, this.key, this.content);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("content");
            }
            return "Cannot build StoreIndexElement, some of required attributes are not set " + attributes;
        }
    }
}

