/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.indexes;

import jakarta.annotation.Nonnull;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexElement;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.util.SupplyOnce;

final class LazyIndexImpl<V>
implements StoreIndex<V> {
    private final Supplier<StoreIndex<V>> loader;
    private boolean loaded;
    private ObjId objId;
    private final StoreKey firstKey;
    private final StoreKey lastKey;

    LazyIndexImpl(Supplier<StoreIndex<V>> supplier, StoreKey firstKey, StoreKey lastKey) {
        this.firstKey = firstKey;
        this.lastKey = lastKey;
        this.loader = SupplyOnce.memoize(() -> {
            try {
                StoreIndex storeIndex = (StoreIndex)supplier.get();
                return storeIndex;
            }
            finally {
                this.loaded = true;
            }
        });
    }

    private StoreIndex<V> loaded() {
        return this.loader.get();
    }

    @Override
    public ObjId getObjId() {
        return this.objId;
    }

    @Override
    public StoreIndex<V> setObjId(ObjId objId) {
        this.objId = objId;
        return this;
    }

    @Override
    public boolean isModified() {
        if (!this.loaded) {
            return false;
        }
        return this.loaded().isModified();
    }

    @Override
    public StoreIndex<V> loadIfNecessary(Set<StoreKey> keys) {
        return this.loaded().loadIfNecessary(keys);
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public StoreIndex<V> asMutableIndex() {
        return this.loaded().asMutableIndex();
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public List<StoreIndex<V>> divide(int parts) {
        throw new UnsupportedOperationException("Operation not supported for non-mutable indexes");
    }

    @Override
    public List<StoreIndex<V>> stripes() {
        return this.loaded().stripes();
    }

    @Override
    public int elementCount() {
        return this.loaded().elementCount();
    }

    @Override
    public int estimatedSerializedSize() {
        return this.loaded().estimatedSerializedSize();
    }

    @Override
    public boolean add(@javax.annotation.Nonnull @Nonnull StoreIndexElement<V> element) {
        return this.loaded().add(element);
    }

    @Override
    public void updateAll(Function<StoreIndexElement<V>, V> updater) {
        this.loaded().updateAll(updater);
    }

    @Override
    public boolean remove(@javax.annotation.Nonnull @Nonnull StoreKey key) {
        return this.loaded().remove(key);
    }

    @Override
    public boolean contains(@javax.annotation.Nonnull @Nonnull StoreKey key) {
        if (!this.loaded && (key.equals(this.firstKey) || key.equals(this.lastKey))) {
            return true;
        }
        return this.loaded().contains(key);
    }

    @Override
    @Nullable
    @jakarta.annotation.Nullable
    public StoreIndexElement<V> get(@javax.annotation.Nonnull @Nonnull StoreKey key) {
        return this.loaded().get(key);
    }

    @Override
    @Nullable
    @jakarta.annotation.Nullable
    public StoreKey first() {
        if (this.loaded || this.firstKey == null) {
            return this.loaded().first();
        }
        return this.firstKey;
    }

    @Override
    @Nullable
    @jakarta.annotation.Nullable
    public StoreKey last() {
        if (this.loaded || this.lastKey == null) {
            return this.loaded().last();
        }
        return this.lastKey;
    }

    @Override
    public List<StoreKey> asKeyList() {
        return this.loaded().asKeyList();
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Iterator<StoreIndexElement<V>> iterator() {
        return this.loaded().iterator();
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Iterator<StoreIndexElement<V>> iterator(@Nullable @jakarta.annotation.Nullable StoreKey begin, @Nullable @jakarta.annotation.Nullable StoreKey end, boolean prefetch) {
        return this.loaded().iterator(begin, end, prefetch);
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public ByteString serialize() {
        return this.loaded().serialize();
    }
}

