/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Sets;
import com.google.common.hash.Hasher;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.agrona.collections.ObjectHashSet;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.exceptions.CommitConflictException;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexElement;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexes;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.CommitConflict;
import org.projectnessie.versioned.storage.common.logic.CommitLogQuery;
import org.projectnessie.versioned.storage.common.logic.CommitLogic;
import org.projectnessie.versioned.storage.common.logic.CommitOpHandler;
import org.projectnessie.versioned.storage.common.logic.ConflictHandler;
import org.projectnessie.versioned.storage.common.logic.CreateCommit;
import org.projectnessie.versioned.storage.common.logic.DiffEntry;
import org.projectnessie.versioned.storage.common.logic.DiffQuery;
import org.projectnessie.versioned.storage.common.logic.HeadsAndForkPoints;
import org.projectnessie.versioned.storage.common.logic.IdentifyHeadsAndForkPoints;
import org.projectnessie.versioned.storage.common.logic.IndexesLogic;
import org.projectnessie.versioned.storage.common.logic.Logics;
import org.projectnessie.versioned.storage.common.logic.PagedResult;
import org.projectnessie.versioned.storage.common.logic.PagingToken;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.CommitObjReference;
import org.projectnessie.versioned.storage.common.objtypes.CommitOp;
import org.projectnessie.versioned.storage.common.objtypes.CommitType;
import org.projectnessie.versioned.storage.common.objtypes.Hashes;
import org.projectnessie.versioned.storage.common.persist.CloseableIterator;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CommitLogicImpl
implements CommitLogic {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommitLogicImpl.class);
    static final String NO_COMMON_ANCESTOR_IN_PARENTS_OF = "No common ancestor in parents of ";
    private final Persist persist;

    CommitLogicImpl(Persist persist) {
        this.persist = persist;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public PagedResult<CommitObj, ObjId> commitLog(@javax.annotation.Nonnull @Nonnull CommitLogQuery commitLogQuery) {
        ObjId startCommitId = commitLogQuery.pagingToken().map(PagingToken::token).map(ObjId::objIdFromBytes).orElse(commitLogQuery.commitId());
        return new CommitLogIter(startCommitId, commitLogQuery.endCommitId().orElse(null));
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public PagedResult<ObjId, ObjId> commitIdLog(@javax.annotation.Nonnull @Nonnull CommitLogQuery commitLogQuery) {
        ObjId startCommitId = commitLogQuery.pagingToken().map(PagingToken::token).map(ObjId::objIdFromBytes).orElse(commitLogQuery.commitId());
        return new CommitIdIter(startCommitId, commitLogQuery.endCommitId().orElse(null));
    }

    @Override
    @javax.annotation.Nullable
    @Nullable
    public ObjId doCommit(@javax.annotation.Nonnull @Nonnull CreateCommit createCommit, @javax.annotation.Nonnull @Nonnull List<Obj> additionalObjects) throws CommitConflictException, ObjNotFoundException {
        CommitObj commit = this.buildCommitObj(createCommit, c -> ConflictHandler.ConflictResolution.CONFLICT, (k, v) -> {});
        return this.storeCommit(commit, additionalObjects) ? commit.id() : null;
    }

    @Override
    public boolean storeCommit(@javax.annotation.Nonnull @Nonnull CommitObj commit, @javax.annotation.Nonnull @Nonnull List<Obj> additionalObjects) {
        int numAdditional = additionalObjects.size();
        try {
            Obj[] allObjs = additionalObjects.toArray(new Obj[numAdditional + 1]);
            allObjs[numAdditional] = commit;
            boolean[] stored = this.persist.storeObjs(allObjs);
            return stored[numAdditional];
        }
        catch (ObjTooLargeException e) {
            try {
                this.persist.storeObjs(additionalObjects.toArray(new Obj[numAdditional]));
            }
            catch (ObjTooLargeException ex) {
                throw new RuntimeException(ex);
            }
            commit = this.indexTooBigStoreUpdate(commit);
            try {
                return this.persist.storeObj(commit, true);
            }
            catch (ObjTooLargeException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public CommitObj updateCommit(@javax.annotation.Nonnull @Nonnull CommitObj commit) {
        try {
            this.persist.upsertObj(commit);
        }
        catch (ObjTooLargeException e) {
            commit = this.indexTooBigStoreUpdate(commit);
            try {
                this.persist.upsertObj(commit);
            }
            catch (ObjTooLargeException ex) {
                throw new RuntimeException(ex);
            }
        }
        return commit;
    }

    private CommitObj indexTooBigStoreUpdate(CommitObj commit) {
        StoreIndex<CommitOp> newIncremental = StoreIndexes.newStoreIndex(CommitOp.COMMIT_OP_SERIALIZER);
        StoreIndex<CommitOp> referenceIndex = this.createReferenceIndexForCommit(commit, newIncremental);
        try {
            commit = this.persistReferenceIndexForCommit(commit, newIncremental, referenceIndex);
        }
        catch (ObjTooLargeException ex) {
            throw new RuntimeException(ex);
        }
        return commit;
    }

    private CommitObj persistReferenceIndexForCommit(CommitObj commit, StoreIndex<CommitOp> newIncremental, StoreIndex<CommitOp> referenceIndex) throws ObjTooLargeException {
        IndexesLogic indexesLogic = Logics.indexesLogic(this.persist);
        ObjId referenceIndexId = null;
        List<Object> referenceIndexStripes = Collections.emptyList();
        if (referenceIndex != null) {
            if (referenceIndex.stripes().size() <= this.persist.config().maxReferenceStripesPerCommit()) {
                referenceIndexStripes = indexesLogic.persistIndexStripesFromIndex(referenceIndex);
            } else {
                referenceIndexId = indexesLogic.persistStripedIndex(referenceIndex);
            }
        }
        commit = CommitObj.commitBuilder().from(commit).incrementalIndex(newIncremental.serialize()).referenceIndex(referenceIndexId).referenceIndexStripes(referenceIndexStripes).build();
        return commit;
    }

    private StoreIndex<CommitOp> createReferenceIndexForCommit(CommitObj commit, StoreIndex<CommitOp> newIncremental) {
        List<StoreIndex<Object>> stripes = commit.hasReferenceIndex() ? this.updateExistingReferenceIndex(commit, newIncremental) : this.createNewReferenceIndex(commit, newIncremental);
        if (stripes.isEmpty()) {
            return null;
        }
        if (stripes.size() == 1) {
            return stripes.get(0);
        }
        return StoreIndexes.indexFromStripes(stripes);
    }

    /*
     * WARNING - void declaration
     */
    private List<StoreIndex<CommitOp>> updateExistingReferenceIndex(CommitObj commitObj, StoreIndex<CommitOp> newIncremental) {
        void var11_16;
        CommitOp.Action action;
        CommitOp c;
        int maxSize = this.persist.effectiveIndexSegmentSizeLimit();
        int newSegmentSize = maxSize / 2;
        IndexesLogic indexesLogic = Logics.indexesLogic(this.persist);
        StoreIndex<CommitOp> referenceIndex = Objects.requireNonNull(indexesLogic.buildReferenceIndexOnly(commitObj), "Commit is expected to have a reference index here").asMutableIndex();
        List<StoreIndex<CommitOp>> currentStripes = referenceIndex.stripes();
        StoreIndex<CommitOp> incrementalIndex = indexesLogic.incrementalIndexFromCommit(commitObj);
        HashSet<StoreKey> prefetch = new HashSet<StoreKey>();
        for (StoreIndexElement<CommitOp> storeIndexElement : incrementalIndex) {
            c = storeIndexElement.content();
            action = c.action();
            if (action.currentCommit()) continue;
            prefetch.add(storeIndexElement.key());
        }
        referenceIndex.loadIfNecessary(prefetch);
        for (StoreIndexElement<CommitOp> storeIndexElement : incrementalIndex) {
            c = storeIndexElement.content();
            action = c.action();
            if (action.currentCommit()) {
                newIncremental.add(storeIndexElement);
                continue;
            }
            if (action.exists()) {
                referenceIndex.add(StoreIndexElement.indexElement(storeIndexElement.key(), CommitOp.commitOp(CommitOp.Action.NONE, c.payload(), c.value(), c.contentId())));
                continue;
            }
            referenceIndex.remove(storeIndexElement.key());
        }
        int newStripes = 0;
        boolean bl = false;
        int touched = 0;
        ArrayList<StoreIndex<CommitOp>> stripes = new ArrayList<StoreIndex<CommitOp>>(currentStripes.size() * 2);
        for (StoreIndex<CommitOp> s : currentStripes) {
            if (s.isMutable()) {
                ++touched;
                if (s.estimatedSerializedSize() > maxSize) {
                    int parts = Math.max(s.estimatedSerializedSize() / newSegmentSize + 1, 2);
                    List<StoreIndex<CommitOp>> divided = s.divide(parts);
                    newStripes += divided.size() - 1;
                    stripes.addAll(divided);
                    ++var11_16;
                    continue;
                }
                if (s.elementCount() > 0) {
                    stripes.add(s);
                    continue;
                }
                ++var11_16;
                continue;
            }
            stripes.add(s);
        }
        LOGGER.info("Generated reference index with {} stripes ({} touched, {} new, {} removed) for commit {} at seq # {}", new Object[]{stripes.size(), touched, newStripes, (int)var11_16, commitObj.id(), commitObj.seq()});
        return stripes;
    }

    private List<StoreIndex<CommitOp>> createNewReferenceIndex(CommitObj commitObj, StoreIndex<CommitOp> newIncremental) {
        int maxSize = this.persist.effectiveIndexSegmentSizeLimit();
        int newSegmentSize = maxSize / 2;
        ArrayList<StoreIndex<CommitOp>> stripes = new ArrayList<StoreIndex<CommitOp>>();
        StoreIndex<CommitOp> current = StoreIndexes.newStoreIndex(CommitOp.COMMIT_OP_SERIALIZER);
        IndexesLogic indexesLogic = Logics.indexesLogic(this.persist);
        for (StoreIndexElement<CommitOp> storeIndexElement : indexesLogic.incrementalIndexFromCommit(commitObj)) {
            CommitOp content = storeIndexElement.content();
            if (!content.action().currentCommit()) {
                current.add(StoreIndexElement.indexElement(storeIndexElement.key(), CommitOp.commitOp(CommitOp.Action.NONE, content.payload(), content.value(), content.contentId())));
            } else {
                newIncremental.add(storeIndexElement);
            }
            if (current.estimatedSerializedSize() <= newSegmentSize) continue;
            stripes.add(current);
            current = StoreIndexes.newStoreIndex(CommitOp.COMMIT_OP_SERIALIZER);
        }
        if (current.elementCount() > 0) {
            stripes.add(current);
        }
        int sz = stripes.size();
        LOGGER.info("Generated reference index with {} stripes ({} touched, {} new) for commit {} at seq # {}", new Object[]{sz, sz, sz, commitObj.id(), commitObj.seq()});
        return stripes;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public CommitObj buildCommitObj(@javax.annotation.Nonnull @Nonnull CreateCommit createCommit, @javax.annotation.Nonnull @Nonnull ConflictHandler conflictHandler, @javax.annotation.Nonnull @Nonnull CommitOpHandler commitOpHandler) throws CommitConflictException, ObjNotFoundException {
        ObjId expectedValue;
        CommitOp existingContent;
        int payload;
        UUID contentId;
        StoreKey key;
        StoreIndex<CommitOp> fullIndex;
        StoreIndex<CommitOp> index;
        StoreConfig config = this.persist.config();
        ObjId parentCommitId = createCommit.parentCommitId();
        CommitObj.Builder c = CommitObj.commitBuilder().created(config.currentTimeMicros()).addAllSecondaryParents(createCommit.secondaryParents()).addTail(parentCommitId).message(createCommit.message()).headers(createCommit.headers()).commitType(createCommit.commitType());
        Hasher hasher = Hashes.newHasher().putString((CharSequence)ObjType.COMMIT.name(), StandardCharsets.UTF_8).putBytes(parentCommitId.asByteBuffer()).putString((CharSequence)createCommit.message(), StandardCharsets.UTF_8);
        Hashes.hashCommitHeaders(hasher, createCommit.headers());
        CommitObj parent = this.fetchCommit(parentCommitId);
        if (parent != null) {
            List<ObjId> parentTail = parent.tail();
            int amount = Math.min(config.parentsPerCommit() - 1, parentTail.size());
            for (int i = 0; i < amount; ++i) {
                c.addTail(parentTail.get(i));
            }
            IndexesLogic indexesLogic = Logics.indexesLogic(this.persist);
            StoreIndex<CommitOp> incrementalIndex = indexesLogic.incrementalIndexFromCommit(parent);
            index = indexesLogic.incrementalIndexForUpdate(parent, Optional.of(incrementalIndex));
            c.seq(parent.seq() + 1L).referenceIndex(parent.referenceIndex()).addAllReferenceIndexStripes(parent.referenceIndexStripes());
            fullIndex = indexesLogic.buildCompleteIndex(parent, Optional.of(incrementalIndex));
        } else {
            Preconditions.checkArgument((boolean)ObjId.EMPTY_OBJ_ID.equals(parentCommitId), (String)"Commit to build points to non-existing parent commit %s", (Object)parentCommitId);
            fullIndex = index = StoreIndexes.newStoreIndex(CommitOp.COMMIT_OP_SERIALIZER);
            c.seq(1L);
        }
        ArrayList<CommitConflict> conflicts = new ArrayList<CommitConflict>();
        HashSet keys = Sets.newHashSetWithExpectedSize((int)(createCommit.adds().size() + createCommit.removes().size()));
        HashSet readdedKeys = Sets.newHashSetWithExpectedSize((int)createCommit.removes().size());
        CommitLogicImpl.preprocessCommitActions(createCommit, keys, readdedKeys);
        fullIndex.loadIfNecessary(keys);
        HashMap<UUID, CommitOp> removes = new HashMap<UUID, CommitOp>();
        for (CreateCommit.Remove remove : createCommit.removes()) {
            CommitConflict conflict;
            key = remove.key();
            contentId = remove.contentId();
            payload = remove.payload();
            StoreIndexElement<CommitOp> existing = CommitLogicImpl.existingFromIndex(fullIndex, key);
            existingContent = existing != null ? existing.content() : null;
            expectedValue = remove.expectedValue();
            CommitOp op = CommitOp.commitOp(CommitOp.Action.REMOVE, payload, expectedValue, contentId);
            if (contentId != null) {
                removes.put(contentId, op);
            }
            if ((conflict = CommitLogicImpl.checkForConflict(key, contentId, payload, op, existingContent, expectedValue)) != null) {
                if (CommitLogicImpl.handleConflict(conflictHandler, conflicts, conflict)) {
                    continue;
                }
            } else {
                commitOpHandler.nonConflicting(key, null);
            }
            hasher.putInt(2).putInt(payload).putString((CharSequence)key.rawString(), StandardCharsets.UTF_8);
            if (contentId != null) {
                hasher.putLong(contentId.getMostSignificantBits()).putLong(contentId.getLeastSignificantBits());
            }
            index.add(StoreIndexElement.indexElement(key, op));
        }
        for (CreateCommit.Unchanged unchanged : createCommit.unchanged()) {
            boolean readded;
            key = unchanged.key();
            CommitConflict conflict = CommitLogicImpl.checkForConflict(key, contentId = unchanged.contentId(), payload = unchanged.payload(), null, existingContent = CommitLogicImpl.existingContentForCommit(fullIndex, key, readded = readdedKeys.contains(key)), expectedValue = unchanged.expectedValue());
            if (conflict == null) continue;
            CommitLogicImpl.handleConflict(conflictHandler, conflicts, conflict);
        }
        for (CreateCommit.Add add : createCommit.adds()) {
            CommitOp removeOp;
            key = add.key();
            contentId = add.contentId();
            payload = add.payload();
            CommitOp op = CommitOp.commitOp(CommitOp.Action.ADD, payload, add.value(), add.contentId());
            CommitConflict conflict = null;
            boolean readded = readdedKeys.contains(key);
            CommitOp existingContent2 = CommitLogicImpl.existingContentForCommit(fullIndex, key, readded);
            if (!readded && (removeOp = (CommitOp)removes.remove(contentId)) != null) {
                if (existingContent2 != null) {
                    conflict = CommitConflict.commitConflict(key, CommitConflict.ConflictType.KEY_EXISTS, op, existingContent2);
                }
                existingContent2 = removeOp;
            }
            ObjId expectedValue2 = add.expectedValue();
            if (conflict == null) {
                conflict = CommitLogicImpl.checkForConflict(key, contentId, payload, op, existingContent2, expectedValue2);
            }
            if (conflict != null) {
                if (CommitLogicImpl.handleConflict(conflictHandler, conflicts, conflict)) {
                    continue;
                }
            } else {
                commitOpHandler.nonConflicting(key, add.value());
            }
            hasher.putInt(1).putString((CharSequence)key.rawString(), StandardCharsets.UTF_8).putInt(payload).putBytes(add.value().asByteBuffer());
            if (contentId != null) {
                hasher.putLong(contentId.getMostSignificantBits()).putLong(contentId.getLeastSignificantBits());
            }
            index.add(StoreIndexElement.indexElement(key, op));
        }
        if (!conflicts.isEmpty()) {
            throw new CommitConflictException(conflicts);
        }
        return c.incrementalIndex(index.serialize()).id(Hashes.hashAsObjId(hasher)).build();
    }

    private static void preprocessCommitActions(CreateCommit createCommit, Set<StoreKey> keys, Set<StoreKey> readdedKeys) {
        StoreKey key;
        HashSet removedKeys = Sets.newHashSetWithExpectedSize((int)createCommit.removes().size());
        for (CreateCommit.Remove remove : createCommit.removes()) {
            StoreKey key2 = remove.key();
            Preconditions.checkArgument((boolean)keys.add(key2), (Object)("Duplicate key: " + key2));
            removedKeys.add(key2);
        }
        HashSet seenContentIds = Sets.newHashSetWithExpectedSize((int)createCommit.adds().size());
        for (CreateCommit.Add add : createCommit.adds()) {
            UUID contentId;
            key = add.key();
            boolean unseenKey = keys.add(key);
            if (!unseenKey && removedKeys.remove(key)) {
                readdedKeys.add(key);
            } else {
                Preconditions.checkArgument((boolean)unseenKey, (Object)("Duplicate key: " + key));
            }
            if ((contentId = add.contentId()) == null) continue;
            Preconditions.checkArgument((boolean)seenContentIds.add(contentId), (Object)("Duplicate content ID: " + contentId + " for key: " + key));
        }
        for (CreateCommit.Unchanged unchanged : createCommit.unchanged()) {
            key = unchanged.key();
            Preconditions.checkArgument((boolean)keys.add(key), (Object)("Duplicate key: " + key));
        }
    }

    private static CommitConflict checkForConflict(StoreKey key, UUID contentId, int payload, CommitOp op, CommitOp existingContent, ObjId expectedValue) {
        CommitConflict conflict = null;
        if (expectedValue == null) {
            if (existingContent != null) {
                conflict = CommitConflict.commitConflict(key, CommitConflict.ConflictType.KEY_EXISTS, op, existingContent);
            }
        } else if (existingContent != null) {
            if (payload != existingContent.payload()) {
                conflict = CommitConflict.commitConflict(key, CommitConflict.ConflictType.PAYLOAD_DIFFERS, op, existingContent);
            } else if (!Objects.equals(contentId, existingContent.contentId())) {
                conflict = CommitConflict.commitConflict(key, CommitConflict.ConflictType.CONTENT_ID_DIFFERS, op, existingContent);
            } else if (!expectedValue.equals(existingContent.value())) {
                conflict = CommitConflict.commitConflict(key, CommitConflict.ConflictType.VALUE_DIFFERS, op, existingContent);
            }
        } else {
            conflict = CommitConflict.commitConflict(key, CommitConflict.ConflictType.KEY_DOES_NOT_EXIST, op);
        }
        return conflict;
    }

    private static CommitOp existingContentForCommit(StoreIndex<CommitOp> fullIndex, StoreKey key, boolean readded) {
        StoreIndexElement<CommitOp> existing = readded ? null : CommitLogicImpl.existingFromIndex(fullIndex, key);
        return existing != null ? existing.content() : null;
    }

    private static boolean handleConflict(@javax.annotation.Nonnull @Nonnull ConflictHandler conflictHandler, @javax.annotation.Nonnull @Nonnull List<CommitConflict> conflicts, @javax.annotation.Nonnull @Nonnull CommitConflict conflict) {
        ConflictHandler.ConflictResolution resolution = conflictHandler.onConflict(conflict);
        switch (resolution) {
            case CONFLICT: {
                conflicts.add(conflict);
                return true;
            }
            case IGNORE: {
                return false;
            }
            case DROP: {
                return true;
            }
        }
        throw new IllegalStateException("Unknown resolution " + (Object)((Object)resolution));
    }

    private static StoreIndexElement<CommitOp> existingFromIndex(StoreIndex<CommitOp> index, StoreKey key) {
        StoreIndexElement<CommitOp> existing = index.get(key);
        return existing != null && existing.content().action().exists() ? existing : null;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public ObjId findCommonAncestor(@javax.annotation.Nonnull @Nonnull ObjId headId, @javax.annotation.Nonnull @Nonnull ObjId otherId) throws NoSuchElementException {
        PagedResult<ObjId, ObjId> log1 = this.commitIdLog(CommitLogQuery.commitLogQuery(headId));
        PagedResult<ObjId, ObjId> log2 = this.commitIdLog(CommitLogQuery.commitLogQuery(otherId));
        ObjectHashSet commits1 = new ObjectHashSet();
        ObjectHashSet commits2 = new ObjectHashSet();
        if (!log2.hasNext() && !ObjId.EMPTY_OBJ_ID.equals(otherId)) {
            throw CommitLogicImpl.commonAncestorCommitNotFound(otherId);
        }
        if (!log1.hasNext() && !ObjId.EMPTY_OBJ_ID.equals(headId)) {
            throw CommitLogicImpl.commonAncestorCommitNotFound(headId);
        }
        while (true) {
            ObjId current1 = log1.hasNext() ? (ObjId)log1.next() : ObjId.EMPTY_OBJ_ID;
            ObjId current2 = log2.hasNext() ? (ObjId)log2.next() : ObjId.EMPTY_OBJ_ID;
            boolean eol1 = current1.equals(ObjId.EMPTY_OBJ_ID);
            boolean eol2 = current2.equals(ObjId.EMPTY_OBJ_ID);
            if (eol1 && eol2) {
                throw CommitLogicImpl.noCommonAncestor(headId, otherId);
            }
            if (!eol1) {
                if (commits2.contains((Object)current1)) {
                    return current1;
                }
                commits1.add((Object)current1);
            }
            if (eol2) continue;
            if (commits1.contains((Object)current2)) {
                return current2;
            }
            commits2.add((Object)current2);
        }
    }

    private static NoSuchElementException commonAncestorCommitNotFound(ObjId id) {
        return new NoSuchElementException("Commit '" + id + "' not found");
    }

    private static NoSuchElementException noCommonAncestor(ObjId headId, ObjId otherId) {
        return new NoSuchElementException(NO_COMMON_ANCESTOR_IN_PARENTS_OF + headId + " and " + otherId);
    }

    @Override
    @javax.annotation.Nullable
    @Nullable
    public CommitObj fetchCommit(@javax.annotation.Nonnull @Nonnull ObjId commitId) throws ObjNotFoundException {
        if (ObjId.EMPTY_OBJ_ID.equals(commitId)) {
            return null;
        }
        Obj obj = this.persist.fetchObj(commitId);
        if (obj instanceof CommitObjReference) {
            CommitObjReference commitRef = (CommitObjReference)((Object)obj);
            ObjId refCommitId = commitRef.commitId();
            if (ObjId.EMPTY_OBJ_ID.equals(refCommitId)) {
                return null;
            }
            obj = this.persist.fetchObj(refCommitId);
        }
        Preconditions.checkState((boolean)(obj instanceof CommitObj), (String)"Expected a Commit object, but got %s", (Object)obj);
        return (CommitObj)obj;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public PagedResult<DiffEntry, StoreKey> diff(@javax.annotation.Nonnull @Nonnull DiffQuery diffQuery) {
        IndexesLogic indexesLogic = Logics.indexesLogic(this.persist);
        StoreKey start = diffQuery.pagingToken().map(t -> StoreKey.keyFromString(t.token().toStringUtf8())).orElse(diffQuery.start());
        StoreKey end = diffQuery.end();
        StoreIndex<CommitOp> fromIndex = indexesLogic.buildCompleteIndexOrEmpty(diffQuery.fromCommit());
        StoreIndex<CommitOp> toIndex = indexesLogic.buildCompleteIndexOrEmpty(diffQuery.toCommit());
        Iterator<StoreIndexElement<CommitOp>> fromIter = fromIndex.iterator(start, end, diffQuery.prefetch());
        Iterator<StoreIndexElement<CommitOp>> toIter = toIndex.iterator(start, end, diffQuery.prefetch());
        return new DiffEntryIter(fromIter, toIter);
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public CreateCommit.Builder diffToCreateCommit(@javax.annotation.Nonnull @Nonnull PagedResult<DiffEntry, StoreKey> diff, @javax.annotation.Nonnull @Nonnull CreateCommit.Builder createCommit) {
        while (diff.hasNext()) {
            DiffEntry d = (DiffEntry)diff.next();
            if (d.fromId() == null) {
                createCommit.addAdds(CreateCommit.Add.commitAdd(d.key(), d.toPayload(), Objects.requireNonNull(d.toId()), null, d.toContentId()));
                continue;
            }
            if (d.toId() == null) {
                createCommit.addRemoves(CreateCommit.Remove.commitRemove(d.key(), d.fromPayload(), Objects.requireNonNull(d.fromId()), d.fromContentId()));
                continue;
            }
            createCommit.addAdds(CreateCommit.Add.commitAdd(d.key(), d.toPayload(), Objects.requireNonNull(d.toId()), d.fromId(), d.fromContentId()));
        }
        return createCommit;
    }

    @Override
    @javax.annotation.Nullable
    @Nullable
    public CommitObj headCommit(@javax.annotation.Nonnull @Nonnull Reference reference) throws ObjNotFoundException {
        return this.fetchCommit(reference.pointer());
    }

    @Override
    public HeadsAndForkPoints identifyAllHeadsAndForkPoints(int expectedCommitCount, Consumer<CommitObj> commitHandler) {
        long scanStartedAtInMicros = this.persist.config().currentTimeMicros();
        IdentifyHeadsAndForkPoints identify = new IdentifyHeadsAndForkPoints(expectedCommitCount, scanStartedAtInMicros);
        try (CloseableIterator<Obj> scan = this.persist.scanAllObjects(EnumSet.of(ObjType.COMMIT));){
            while (scan.hasNext()) {
                CommitObj commit = (CommitObj)scan.next();
                if (commit.commitType() == CommitType.INTERNAL || !identify.handleCommit(commit)) continue;
                commitHandler.accept(commit);
            }
        }
        return identify.finish();
    }

    private static final class DiffEntryIter
    extends AbstractIterator<DiffEntry>
    implements PagedResult<DiffEntry, StoreKey> {
        private final Iterator<StoreIndexElement<CommitOp>> fromIter;
        private final Iterator<StoreIndexElement<CommitOp>> toIter;
        private StoreIndexElement<CommitOp> fromElement;
        private StoreIndexElement<CommitOp> toElement;

        DiffEntryIter(Iterator<StoreIndexElement<CommitOp>> fromIter, Iterator<StoreIndexElement<CommitOp>> toIter) {
            this.fromIter = fromIter;
            this.toIter = toIter;
        }

        protected DiffEntry computeNext() {
            DiffEntry r;
            do {
                StoreKey toKey;
                if (this.fromElement == null) {
                    this.fromElement = this.next(this.fromIter);
                }
                if (this.toElement == null) {
                    this.toElement = this.next(this.toIter);
                }
                if (this.fromElement == null && this.toElement == null) {
                    return (DiffEntry)this.endOfData();
                }
                if (this.fromElement == null) {
                    return this.consumeTo();
                }
                if (this.toElement == null) {
                    return this.consumeFrom();
                }
                StoreKey fromKey = this.fromElement.key();
                int cmp = fromKey.compareTo(toKey = this.toElement.key());
                if (cmp < 0) {
                    return this.consumeFrom();
                }
                if (cmp <= 0) continue;
                return this.consumeTo();
            } while ((r = this.consumeBoth()) == null);
            return r;
        }

        private DiffEntry consumeBoth() {
            DiffEntry e = null;
            StoreIndexElement<CommitOp> f = this.fromElement;
            StoreIndexElement<CommitOp> t = this.toElement;
            CommitOp fc = f.content();
            CommitOp tc = t.content();
            if (!Objects.equals(f.content().value(), t.content().value())) {
                e = DiffEntry.diffEntry(t.key(), fc.value(), fc.payload(), fc.contentId(), tc.value(), tc.payload(), tc.contentId());
            }
            this.fromElement = null;
            this.toElement = null;
            return e;
        }

        private DiffEntry consumeTo() {
            StoreIndexElement<CommitOp> t = this.toElement;
            this.toElement = null;
            CommitOp c = t.content();
            return DiffEntry.diffEntry(t.key(), null, 0, null, c.value(), c.payload(), c.contentId());
        }

        private DiffEntry consumeFrom() {
            StoreIndexElement<CommitOp> f = this.fromElement;
            this.fromElement = null;
            CommitOp c = f.content();
            return DiffEntry.diffEntry(f.key(), c.value(), c.payload(), c.contentId(), null, 0, null);
        }

        private StoreIndexElement<CommitOp> next(Iterator<StoreIndexElement<CommitOp>> iter) {
            while (iter.hasNext()) {
                StoreIndexElement<CommitOp> el = iter.next();
                if (!el.content().action().exists()) continue;
                return el;
            }
            return null;
        }

        @Override
        @javax.annotation.Nonnull
        @Nonnull
        public PagingToken tokenForKey(StoreKey key) {
            return key != null ? PagingToken.pagingToken(ByteString.copyFromUtf8((String)key.rawString())) : PagingToken.emptyPagingToken();
        }
    }

    private final class CommitIdIter
    extends AbstractIterator<ObjId>
    implements PagedResult<ObjId, ObjId> {
        private final ObjId endCommitId;
        private Iterator<ObjId> batch;
        private List<ObjId> next;

        CommitIdIter(ObjId startCommitId, ObjId endCommitId) {
            this.next = Collections.singletonList(startCommitId);
            this.endCommitId = endCommitId;
        }

        protected ObjId computeNext() {
            Iterator<ObjId> b;
            do {
                if ((b = this.batch) != null && b.hasNext()) continue;
                List<ObjId> n = this.next;
                this.next = null;
                if (n == null) {
                    return (ObjId)this.endOfData();
                }
                int i = n.indexOf(ObjId.EMPTY_OBJ_ID);
                if (i != -1) {
                    n = n.subList(0, i);
                }
                if (n.isEmpty()) {
                    return (ObjId)this.endOfData();
                }
                b = this.batch = n.iterator();
            } while (!b.hasNext());
            ObjId c = b.next();
            if (c.equals(this.endCommitId)) {
                this.batch = Collections.emptyIterator();
                this.next = null;
            } else if (!b.hasNext()) {
                CommitObj obj;
                try {
                    obj = CommitLogicImpl.this.fetchCommit(c);
                }
                catch (ObjNotFoundException e) {
                    throw new NoSuchElementException("Commit '" + c + "' not found");
                }
                if (obj == null) {
                    return (ObjId)this.endOfData();
                }
                this.next = obj.tail();
            }
            return c;
        }

        @Override
        @javax.annotation.Nonnull
        @Nonnull
        public PagingToken tokenForKey(ObjId key) {
            return key != null ? PagingToken.pagingToken(key.asBytes()) : PagingToken.emptyPagingToken();
        }
    }

    private final class CommitLogIter
    extends AbstractIterator<CommitObj>
    implements PagedResult<CommitObj, ObjId> {
        private final ObjId endCommitId;
        private Iterator<Obj> batch;
        private List<ObjId> next;

        CommitLogIter(ObjId startCommitId, ObjId endCommitId) {
            this.next = Collections.singletonList(startCommitId);
            this.endCommitId = endCommitId;
        }

        protected CommitObj computeNext() {
            Iterator<Obj> b;
            do {
                if ((b = this.batch) != null && b.hasNext()) continue;
                List<ObjId> n = this.next;
                this.next = null;
                if (n == null) {
                    return (CommitObj)this.endOfData();
                }
                int i = n.indexOf(ObjId.EMPTY_OBJ_ID);
                if (i != -1) {
                    n = n.subList(0, i);
                }
                if (n.isEmpty()) {
                    return (CommitObj)this.endOfData();
                }
                try {
                    b = this.batch = Arrays.asList(CommitLogicImpl.this.persist.fetchObjs(n.toArray(new ObjId[0]))).iterator();
                }
                catch (ObjNotFoundException e) {
                    throw new NoSuchElementException("Commit(s) " + e.objIds().stream().map(ObjId::toString).collect(Collectors.joining(", ")) + " not found");
                }
            } while (!b.hasNext());
            CommitObj c = (CommitObj)b.next();
            if (c == null) {
                return (CommitObj)this.endOfData();
            }
            if (c.id().equals(this.endCommitId)) {
                this.batch = Collections.emptyIterator();
                this.next = null;
            } else if (!b.hasNext()) {
                this.next = c.tail();
            }
            return c;
        }

        @Override
        @javax.annotation.Nonnull
        @Nonnull
        public PagingToken tokenForKey(ObjId key) {
            return key != null ? PagingToken.pagingToken(key.asBytes()) : PagingToken.emptyPagingToken();
        }
    }
}

