/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.DiffQuery;
import org.projectnessie.versioned.storage.common.logic.PageableQuery;
import org.projectnessie.versioned.storage.common.logic.PagingToken;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DiffQuery", generator="Immutables")
@Immutable
public final class ImmutableDiffQuery
implements DiffQuery {
    @Nullable
    private final PagingToken pagingToken;
    @jakarta.annotation.Nullable
    private final CommitObj fromCommit;
    @jakarta.annotation.Nullable
    private final CommitObj toCommit;
    @jakarta.annotation.Nullable
    private final StoreKey start;
    @jakarta.annotation.Nullable
    private final StoreKey end;
    private final boolean prefetch;

    private ImmutableDiffQuery(Optional<? extends PagingToken> pagingToken, @jakarta.annotation.Nullable CommitObj fromCommit, @jakarta.annotation.Nullable CommitObj toCommit, @jakarta.annotation.Nullable StoreKey start, @jakarta.annotation.Nullable StoreKey end, boolean prefetch) {
        this.pagingToken = pagingToken.orElse(null);
        this.fromCommit = fromCommit;
        this.toCommit = toCommit;
        this.start = start;
        this.end = end;
        this.prefetch = prefetch;
    }

    private ImmutableDiffQuery(ImmutableDiffQuery original, @Nullable PagingToken pagingToken, @jakarta.annotation.Nullable CommitObj fromCommit, @jakarta.annotation.Nullable CommitObj toCommit, @jakarta.annotation.Nullable StoreKey start, @jakarta.annotation.Nullable StoreKey end, boolean prefetch) {
        this.pagingToken = pagingToken;
        this.fromCommit = fromCommit;
        this.toCommit = toCommit;
        this.start = start;
        this.end = end;
        this.prefetch = prefetch;
    }

    @Override
    public Optional<PagingToken> pagingToken() {
        return Optional.ofNullable(this.pagingToken);
    }

    @Override
    @jakarta.annotation.Nullable
    public CommitObj fromCommit() {
        return this.fromCommit;
    }

    @Override
    @jakarta.annotation.Nullable
    public CommitObj toCommit() {
        return this.toCommit;
    }

    @Override
    @jakarta.annotation.Nullable
    public StoreKey start() {
        return this.start;
    }

    @Override
    @jakarta.annotation.Nullable
    public StoreKey end() {
        return this.end;
    }

    @Override
    public boolean prefetch() {
        return this.prefetch;
    }

    public final ImmutableDiffQuery withPagingToken(PagingToken value) {
        PagingToken newValue = Objects.requireNonNull(value, "pagingToken");
        if (this.pagingToken == newValue) {
            return this;
        }
        return new ImmutableDiffQuery(this, newValue, this.fromCommit, this.toCommit, this.start, this.end, this.prefetch);
    }

    public final ImmutableDiffQuery withPagingToken(Optional<? extends PagingToken> optional) {
        PagingToken value = optional.orElse(null);
        if (this.pagingToken == value) {
            return this;
        }
        return new ImmutableDiffQuery(this, value, this.fromCommit, this.toCommit, this.start, this.end, this.prefetch);
    }

    public final ImmutableDiffQuery withFromCommit(@jakarta.annotation.Nullable CommitObj value) {
        if (this.fromCommit == value) {
            return this;
        }
        return new ImmutableDiffQuery(this, this.pagingToken, value, this.toCommit, this.start, this.end, this.prefetch);
    }

    public final ImmutableDiffQuery withToCommit(@jakarta.annotation.Nullable CommitObj value) {
        if (this.toCommit == value) {
            return this;
        }
        return new ImmutableDiffQuery(this, this.pagingToken, this.fromCommit, value, this.start, this.end, this.prefetch);
    }

    public final ImmutableDiffQuery withStart(@jakarta.annotation.Nullable StoreKey value) {
        if (this.start == value) {
            return this;
        }
        return new ImmutableDiffQuery(this, this.pagingToken, this.fromCommit, this.toCommit, value, this.end, this.prefetch);
    }

    public final ImmutableDiffQuery withEnd(@jakarta.annotation.Nullable StoreKey value) {
        if (this.end == value) {
            return this;
        }
        return new ImmutableDiffQuery(this, this.pagingToken, this.fromCommit, this.toCommit, this.start, value, this.prefetch);
    }

    public final ImmutableDiffQuery withPrefetch(boolean value) {
        if (this.prefetch == value) {
            return this;
        }
        return new ImmutableDiffQuery(this, this.pagingToken, this.fromCommit, this.toCommit, this.start, this.end, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDiffQuery && this.equalTo(0, (ImmutableDiffQuery)another);
    }

    private boolean equalTo(int synthetic, ImmutableDiffQuery another) {
        return Objects.equals(this.pagingToken, another.pagingToken) && Objects.equals(this.fromCommit, another.fromCommit) && Objects.equals(this.toCommit, another.toCommit) && Objects.equals(this.start, another.start) && Objects.equals(this.end, another.end) && this.prefetch == another.prefetch;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.pagingToken);
        h += (h << 5) + Objects.hashCode(this.fromCommit);
        h += (h << 5) + Objects.hashCode(this.toCommit);
        h += (h << 5) + Objects.hashCode(this.start);
        h += (h << 5) + Objects.hashCode(this.end);
        h += (h << 5) + Booleans.hashCode((boolean)this.prefetch);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DiffQuery").omitNullValues().add("pagingToken", (Object)this.pagingToken).add("fromCommit", (Object)this.fromCommit).add("toCommit", (Object)this.toCommit).add("start", (Object)this.start).add("end", (Object)this.end).add("prefetch", this.prefetch).toString();
    }

    public static ImmutableDiffQuery of(Optional<? extends PagingToken> pagingToken, @jakarta.annotation.Nullable CommitObj fromCommit, @jakarta.annotation.Nullable CommitObj toCommit, @jakarta.annotation.Nullable StoreKey start, @jakarta.annotation.Nullable StoreKey end, boolean prefetch) {
        return new ImmutableDiffQuery(pagingToken, fromCommit, toCommit, start, end, prefetch);
    }

    public static ImmutableDiffQuery copyOf(DiffQuery instance) {
        if (instance instanceof ImmutableDiffQuery) {
            return (ImmutableDiffQuery)instance;
        }
        return ImmutableDiffQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DiffQuery", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PREFETCH = 1L;
        private long initBits = 1L;
        @Nullable
        private PagingToken pagingToken;
        @Nullable
        private CommitObj fromCommit;
        @Nullable
        private CommitObj toCommit;
        @Nullable
        private StoreKey start;
        @Nullable
        private StoreKey end;
        private boolean prefetch;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DiffQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PageableQuery instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PageableQuery instance;
            long bits = 0L;
            if (object instanceof DiffQuery) {
                CommitObj fromCommitValue;
                StoreKey endValue;
                CommitObj toCommitValue;
                instance = (DiffQuery)object;
                StoreKey startValue = instance.start();
                if (startValue != null) {
                    this.start(startValue);
                }
                if ((toCommitValue = instance.toCommit()) != null) {
                    this.toCommit(toCommitValue);
                }
                if ((endValue = instance.end()) != null) {
                    this.end(endValue);
                }
                if ((fromCommitValue = instance.fromCommit()) != null) {
                    this.fromCommit(fromCommitValue);
                }
                if ((bits & 1L) == 0L) {
                    Optional<PagingToken> pagingTokenOptional = instance.pagingToken();
                    if (pagingTokenOptional.isPresent()) {
                        this.pagingToken(pagingTokenOptional);
                    }
                    bits |= 1L;
                }
                this.prefetch(instance.prefetch());
            }
            if (object instanceof PageableQuery) {
                instance = (PageableQuery)object;
                if ((bits & 1L) == 0L) {
                    Optional<PagingToken> pagingTokenOptional = instance.pagingToken();
                    if (pagingTokenOptional.isPresent()) {
                        this.pagingToken(pagingTokenOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder pagingToken(PagingToken pagingToken) {
            this.pagingToken = Objects.requireNonNull(pagingToken, "pagingToken");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pagingToken(Optional<? extends PagingToken> pagingToken) {
            this.pagingToken = pagingToken.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fromCommit(@jakarta.annotation.Nullable CommitObj fromCommit) {
            this.fromCommit = fromCommit;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toCommit(@jakarta.annotation.Nullable CommitObj toCommit) {
            this.toCommit = toCommit;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder start(@jakarta.annotation.Nullable StoreKey start) {
            this.start = start;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder end(@jakarta.annotation.Nullable StoreKey end) {
            this.end = end;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder prefetch(boolean prefetch) {
            this.prefetch = prefetch;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDiffQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDiffQuery(null, this.pagingToken, this.fromCommit, this.toCommit, this.start, this.end, this.prefetch);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("prefetch");
            }
            return "Cannot build DiffQuery, some of required attributes are not set " + attributes;
        }
    }
}

