/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RefConditionFailedException;
import org.projectnessie.versioned.storage.common.exceptions.RefNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.RetryTimeoutException;
import org.projectnessie.versioned.storage.common.logic.PagedResult;
import org.projectnessie.versioned.storage.common.logic.ReferencesQuery;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.Reference;

public interface ReferenceLogic {
    @javax.annotation.Nonnull
    @Nonnull
    public List<Reference> getReferences(@javax.annotation.Nonnull @Nonnull List<String> var1);

    @javax.annotation.Nonnull
    @Nonnull
    default public Reference getReference(@javax.annotation.Nonnull @Nonnull String name) throws RefNotFoundException {
        List<Reference> refs = this.getReferences(Collections.singletonList(name));
        Reference ref = refs.get(0);
        if (ref == null) {
            throw new RefNotFoundException(name);
        }
        return ref;
    }

    @javax.annotation.Nonnull
    @Nonnull
    public PagedResult<Reference, String> queryReferences(@javax.annotation.Nonnull @Nonnull ReferencesQuery var1);

    @javax.annotation.Nonnull
    @Nonnull
    public Reference createReference(@javax.annotation.Nonnull @Nonnull String var1, @javax.annotation.Nonnull @Nonnull ObjId var2) throws RefAlreadyExistsException, RetryTimeoutException;

    public void deleteReference(@javax.annotation.Nonnull @Nonnull String var1, @javax.annotation.Nonnull @Nonnull ObjId var2) throws RefNotFoundException, RefConditionFailedException, RetryTimeoutException;

    @javax.annotation.Nonnull
    @Nonnull
    public Reference assignReference(@javax.annotation.Nonnull @Nonnull Reference var1, @javax.annotation.Nonnull @Nonnull ObjId var2) throws RefNotFoundException, RefConditionFailedException;
}

