/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.Compression;
import org.projectnessie.versioned.storage.common.objtypes.IndexStripe;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;

public final class Hashes {
    private Hashes() {
    }

    public static Hasher newHasher() {
        return Hashing.sha256().newHasher();
    }

    public static ObjId hashAsObjId(Hasher hasher) {
        return ObjId.objIdFromByteArray(hasher.hash().asBytes());
    }

    static ObjId indexSegmentsHash(List<IndexStripe> stripes) {
        Hasher hasher = Hashes.newHasher();
        hasher.putString((CharSequence)ObjType.INDEX_SEGMENTS.name(), StandardCharsets.UTF_8);
        for (IndexStripe indexStripe : stripes) {
            hasher.putString((CharSequence)indexStripe.firstKey().rawString(), StandardCharsets.UTF_8);
            hasher.putString((CharSequence)indexStripe.lastKey().rawString(), StandardCharsets.UTF_8);
            hasher.putBytes(indexStripe.segment().asByteBuffer());
        }
        return Hashes.hashAsObjId(hasher);
    }

    static ObjId indexHash(ByteString idx) {
        return Hashes.hashAsObjId(Hashes.indexHash(Hashes.newHasher().putString((CharSequence)ObjType.INDEX.name(), StandardCharsets.UTF_8), idx));
    }

    static Hasher indexHash(Hasher hasher, ByteString idx) {
        return hasher.putBytes(idx.asReadOnlyByteBuffer());
    }

    static ObjId contentValueHash(String contentId, int payload, ByteString data) {
        Hasher hasher = Hashes.newHasher().putString((CharSequence)ObjType.VALUE.name(), StandardCharsets.UTF_8).putString((CharSequence)contentId, StandardCharsets.UTF_8).putInt(payload).putBytes(data.asReadOnlyByteBuffer());
        return Hashes.hashAsObjId(hasher);
    }

    static ObjId refHash(String name, ObjId initialPointer, long createdAtMicros) {
        Hasher hasher = Hashes.newHasher().putString((CharSequence)ObjType.REF.name(), StandardCharsets.UTF_8).putString((CharSequence)name, StandardCharsets.UTF_8).putBytes(initialPointer.asByteArray()).putLong(createdAtMicros);
        return Hashes.hashAsObjId(hasher);
    }

    static ObjId tagHash(ObjId commitId, String message, CommitHeaders headers, ByteString signature) {
        Hasher hasher = Hashes.newHasher().putString((CharSequence)ObjType.TAG.name(), StandardCharsets.UTF_8).putBytes(commitId.asByteArray());
        if (message != null) {
            hasher.putString((CharSequence)message, StandardCharsets.UTF_8);
        }
        if (headers != null) {
            Hashes.hashCommitHeaders(hasher, headers);
        }
        if (signature != null) {
            hasher.putBytes(signature.asReadOnlyByteBuffer());
        }
        return Hashes.hashAsObjId(hasher);
    }

    public static void hashCommitHeaders(Hasher hasher, CommitHeaders headers) {
        for (String header : headers.keySet()) {
            hasher.putString((CharSequence)header, StandardCharsets.UTF_8);
            List<String> values = headers.getAll(header);
            for (String value : values) {
                hasher.putString((CharSequence)value, StandardCharsets.UTF_8);
            }
        }
    }

    static ObjId stringDataHash(String contentType, Compression compression, String filename, List<ObjId> predecessors, ByteString text) {
        Hasher hasher = Hashes.newHasher().putString((CharSequence)ObjType.STRING.name(), StandardCharsets.UTF_8).putString((CharSequence)contentType, StandardCharsets.UTF_8).putChar(compression.value());
        if (filename != null) {
            hasher.putString((CharSequence)filename, StandardCharsets.UTF_8);
        }
        predecessors.forEach(id -> hasher.putBytes(id.asByteArray()));
        hasher.putBytes(text.asReadOnlyByteBuffer());
        return Hashes.hashAsObjId(hasher);
    }
}

