/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.CommitObjReference;
import org.projectnessie.versioned.storage.common.objtypes.Hashes;
import org.projectnessie.versioned.storage.common.objtypes.ImmutableTagObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;

@Value.Immutable
public interface TagObj
extends Obj,
CommitObjReference {
    @Override
    default public ObjType type() {
        return ObjType.TAG;
    }

    @Override
    @Nullable
    @jakarta.annotation.Nullable
    @Value.Parameter(order=1)
    public ObjId id();

    @Override
    @Value.Parameter(order=2)
    public ObjId commitId();

    @Nullable
    @jakarta.annotation.Nullable
    @Value.Parameter(order=3)
    public String message();

    @Nullable
    @jakarta.annotation.Nullable
    @Value.Parameter(order=4)
    public CommitHeaders headers();

    @Nullable
    @jakarta.annotation.Nullable
    @Value.Parameter(order=5)
    public ByteString signature();

    public static TagObj tag(ObjId id, ObjId commitId, String message, CommitHeaders headers, ByteString signature) {
        return ImmutableTagObj.of(id, commitId, message, headers, signature);
    }

    public static TagObj tag(ObjId commitId, String message, CommitHeaders headers, ByteString signature) {
        return TagObj.tag(Hashes.tagHash(commitId, message, headers, signature), commitId, message, headers, signature);
    }
}

